/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git;

import com.atlassian.bitbucket.dmz.repository.DmzRepository;
import com.atlassian.bitbucket.dmz.server.DataStore;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.git.GitException;
import com.atlassian.bitbucket.scm.git.GitNotFoundException;
import com.atlassian.bitbucket.scm.git.GitUnsupportedVersionException;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.util.MoreFiles;
import com.atlassian.bitbucket.util.Version;
import com.atlassian.stash.internal.HomeLayout;
import com.atlassian.stash.internal.scm.git.GitScmConfig;
import com.atlassian.stash.internal.scm.git.binary.GitBinary;
import com.atlassian.stash.internal.scm.git.binary.GitBinaryHelper;
import com.atlassian.stash.internal.scm.git.binary.RejectedGitBinary;
import com.atlassian.stash.internal.server.DataStoreLayout;
import com.atlassian.stash.internal.server.InternalStorageService;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Eithers;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.nio.file.Path;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class DefaultGitScmConfig
implements GitScmConfig {
    public static final Set<String> CORE_BINARIES = ImmutableSet.of((Object)"http-backend", (Object)"upload-pack");
    public static final long MAX_WORKTREE_EXPIRY_MINUTES = TimeUnit.DAYS.toMinutes(1L);
    public static final long MINIMUM_WORKTREE_EXPIRY_MINUTES = 2L;
    public static final String PROP_BINARY_PATH = "path.executable";
    public static final String PROP_DEADLINE_PADDING_FOR_HOOKS = "mesh.rpc.deadline-padding.hooks";
    public static final String PROP_ENVIRONMENT_COMMAND_SIZE = "environment.commandsize";
    public static final String PROP_ENVIRONMENT_VARIABLE_SIZE = "environment.variablesize";
    public static final String PROP_EXPORT_GC_PAUSE_TIMEOUT = "export.gc-pause.timeout";
    public static final String PROP_GC_DELAY = "gc.delay";
    public static final String PROP_GC_LOG_RETENTION = "gc.log.retention";
    public static final String PROP_GC_MAX_ATTEMPTS = "gc.max.attempts";
    public static final String PROP_GC_THREADS = "gc.threads";
    public static final String PROP_GRPC_KEEP_ALIVE_TIME = "mesh.grpc.client.keep-alive.time";
    public static final String PROP_GRPC_KEEP_ALIVE_WITHOUT_CALLS = "mesh.grpc.client.keep-alive.without-calls";
    public static final String PROP_GRPC_MAX_FRAGMENT_SIZE = "mesh.grpc.max-fragment-size";
    public static final String PROP_GRPC_MAX_MESSAGE_SIZE = "mesh.grpc.max-message-size";
    public static final String PROP_GRPC_MAX_METADATA_SIZE = "mesh.grpc.max-metadata-size";
    public static final String PROP_GRPC_STREAMING_GETCOMMITS_THRESHOLD = "mesh.grpc.streaming-getcommits.threshold";
    public static final String PROP_HOSTING_ALLOW_FILTER = "hosting.allow-filter";
    public static final String PROP_HOSTING_EXECUTION_TIMEOUT = "hosting.timeout.execution";
    public static final String PROP_HOSTING_IDLE_TIMEOUT = "hosting.timeout.idle";
    public static final String PROP_LIBEXEC_PATH = "path.libexec";
    public static final String PROP_PACKREFS_INTERVAL = "packrefs.interval";
    public static final String PROP_PACKREFS_TIMEOUT = "packrefs.timeout";
    public static final String PROP_PREFIX = "plugin.bitbucket-git.";
    public static final String PROP_PULL_REQUEST_OPERATION_TIMEOUT = "pullrequest.operation.timeout";
    public static final String PROP_REBASE_TIMEOUT = "pullrequest.rebase.timeout";
    public static final String PROP_REPACK_INTERVAL = "repack.interval";
    public static final String PROP_REPACK_THRESHOLD_LOOSE = "repack.threshold.loose";
    public static final String PROP_REPACK_THRESHOLD_LOOSE_SIZE = "repack.threshold.loose-size";
    public static final String PROP_REPACK_THRESHOLD_PACK = "repack.threshold.pack";
    public static final String PROP_REPACK_TIMEOUT = "repack.timeout";
    public static final String PROP_SIZE_TIMEOUT = "repository.size.timeout";
    public static final String PROP_SSH_BINARY = "ssh.binary";
    public static final String PROP_THROTTLE_REF_ADVERTISEMENT = "throttle.ref.advertisement";
    public static final String PROP_USE_ALTERNATES = "forks.usealternates";
    public static final String PROP_WORKTREE_EXPIRY = "worktree.expiry";
    private static final Logger log = LoggerFactory.getLogger(DefaultGitScmConfig.class);
    private static final int MINIMUM_ENVIRONMENT_COMMAND_SIZE = 8000;
    private static final int MINIMUM_ENVIRONMENT_VARIABLE_SIZE = 2000;
    private static final long MINIMUM_GC_DELAY_SECONDS = 30L;
    private static final long MINIMUM_HOSTING_EXECUTION_TIMEOUT_SECONDS = TimeUnit.MINUTES.toSeconds(5L);
    private static final long MINIMUM_HOSTING_IDLE_TIMEOUT_SECONDS = TimeUnit.MINUTES.toSeconds(2L);
    private static final long MINIMUM_PACKREFS_INTERVAL_MINUTES = 5L;
    private static final long MINIMUM_PACKREFS_TIMEOUT_SECONDS = TimeUnit.MINUTES.toSeconds(2L);
    private static final long MINIMUM_REBASE_TIMEOUT_SECONDS = 60L;
    private static final long MINIMUM_REPACK_INTERVAL_MINUTES = 30L;
    private static final int MINIMUM_REPACK_THRESHOLD_LOOSE = 1000;
    private static final long MINIMUM_REPACK_THRESHOLD_LOOSE_SIZE = 0x1900000L;
    private static final int MINIMUM_REPACK_THRESHOLD_PACK = 1;
    private static final long MINIMUM_REPACK_TIMEOUT_SECONDS = TimeUnit.MINUTES.toSeconds(5L);
    private static final String GIT_ASK_PASS_SCRIPT = "ask-pass.pl";
    private static final String GIT_PACK_OBJECTS_SCRIPT = "pack-objects.sh";
    private static final String GIT_SSH_SCRIPT = "ssh-git";
    private static final long DEFAULT_DEADLINE_PADDING_FOR_HOOKS = 90L;
    private static final int DEFAULT_ENVIRONMENT_COMMAND_SIZE = 32000;
    private static final int DEFAULT_ENVIRONMENT_VARIABLE_SIZE = 16000;
    private static final int DEFAULT_EXPORT_GC_PAUSE_TIMEOUT_SECONDS = 60;
    private static final long DEFAULT_GC_DELAY_SECONDS = TimeUnit.MINUTES.toSeconds(1L);
    private static final long DEFAULT_GC_LOG_RETENTION = 30L;
    private static final int DEFAULT_GC_MAX_ATTEMPTS = 3;
    private static final int DEFAULT_GC_THREADS = 3;
    private static final long DEFAULT_GRPC_KEEP_ALIVE_TIME = 45L;
    private static final int DEFAULT_GRPC_MAX_FRAGMENT_SIZE = 0x300000;
    private static final int DEFAULT_GRPC_MAX_MESSAGE_SIZE = 0x400000;
    private static final int DEFAULT_GRPC_MAX_METADATA_SIZE = 65536;
    private static final int DEFAULT_GRPC_STREAMING_GETCOMMITS_THRESHOLD = 1000;
    private static final long DEFAULT_HOSTING_EXECUTION_TIMEOUT_SECONDS = TimeUnit.DAYS.toSeconds(1L);
    private static final long DEFAULT_HOSTING_IDLE_TIMEOUT_SECONDS = TimeUnit.MINUTES.toSeconds(30L);
    private static final long DEFAULT_PACKREFS_INTERVAL_MINUTES = TimeUnit.HOURS.toMinutes(1L);
    private static final long DEFAULT_PACKREFS_TIMEOUT_SECONDS = TimeUnit.MINUTES.toSeconds(10L);
    private static final long DEFAULT_PULL_REQUEST_OPERATION_TIMEOUT = TimeUnit.MINUTES.toSeconds(2L);
    private static final long DEFAULT_REBASE_TIMEOUT_SECONDS = 300L;
    private static final long DEFAULT_REPACK_INTERVAL_MINUTES = TimeUnit.HOURS.toMinutes(16L);
    private static final int DEFAULT_REPACK_THRESHOLD_LOOSE = 6700;
    private static final long DEFAULT_REPACK_THRESHOLD_LOOSE_SIZE = 0x10000000L;
    private static final int DEFAULT_REPACK_THRESHOLD_PACK = 50;
    private static final long DEFAULT_REPACK_TIMEOUT_SECONDS = TimeUnit.DAYS.toSeconds(2L);
    private static final long DEFAULT_SIZE_TIMEOUT_MILLIS = 75L;
    private static final String DEFAULT_SSH_BINARY = "ssh";
    private static final long DEFAULT_WORKTREE_EXPIRY_MINUTES = 30L;
    private final Path askPassScript;
    private final Either<RejectedGitBinary, GitBinary> binary;
    private final GitBinaryHelper binaryHelper;
    private final Path configDir;
    private final String coreBinaryPrefix;
    private final HomeLayout homeLayout;
    private final I18nService i18nService;
    private final Path packObjectsScript;
    private final ApplicationPropertiesService propertiesService;
    private final Path sshScript;
    private final InternalStorageService storageService;
    private final Path templateDir;
    private final Path tempDir;
    @Value(value="${commit.message.max}")
    private int maxMessageLength;

    public DefaultGitScmConfig(GitBinaryHelper binaryHelper, HomeLayout homeLayout, I18nService i18nService, ApplicationPropertiesService propertiesService, InternalStorageService storageService) {
        this.binaryHelper = binaryHelper;
        this.homeLayout = homeLayout;
        this.i18nService = i18nService;
        this.propertiesService = propertiesService;
        this.storageService = storageService;
        this.binary = this.findBinary();
        if (this.binary.isRight()) {
            log.debug("git executable has been set to {}", this.binary.right().get());
        }
        Path scriptsDir = MoreFiles.mkdir((Path)storageService.getBinDir(), (String)"git-scripts");
        this.askPassScript = scriptsDir.resolve(GIT_ASK_PASS_SCRIPT).toAbsolutePath();
        this.configDir = MoreFiles.mkdir((Path)storageService.getConfigDir(), (String)"git");
        this.coreBinaryPrefix = this.configureLibexec();
        this.packObjectsScript = scriptsDir.resolve(GIT_PACK_OBJECTS_SCRIPT).toAbsolutePath();
        this.sshScript = scriptsDir.resolve(DefaultGitScmConfig.getSshScriptName()).toAbsolutePath();
        this.tempDir = MoreFiles.mkdir((Path)storageService.getTempDir(), (String)"git");
        this.templateDir = MoreFiles.mkdir((Path)this.configDir, (String)"templates");
    }

    @Override
    @Nonnull
    public Path getAskPassScript() {
        return this.askPassScript;
    }

    @Override
    @Nonnull
    public String getBinary() {
        return ((GitBinary)Eithers.getOrThrow(this.resolveException())).getPath();
    }

    @Override
    public int getCommandLineSize() {
        return this.getBoundedProperty(PROP_ENVIRONMENT_COMMAND_SIZE, 32000, 8000);
    }

    @Override
    @Nonnull
    public Path getConfigDir() {
        return this.configDir;
    }

    @Override
    @Nonnull
    public Path getConfigDir(DataStore dataStore) {
        Objects.requireNonNull(dataStore);
        switch (dataStore.getType()) {
            case SHARED_HOME: {
                return this.getConfigDir();
            }
            case DISTRIBUTED: {
                return DataStoreLayout.getRepositoriesDir((DataStore)dataStore).resolve("config").resolve("git");
            }
        }
        throw new IllegalArgumentException("Data stores of type " + String.valueOf(dataStore.getType()) + " do not have config directories");
    }

    @Override
    @Nonnull
    public List<String> getCoreBinary(@Nonnull String command) {
        Objects.requireNonNull(command, "command");
        if (this.coreBinaryPrefix != null && CORE_BINARIES.contains(command)) {
            return Lists.newArrayList((Object[])new String[]{this.binaryHelper.applyExtension(this.coreBinaryPrefix + command)});
        }
        log.trace("Invoking {} {} because no core binary is available", (Object)this.getBinary(), (Object)command);
        return Lists.newArrayList((Object[])new String[]{this.getBinary(), command});
    }

    @Override
    @Nonnull
    public Duration getDeadlinePaddingForHooks() {
        return Duration.ofSeconds(this.getProperty(PROP_DEADLINE_PADDING_FOR_HOOKS, 90L));
    }

    @Override
    public int getEnvironmentVariableSize() {
        return this.getBoundedProperty(PROP_ENVIRONMENT_VARIABLE_SIZE, 16000, 2000);
    }

    @Override
    @Nonnull
    public Duration getExportGcPauseTimeout() {
        return Duration.ofSeconds(this.getProperty(PROP_EXPORT_GC_PAUSE_TIMEOUT, 60));
    }

    @Override
    @Nonnull
    public Duration getGcDelay() {
        return Duration.ofSeconds(this.getBoundedProperty(PROP_GC_DELAY, DEFAULT_GC_DELAY_SECONDS, 30L));
    }

    @Override
    @Nonnull
    public Duration getGcLogRetention() {
        return Duration.ofDays(this.getBoundedProperty(PROP_GC_LOG_RETENTION, 30L, 0L));
    }

    @Override
    public int getGcMaxAttempts() {
        return this.getProperty(PROP_GC_MAX_ATTEMPTS, 3);
    }

    @Override
    public int getGcThreads() {
        return this.getProperty(PROP_GC_THREADS, 3);
    }

    @Override
    @Nonnull
    public Duration getGrpcKeepAliveTime() {
        return Duration.ofSeconds(this.getProperty(PROP_GRPC_KEEP_ALIVE_TIME, 45L));
    }

    @Override
    public int getGrpcMaxFragmentSize() {
        return this.getProperty(PROP_GRPC_MAX_FRAGMENT_SIZE, 0x300000);
    }

    @Override
    public int getGrpcMaxMessageSize() {
        return this.getProperty(PROP_GRPC_MAX_MESSAGE_SIZE, 0x400000);
    }

    @Override
    public int getGrpcMaxMetadataSize() {
        return this.getProperty(PROP_GRPC_MAX_METADATA_SIZE, 65536);
    }

    @Override
    public int getGrpcStreamingGetCommitsThreshold() {
        return this.getProperty(PROP_GRPC_STREAMING_GETCOMMITS_THRESHOLD, 1000);
    }

    @Override
    @Nonnull
    public Path getHooksDir() {
        return this.getConfigDir().resolve("hooks");
    }

    @Override
    @Nonnull
    public Path getHooksDir(@Nonnull DataStore dataStore) {
        return this.getConfigDir(dataStore).resolve("hooks");
    }

    @Override
    @Nonnull
    public Path getHooksDir(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        if (repository instanceof DmzRepository) {
            return ((DmzRepository)repository).getDataStore().map(this::getHooksDir).orElseGet(this::getHooksDir);
        }
        return this.getHooksDir();
    }

    @Override
    @Nonnull
    public Duration getHostingExecutionTimeout() {
        return Duration.ofSeconds(this.getBoundedProperty(PROP_HOSTING_EXECUTION_TIMEOUT, DEFAULT_HOSTING_EXECUTION_TIMEOUT_SECONDS, MINIMUM_HOSTING_EXECUTION_TIMEOUT_SECONDS));
    }

    @Override
    @Nonnull
    public Duration getHostingIdleTimeout() {
        return Duration.ofSeconds(this.getBoundedProperty(PROP_HOSTING_IDLE_TIMEOUT, DEFAULT_HOSTING_IDLE_TIMEOUT_SECONDS, MINIMUM_HOSTING_IDLE_TIMEOUT_SECONDS));
    }

    @Override
    @Nonnull
    public Optional<Version> getInstalledVersion() {
        return (Optional)this.binary.right().toOption().fold(Optional::empty, binary -> Optional.ofNullable(binary).map(GitBinary::getVersion));
    }

    @Override
    public int getMaxMessageLength() {
        return this.maxMessageLength;
    }

    @Override
    @Nonnull
    public Path getObjectsDir(@Nonnull Repository repository) {
        return this.getRepositoryDir(repository).resolve("objects");
    }

    @Override
    @Nonnull
    public Path getPackObjectsScript() {
        return this.packObjectsScript;
    }

    @Override
    @Nonnull
    public Duration getPackRefsInterval() {
        return Duration.ofMinutes(this.getBoundedProperty(PROP_PACKREFS_INTERVAL, DEFAULT_PACKREFS_INTERVAL_MINUTES, 5L));
    }

    @Override
    @Nonnull
    public Duration getPackRefsTimeout() {
        return Duration.ofSeconds(this.getBoundedProperty(PROP_PACKREFS_TIMEOUT, DEFAULT_PACKREFS_TIMEOUT_SECONDS, MINIMUM_PACKREFS_TIMEOUT_SECONDS));
    }

    @Override
    public String getProperty(@Nonnull String propertyName) {
        return this.propertiesService.getPluginProperty(PROP_PREFIX + Objects.requireNonNull(propertyName, "propertyName"));
    }

    @Override
    public boolean getProperty(@Nonnull String propertyName, boolean defaultValue) {
        return this.propertiesService.getPluginProperty(PROP_PREFIX + Objects.requireNonNull(propertyName, "propertyName"), defaultValue);
    }

    @Override
    public int getProperty(@Nonnull String propertyName, int defaultValue) {
        return this.propertiesService.getPluginProperty(PROP_PREFIX + Objects.requireNonNull(propertyName, "propertyName"), defaultValue);
    }

    @Override
    public long getProperty(@Nonnull String propertyName, long defaultValue) {
        return this.propertiesService.getPluginProperty(PROP_PREFIX + Objects.requireNonNull(propertyName, "propertyName"), defaultValue);
    }

    @Override
    @Nonnull
    public String getProperty(@Nonnull String propertyName, @Nonnull String defaultValue) {
        return this.propertiesService.getPluginProperty(PROP_PREFIX + Objects.requireNonNull(propertyName, "propertyName"), Objects.requireNonNull(defaultValue, "defaultValue"));
    }

    @Override
    @Nonnull
    public Duration getPullRequestOperationTimeout() {
        return Duration.ofSeconds(this.getProperty(PROP_PULL_REQUEST_OPERATION_TIMEOUT, DEFAULT_PULL_REQUEST_OPERATION_TIMEOUT));
    }

    @Override
    @Nonnull
    public Duration getRebaseTimeout() {
        return Duration.ofSeconds(this.getBoundedProperty(PROP_REBASE_TIMEOUT, 300L, 60L));
    }

    @Override
    @Nonnull
    public String getRelativePath(@Nonnull Repository repository, @Nonnull Repository relativeTo) {
        String relativePath;
        Path repositoryDir = this.getRepositoryDir(repository);
        Path relativeDir = this.getRepositoryDir(Objects.requireNonNull(relativeTo, "relativeTo"));
        String absolutePath = repositoryDir.toAbsolutePath().toString();
        try {
            relativePath = relativeDir.relativize(repositoryDir).toString();
        }
        catch (IllegalArgumentException e) {
            return absolutePath;
        }
        return relativePath.length() < absolutePath.length() ? relativePath : absolutePath;
    }

    @Override
    @Nonnull
    public Duration getRepackInterval() {
        return Duration.ofMinutes(this.getBoundedProperty(PROP_REPACK_INTERVAL, DEFAULT_REPACK_INTERVAL_MINUTES, 30L));
    }

    @Override
    public int getRepackThresholdLoose() {
        return this.getBoundedProperty(PROP_REPACK_THRESHOLD_LOOSE, 6700, 1000);
    }

    @Override
    public long getRepackThresholdLooseSize() {
        return this.getBoundedProperty(PROP_REPACK_THRESHOLD_LOOSE_SIZE, 0x10000000L, 0x1900000L);
    }

    @Override
    public int getRepackThresholdPack() {
        return this.getBoundedProperty(PROP_REPACK_THRESHOLD_PACK, 50, 1);
    }

    @Override
    @Nonnull
    public Duration getRepackTimeout() {
        return Duration.ofSeconds(this.getBoundedProperty(PROP_REPACK_TIMEOUT, DEFAULT_REPACK_TIMEOUT_SECONDS, MINIMUM_REPACK_TIMEOUT_SECONDS));
    }

    @Override
    @Nonnull
    public Path getRepositoriesDir() {
        return this.homeLayout.getRepositoriesDir();
    }

    @Override
    @Nonnull
    public Path getRepositoryDir(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        return this.storageService.getRepositoryDir(repository);
    }

    @Override
    @Nonnull
    public Duration getSizeTimeout() {
        return Duration.ofMillis(this.getProperty(PROP_SIZE_TIMEOUT, 75L));
    }

    @Override
    @Nonnull
    public String getSshBinary() {
        return this.getProperty(PROP_SSH_BINARY, DEFAULT_SSH_BINARY);
    }

    @Override
    @Nonnull
    public Path getSshScript() {
        return this.sshScript;
    }

    @Override
    @Nonnull
    public Path getTemplateDir() {
        return this.templateDir;
    }

    @Override
    @Nonnull
    public Path getTempDir() {
        return this.tempDir;
    }

    @Override
    @Nonnull
    public Version getVersion() {
        return ((GitBinary)Eithers.getOrThrow(this.resolveException())).getVersion();
    }

    @Override
    @Nonnull
    public Duration getWorkTreeExpiry() {
        return Duration.ofMinutes(Math.min(MAX_WORKTREE_EXPIRY_MINUTES, this.getBoundedProperty(PROP_WORKTREE_EXPIRY, 30L, 2L)));
    }

    @Override
    public boolean isGrpcKeepAliveWithoutCallsEnabled() {
        return this.getProperty(PROP_GRPC_KEEP_ALIVE_WITHOUT_CALLS, true);
    }

    @Override
    public boolean isHostingFilterAllowed() {
        return this.getProperty(PROP_HOSTING_ALLOW_FILTER, true);
    }

    @Override
    public boolean isRefAdvertisementThrottled() {
        return this.getProperty(PROP_THROTTLE_REF_ADVERTISEMENT, true);
    }

    @Override
    public int parseProtocolVersion(@Nullable String versionsString) {
        if (StringUtils.isBlank((CharSequence)versionsString)) {
            return 0;
        }
        int highestVersion = 0;
        for (String item : Splitter.on((char)':').split((CharSequence)versionsString)) {
            if (!item.startsWith("version=")) continue;
            try {
                int version = Integer.parseInt(item.substring(8));
                if (version <= highestVersion) continue;
                highestVersion = version;
            }
            catch (NumberFormatException e) {
                log.debug("Ignoring invalid git protocol version: {}", (Object)item);
            }
        }
        return highestVersion;
    }

    @Override
    public boolean useAlternates() {
        return this.getProperty(PROP_USE_ALTERNATES, true);
    }

    protected int getBoundedProperty(String property, int defaultValue, int minimumValue) {
        return Math.max(this.getProperty(property, defaultValue), minimumValue);
    }

    protected long getBoundedProperty(String property, long defaultValue, long minimumValue) {
        return Math.max(this.getProperty(property, defaultValue), minimumValue);
    }

    private static String getSshScriptName() {
        return GIT_SSH_SCRIPT + (SystemUtils.IS_OS_WINDOWS ? ".bat" : ".sh");
    }

    private String configureLibexec() {
        String libexec = this.getProperty(PROP_LIBEXEC_PATH);
        if (libexec == null) {
            log.debug("libexec has not been configured; core binaries will not be available");
            return null;
        }
        String prefix = libexec + File.separator + "git-core" + File.separator + "git-";
        for (String binary : CORE_BINARIES) {
            File file = new File(prefix + binary);
            if (file.isFile() && file.canExecute()) continue;
            log.warn("libexec path {} is not valid and will be ignored; git-{} is missing or not executable", (Object)libexec, (Object)binary);
            return null;
        }
        log.debug("libexec has been set to {}; core binaries will be executed when available", (Object)libexec);
        return prefix;
    }

    private Either<RejectedGitBinary, GitBinary> findBinary() {
        return this.binaryHelper.find(this.getProperty(PROP_BINARY_PATH));
    }

    private Either<GitException, GitBinary> resolveException() {
        return this.binary.left().map(binaryError -> {
            KeyedMessage keyedMessage = this.i18nService.getKeyedText(binaryError.getI18nKey());
            return binaryError.isFound() ? new GitUnsupportedVersionException(keyedMessage, binaryError.getBinary().getVersion()) : new GitNotFoundException(keyedMessage);
        });
    }
}

