/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git;

import com.atlassian.bitbucket.content.Path;
import com.atlassian.bitbucket.content.SimplePath;
import com.atlassian.stash.internal.scm.git.GitFileStatus;
import com.atlassian.stash.internal.scm.git.GitStatus;
import java.util.Objects;

public class DefaultGitStatus
implements GitStatus {
    private final GitFileStatus indexStatus;
    private final GitFileStatus workTreeStatus;
    private final Path path;
    private final Path srcPath;

    public DefaultGitStatus(GitFileStatus indexStatus, GitFileStatus workTreeStatus, String path) {
        this(indexStatus, workTreeStatus, path, null);
    }

    public DefaultGitStatus(GitFileStatus indexStatus, GitFileStatus workTreeStatus, String path, String srcPath) {
        this.indexStatus = indexStatus;
        this.workTreeStatus = workTreeStatus;
        this.path = new SimplePath((CharSequence)path);
        this.srcPath = new SimplePath((CharSequence)srcPath);
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public GitFileStatus getIndexStatus() {
        return this.indexStatus;
    }

    @Override
    public GitFileStatus getWorkTreeStatus() {
        return this.workTreeStatus;
    }

    @Override
    public Path getSrcPath() {
        return this.srcPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultGitStatus that = (DefaultGitStatus)o;
        return Objects.equals((Object)this.getIndexStatus(), (Object)that.getIndexStatus()) && Objects.equals((Object)this.getWorkTreeStatus(), (Object)that.getWorkTreeStatus()) && Objects.equals(this.getPath(), that.getPath()) && Objects.equals(this.getSrcPath(), that.getSrcPath());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getIndexStatus(), this.getWorkTreeStatus(), this.getPath(), this.getSrcPath()});
    }

    public String toString() {
        return "InternalStatus{indexStatus=" + String.valueOf((Object)this.indexStatus) + ", workTreeStatus=" + String.valueOf((Object)this.workTreeStatus) + ", path='" + String.valueOf(this.path) + "', srcPath='" + String.valueOf(this.srcPath) + "'}";
    }
}

