/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public enum GitFileStatus {
    ADDED("A"),
    COPIED("C"),
    DELETED("D"),
    MODIFIED("M"),
    RENAMED("R"),
    UNKNOWN,
    UNMERGED("U"),
    UNMODIFIED(" "),
    UNTRACKED("?");

    private final String status;

    private GitFileStatus() {
        this.status = null;
    }

    private GitFileStatus(String status) {
        this.status = Objects.requireNonNull(status, "status");
    }

    public String getStatus() {
        return this.status;
    }

    public static GitFileStatus fromStatus(String status) {
        for (GitFileStatus value : GitFileStatus.values()) {
            if (!StringUtils.equals((CharSequence)status, (CharSequence)value.getStatus())) continue;
            return value;
        }
        return UNKNOWN;
    }
}

