/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git;

import com.atlassian.bitbucket.event.project.ProjectModifiedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryModifiedEvent;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.event.api.EventListener;
import com.atlassian.stash.internal.scm.git.GitRepositoryLayout;
import java.io.IOException;
import java.nio.channels.OverlappingFileLockException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitRepositoryConfigListener {
    private static final Logger log = LoggerFactory.getLogger(GitRepositoryConfigListener.class);
    private final ScheduledExecutorService executorService;
    private final GitRepositoryLayout repositoryLayout;
    private final RepositoryService repositoryService;
    private final SecurityService securityService;

    public GitRepositoryConfigListener(ScheduledExecutorService executorService, GitRepositoryLayout repositoryLayout, RepositoryService repositoryService, SecurityService securityService) {
        this.executorService = executorService;
        this.repositoryLayout = repositoryLayout;
        this.repositoryService = repositoryService;
        this.securityService = securityService;
    }

    @EventListener
    public void onProjectModified(ProjectModifiedEvent event) {
        Project newProject = event.getNewValue();
        Project oldProject = event.getOldValue();
        if (!newProject.getKey().equals(oldProject.getKey())) {
            this.executorService.schedule(() -> this.updateRepositories(newProject), 15L, TimeUnit.SECONDS);
        }
    }

    @EventListener
    public void onRepositoryModified(RepositoryModifiedEvent event) {
        Repository newRepository = event.getNewValue();
        if (newRepository.isLocal() && "git".equals(newRepository.getScmId())) {
            Repository oldRepository = event.getOldValue();
            if (!newRepository.getSlug().equals(oldRepository.getSlug()) || newRepository.getProject().getId() != oldRepository.getProject().getId()) {
                this.executorService.schedule(() -> this.update(newRepository), 15L, TimeUnit.SECONDS);
            }
        }
    }

    private Page<Repository> findRepositoriesByProject(Project project, PageRequest pageRequest) {
        return this.repositoryService.findByProjectKey(project.getKey(), pageRequest);
    }

    private void updateRepositories(Project project) {
        this.securityService.withPermission(Permission.PROJECT_READ, (Object)project, "Updating repository-config").call(() -> {
            PageUtils.toStream(pageRequest -> this.findRepositoriesByProject(project, pageRequest), (int)100).filter(repository -> repository.isLocal() && "git".equals(repository.getScmId())).forEach(this::update);
            return null;
        });
    }

    private void update(Repository repository) {
        try {
            this.repositoryLayout.writeRepositoryConfig(repository);
        }
        catch (OverlappingFileLockException e) {
            log.info("{}: repository-config is being updated by another process or thread", (Object)repository);
        }
        catch (IOException e) {
            log.warn("{}: repository-config could not be updated", (Object)repository, (Object)e);
        }
    }
}

