/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git;

import com.atlassian.bitbucket.scm.git.GitUtils;
import com.google.common.io.ByteStreams;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;

public class GitTreeNode {
    private final String contentId;
    private final String mode;
    private final String path;

    private GitTreeNode(String path, String contentId, String mode) {
        this.contentId = contentId;
        this.mode = mode;
        this.path = path;
    }

    @Nullable
    public static GitTreeNode parse(@Nonnull ByteBuffer buffer) {
        int mark = buffer.position();
        String rawMode = GitTreeNode.readUntil(buffer, (byte)32);
        if (rawMode == null) {
            buffer.position(mark);
            return null;
        }
        String path = GitTreeNode.readUntil(buffer, (byte)0);
        if (path == null || buffer.remaining() < 20) {
            buffer.position(mark);
            return null;
        }
        String mode = StringUtils.leftPad((String)rawMode, (int)6, (char)'0');
        String contentId = GitTreeNode.readSha(buffer);
        return new GitTreeNode(path, contentId, mode);
    }

    @Nullable
    public static GitTreeNode parse(@Nonnull InputStream stream) throws IOException {
        String rawMode = GitTreeNode.readUntil(stream, 32);
        if (rawMode == null) {
            return null;
        }
        String mode = StringUtils.leftPad((String)rawMode, (int)6, (char)'0');
        String path = GitTreeNode.readUntil(stream, 0);
        String contentId = GitTreeNode.readSha(stream);
        return new GitTreeNode(path, contentId, mode);
    }

    @Nonnull
    public String getContentId() {
        return this.contentId;
    }

    @Nonnull
    public String getPath() {
        return this.path;
    }

    public boolean isDirectory() {
        return GitUtils.isDirectory((String)this.mode);
    }

    public boolean isFile() {
        return GitUtils.isFile((String)this.mode);
    }

    @Nonnull
    private static String readSha(@Nonnull ByteBuffer buffer) {
        byte[] bytes = new byte[20];
        buffer.get(bytes);
        return Hex.encodeHexString((byte[])bytes);
    }

    @Nonnull
    private static String readSha(@Nonnull InputStream stream) throws IOException {
        byte[] buffer = new byte[20];
        ByteStreams.readFully((InputStream)stream, (byte[])buffer, (int)0, (int)buffer.length);
        return Hex.encodeHexString((byte[])buffer);
    }

    @Nullable
    private static String readUntil(@Nonnull ByteBuffer buffer, byte separator) {
        int start = buffer.position();
        while (buffer.hasRemaining()) {
            byte b = buffer.get();
            if (b != separator) continue;
            byte[] bytes = new byte[buffer.position() - start];
            buffer.position(start);
            buffer.get(bytes);
            return new String(bytes, 0, bytes.length - 1, StandardCharsets.UTF_8);
        }
        return null;
    }

    @Nullable
    private static String readUntil(@Nonnull InputStream stream, int separator) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(255);
        int character = stream.read();
        while (character != separator) {
            if (character == -1) {
                if (buffer.size() == 0) {
                    return null;
                }
                throw new IllegalStateException("Unexpected end-of-file reading " + (separator == 32 ? "mode" : "path"));
            }
            buffer.write(character);
            character = stream.read();
        }
        return new String(buffer.toByteArray(), StandardCharsets.UTF_8);
    }
}

