/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git;

import com.atlassian.audit.api.AuditService;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.cluster.ClusterService;
import com.atlassian.bitbucket.concurrent.LockService;
import com.atlassian.bitbucket.concurrent.PullRequestLock;
import com.atlassian.bitbucket.dmz.mesh.DmzMeshConsistencyCheckService;
import com.atlassian.bitbucket.dmz.mesh.DmzMeshController;
import com.atlassian.bitbucket.dmz.mesh.DmzMeshNodeRegistry;
import com.atlassian.bitbucket.dmz.mesh.DmzMeshPartitionRegistry;
import com.atlassian.bitbucket.dmz.mesh.DmzMeshService;
import com.atlassian.bitbucket.dmz.mesh.DmzMeshTroubleshootingService;
import com.atlassian.bitbucket.dmz.server.DmzStorageService;
import com.atlassian.bitbucket.help.HelpPathService;
import com.atlassian.bitbucket.hook.repository.RepositoryHookService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mesh.RpcCapabilityClient;
import com.atlassian.bitbucket.internal.mesh.RpcHookScriptClient;
import com.atlassian.bitbucket.internal.mesh.RpcManagementClient;
import com.atlassian.bitbucket.internal.process.NioProcessHelper;
import com.atlassian.bitbucket.log.LoggingService;
import com.atlassian.bitbucket.mesh.MeshService;
import com.atlassian.bitbucket.mesh.migration.DefaultMigrationStateManager;
import com.atlassian.bitbucket.mesh.migration.MigrationStateManager;
import com.atlassian.bitbucket.mesh.rpc.CapabilityServiceGrpc;
import com.atlassian.bitbucket.mesh.rpc.v1.BatchServiceGrpc;
import com.atlassian.bitbucket.mesh.rpc.v1.CommitServiceGrpc;
import com.atlassian.bitbucket.mesh.rpc.v1.ContentServiceGrpc;
import com.atlassian.bitbucket.mesh.rpc.v1.DiffServiceGrpc;
import com.atlassian.bitbucket.mesh.rpc.v1.GitDataServiceGrpc;
import com.atlassian.bitbucket.mesh.rpc.v1.HookScriptServiceGrpc;
import com.atlassian.bitbucket.mesh.rpc.v1.HostingServiceGrpc;
import com.atlassian.bitbucket.mesh.rpc.v1.ManagementServiceGrpc;
import com.atlassian.bitbucket.mesh.rpc.v1.PackCacheServiceGrpc;
import com.atlassian.bitbucket.mesh.rpc.v1.PlumbingServiceGrpc;
import com.atlassian.bitbucket.mesh.rpc.v1.PorcelainServiceGrpc;
import com.atlassian.bitbucket.mesh.rpc.v1.PullRequestServiceGrpc;
import com.atlassian.bitbucket.mesh.rpc.v1.RefServiceGrpc;
import com.atlassian.bitbucket.mesh.rpc.v1.RepositoryServiceGrpc;
import com.atlassian.bitbucket.mesh.rpc.v1.TransactionServiceGrpc;
import com.atlassian.bitbucket.mesh.rpc.v1.WorkTreeServiceGrpc;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.profiling.ProfilingService;
import com.atlassian.bitbucket.pull.PullRequestService;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.repository.RepositorySupplier;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.scm.ScmUrlFormatter;
import com.atlassian.bitbucket.scm.cache.internal.jmx.ScmHostingStatistics;
import com.atlassian.bitbucket.scm.git.GitIntegrityCheckCommandFactory;
import com.atlassian.bitbucket.scm.git.GitScm;
import com.atlassian.bitbucket.scm.git.GitWorkTreeBuilderFactory;
import com.atlassian.bitbucket.scm.git.auth.GitAuthHelper;
import com.atlassian.bitbucket.scm.git.command.GitBulkContentCommandFactory;
import com.atlassian.bitbucket.scm.git.command.GitCommandBuilderFactory;
import com.atlassian.bitbucket.scm.git.command.GitCommandFactory;
import com.atlassian.bitbucket.scm.git.command.GitCompareCommandFactory;
import com.atlassian.bitbucket.scm.git.command.GitExtendedCommandFactory;
import com.atlassian.bitbucket.scm.git.command.GitMirrorCommandFactory;
import com.atlassian.bitbucket.scm.git.command.GitPullRequestCommandFactory;
import com.atlassian.bitbucket.scm.git.command.GitRefCommandFactory;
import com.atlassian.bitbucket.scm.git.protocol.http.GitHttpScmRequestHandler;
import com.atlassian.bitbucket.scm.git.protocol.ssh.GitSshScmRequestHandler;
import com.atlassian.bitbucket.scm.git.pull.GitPullRequestService;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StorageService;
import com.atlassian.bitbucket.topic.TopicService;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.Version;
import com.atlassian.cache.CacheFactory;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.stash.internal.HomeLayout;
import com.atlassian.stash.internal.concurrent.StateTransferringExecutorService;
import com.atlassian.stash.internal.concurrent.TransferableStateManager;
import com.atlassian.stash.internal.hook.repository.InternalRepositoryHookService;
import com.atlassian.stash.internal.integrity.RepositoryIntegrityHelper;
import com.atlassian.stash.internal.mesh.InternalMeshPartitionRegistry;
import com.atlassian.stash.internal.mesh.MeshClientConfig;
import com.atlassian.stash.internal.mesh.MeshController;
import com.atlassian.stash.internal.mesh.MeshKeyManager;
import com.atlassian.stash.internal.mesh.MutableMeshNodeRegistry;
import com.atlassian.stash.internal.mode.DefaultApplicationMode;
import com.atlassian.stash.internal.plugin.OsgiServiceDefinition;
import com.atlassian.stash.internal.repository.InternalRepositoryService;
import com.atlassian.stash.internal.repository.RepositoryDao;
import com.atlassian.stash.internal.repository.RepositoryOfflineSupplier;
import com.atlassian.stash.internal.repository.RepositorySizeCache;
import com.atlassian.stash.internal.scm.InternalScmService;
import com.atlassian.stash.internal.scm.git.BundledResources;
import com.atlassian.stash.internal.scm.git.CountingGitWriteTracker;
import com.atlassian.stash.internal.scm.git.DefaultGitRepositoryConfig;
import com.atlassian.stash.internal.scm.git.DefaultGitRepositorySupplier;
import com.atlassian.stash.internal.scm.git.DefaultGitScmConfig;
import com.atlassian.stash.internal.scm.git.GitCommandCreator;
import com.atlassian.stash.internal.scm.git.GitHookHandlerFactory;
import com.atlassian.stash.internal.scm.git.GitRepositoryConfig;
import com.atlassian.stash.internal.scm.git.GitRepositorySupplier;
import com.atlassian.stash.internal.scm.git.GitScmConfig;
import com.atlassian.stash.internal.scm.git.GitWriteTracker;
import com.atlassian.stash.internal.scm.git.MeshGitHookHandlerFactory;
import com.atlassian.stash.internal.scm.git.analytics.GitAnalyticsJob;
import com.atlassian.stash.internal.scm.git.audit.GitEventListener;
import com.atlassian.stash.internal.scm.git.auth.DefaultGitAuthHelper;
import com.atlassian.stash.internal.scm.git.binary.DefaultGitBinaryHelper;
import com.atlassian.stash.internal.scm.git.binary.GitBinaryHelper;
import com.atlassian.stash.internal.scm.git.command.GitCommandBuilderConfigurer;
import com.atlassian.stash.internal.scm.git.command.GitWorkTreeCommandBuilderFactory;
import com.atlassian.stash.internal.scm.git.command.InternalGitCommandBuilderFactory;
import com.atlassian.stash.internal.scm.git.command.NioGitCommandCreator;
import com.atlassian.stash.internal.scm.git.gc.GitGarbageTruck;
import com.atlassian.stash.internal.scm.git.gc.MeshGitGarbageTruck;
import com.atlassian.stash.internal.scm.git.mesh.ClusterMetadataProvider;
import com.atlassian.stash.internal.scm.git.mesh.CoreMeshConfigProvider;
import com.atlassian.stash.internal.scm.git.mesh.DeadlinePropagatingClientInterceptor;
import com.atlassian.stash.internal.scm.git.mesh.DefaultGitRequestHelper;
import com.atlassian.stash.internal.scm.git.mesh.DefaultMeshClient;
import com.atlassian.stash.internal.scm.git.mesh.DefaultMeshConsistencyCheckService;
import com.atlassian.stash.internal.scm.git.mesh.DefaultMeshRepositoryArgumentCodec;
import com.atlassian.stash.internal.scm.git.mesh.DefaultMeshRouter;
import com.atlassian.stash.internal.scm.git.mesh.DefaultMeshSidebandRegistry;
import com.atlassian.stash.internal.scm.git.mesh.DefaultMeshTroubleshootingService;
import com.atlassian.stash.internal.scm.git.mesh.ErrorHandlingClientInterceptor;
import com.atlassian.stash.internal.scm.git.mesh.GitRequestHelper;
import com.atlassian.stash.internal.scm.git.mesh.GrpcBatchClient;
import com.atlassian.stash.internal.scm.git.mesh.GrpcCapabilityClient;
import com.atlassian.stash.internal.scm.git.mesh.GrpcCommitClient;
import com.atlassian.stash.internal.scm.git.mesh.GrpcContentClient;
import com.atlassian.stash.internal.scm.git.mesh.GrpcDataClient;
import com.atlassian.stash.internal.scm.git.mesh.GrpcDiffClient;
import com.atlassian.stash.internal.scm.git.mesh.GrpcGitWorkTreeClient;
import com.atlassian.stash.internal.scm.git.mesh.GrpcHookScriptClient;
import com.atlassian.stash.internal.scm.git.mesh.GrpcHostingClient;
import com.atlassian.stash.internal.scm.git.mesh.GrpcManagementClient;
import com.atlassian.stash.internal.scm.git.mesh.GrpcPackCacheClient;
import com.atlassian.stash.internal.scm.git.mesh.GrpcPlumbingClient;
import com.atlassian.stash.internal.scm.git.mesh.GrpcPorcelainClient;
import com.atlassian.stash.internal.scm.git.mesh.GrpcPullRequestClient;
import com.atlassian.stash.internal.scm.git.mesh.GrpcRefClient;
import com.atlassian.stash.internal.scm.git.mesh.GrpcRepositoryClient;
import com.atlassian.stash.internal.scm.git.mesh.GrpcTransactionClient;
import com.atlassian.stash.internal.scm.git.mesh.LoggingClientInterceptor;
import com.atlassian.stash.internal.scm.git.mesh.MeshClient;
import com.atlassian.stash.internal.scm.git.mesh.MeshGitBulkContentCommandFactory;
import com.atlassian.stash.internal.scm.git.mesh.MeshGitCommandBuilderFactory;
import com.atlassian.stash.internal.scm.git.mesh.MeshGitCommandFactory;
import com.atlassian.stash.internal.scm.git.mesh.MeshGitCompareCommandFactory;
import com.atlassian.stash.internal.scm.git.mesh.MeshGitExtendedCommandFactory;
import com.atlassian.stash.internal.scm.git.mesh.MeshGitIntegrityCheckCommandFactory;
import com.atlassian.stash.internal.scm.git.mesh.MeshGitMirrorCommandFactory;
import com.atlassian.stash.internal.scm.git.mesh.MeshGitPullRequestCommandFactory;
import com.atlassian.stash.internal.scm.git.mesh.MeshGitRefCommandFactory;
import com.atlassian.stash.internal.scm.git.mesh.MeshGitRepositoryConfigListener;
import com.atlassian.stash.internal.scm.git.mesh.MeshGitScm;
import com.atlassian.stash.internal.scm.git.mesh.MeshMigrationHook;
import com.atlassian.stash.internal.scm.git.mesh.MeshNodeLoggingConfigProvider;
import com.atlassian.stash.internal.scm.git.mesh.MeshNodeLoggingEventListener;
import com.atlassian.stash.internal.scm.git.mesh.MeshPullRequestRefHelper;
import com.atlassian.stash.internal.scm.git.mesh.MeshRepositoryArgumentCodec;
import com.atlassian.stash.internal.scm.git.mesh.MeshRepositoryOfflineSupplier;
import com.atlassian.stash.internal.scm.git.mesh.MeshRouter;
import com.atlassian.stash.internal.scm.git.mesh.MeshSidebandRegistry;
import com.atlassian.stash.internal.scm.git.mesh.MeshWorkTreeBuilderFactory;
import com.atlassian.stash.internal.scm.git.mesh.MessagePreparer;
import com.atlassian.stash.internal.scm.git.mesh.MetadataClientInterceptor;
import com.atlassian.stash.internal.scm.git.mesh.MetadataProvider;
import com.atlassian.stash.internal.scm.git.mesh.RepositoryMeshMigrator;
import com.atlassian.stash.internal.scm.git.mesh.RequestMetadataProvider;
import com.atlassian.stash.internal.scm.git.mesh.RoutePropagatingClientInterceptor;
import com.atlassian.stash.internal.scm.git.mesh.RpcBatchClient;
import com.atlassian.stash.internal.scm.git.mesh.RpcCommitClient;
import com.atlassian.stash.internal.scm.git.mesh.RpcContentClient;
import com.atlassian.stash.internal.scm.git.mesh.RpcDataClient;
import com.atlassian.stash.internal.scm.git.mesh.RpcDiffClient;
import com.atlassian.stash.internal.scm.git.mesh.RpcGitWorkTreeClient;
import com.atlassian.stash.internal.scm.git.mesh.RpcHostingClient;
import com.atlassian.stash.internal.scm.git.mesh.RpcMetricsClientInterceptor;
import com.atlassian.stash.internal.scm.git.mesh.RpcPackCacheClient;
import com.atlassian.stash.internal.scm.git.mesh.RpcPlumbingClient;
import com.atlassian.stash.internal.scm.git.mesh.RpcPorcelainClient;
import com.atlassian.stash.internal.scm.git.mesh.RpcPullRequestClient;
import com.atlassian.stash.internal.scm.git.mesh.RpcRefClient;
import com.atlassian.stash.internal.scm.git.mesh.RpcRepositoryClient;
import com.atlassian.stash.internal.scm.git.mesh.RpcTransactionClient;
import com.atlassian.stash.internal.scm.git.mesh.SidecarManager;
import com.atlassian.stash.internal.scm.git.mesh.SidecarProperties;
import com.atlassian.stash.internal.scm.git.mesh.StateTransferringClientInterceptor;
import com.atlassian.stash.internal.scm.git.mesh.ZeroCopyClientInterceptor;
import com.atlassian.stash.internal.scm.git.mesh.auth.AuthenticationClientInterceptor;
import com.atlassian.stash.internal.scm.git.mesh.auth.DefaultMeshKeyManager;
import com.atlassian.stash.internal.scm.git.mesh.auth.MeshKeyRegistry;
import com.atlassian.stash.internal.scm.git.mesh.command.worktree.MeshGitWorkTreeCommandBuilderFactory;
import com.atlassian.stash.internal.scm.git.protocol.http.GitHttpErrorHelper;
import com.atlassian.stash.internal.scm.git.protocol.http.GitHttpUrlFormatter;
import com.atlassian.stash.internal.scm.git.protocol.http.MeshHttpScmRequestHandler;
import com.atlassian.stash.internal.scm.git.protocol.ssh.GitSshUrlFormatter;
import com.atlassian.stash.internal.scm.git.protocol.ssh.MeshSshScmRequestHandler;
import com.atlassian.stash.internal.scm.git.pull.DefaultGitPullRequestCache;
import com.atlassian.stash.internal.scm.git.pull.DefaultGitPullRequestService;
import com.atlassian.stash.internal.scm.git.pull.DefaultGitPullRequestSupplier;
import com.atlassian.stash.internal.scm.git.pull.GitPullRequestCache;
import com.atlassian.stash.internal.scm.git.pull.GitPullRequestCachedAncestorDao;
import com.atlassian.stash.internal.scm.git.pull.GitPullRequestCachedMergeDao;
import com.atlassian.stash.internal.scm.git.pull.GitPullRequestSupplier;
import com.atlassian.stash.internal.scm.git.pull.LegacyPullRequestMergeCache;
import com.atlassian.stash.internal.scm.git.pull.MergeResultPullRequestPropertyProvider;
import com.atlassian.stash.internal.scm.git.pull.PullRequestRefGuardHook;
import com.atlassian.stash.internal.scm.git.pull.PullRequestRefHelper;
import com.atlassian.stash.internal.scm.git.submodule.DefaultGitSubmoduleUriHandler;
import com.atlassian.stash.internal.scm.git.submodule.DefaultSubmoduleUrlBuilder;
import com.atlassian.stash.internal.scm.git.submodule.GitSubmoduleUriHandler;
import com.atlassian.stash.internal.scm.git.submodule.SubmoduleUrlBuilder;
import com.atlassian.stash.internal.scm.git.transcode.MeshTranscodeService;
import com.atlassian.stash.internal.scm.git.transcode.TranscodeService;
import com.atlassian.stash.internal.server.InternalStorageService;
import io.atlassian.util.concurrent.ThreadFactories;
import io.grpc.ClientInterceptor;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.convert.DurationUnit;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Primary;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
public class GitWiring {
    @AvailableToPlugins(value=GitAuthHelper.class)
    @Bean
    public GitAuthHelper gitAuthHelper(GitScmConfig config) {
        return new DefaultGitAuthHelper(config);
    }

    @Bean
    public ScmUrlFormatter gitHttpUrlFormatter(@Value(value="${http.cloneurl.includeusername}") boolean includeUsername) {
        return new GitHttpUrlFormatter(includeUsername);
    }

    @Bean
    public MergeResultPullRequestPropertyProvider gitMergeResultPullRequestPropertyProvider(GitPullRequestCachedMergeDao cachedMergeDao) {
        return new MergeResultPullRequestPropertyProvider(cachedMergeDao);
    }

    @Bean
    public PullRequestRefGuardHook gitPullRequestRefGuardHook(I18nService i18nService) {
        return new PullRequestRefGuardHook(i18nService);
    }

    @AvailableToPlugins(value=GitPullRequestService.class)
    @Bean
    public GitPullRequestService gitPullRequestService(AuthenticationContext authenticationContext, GitScmConfig config, EventPublisher eventPublisher, GitExtendedCommandFactory extendedCommandFactory, FeatureManager featureManager, RepositoryHookService hookService, I18nService i18nService, LockService lockService, PermissionService permissionService, GitPullRequestSupplier pullRequestSupplier) {
        return new DefaultGitPullRequestService(authenticationContext, config, eventPublisher, extendedCommandFactory, featureManager, hookService, i18nService, permissionService, pullRequestSupplier, lockService.getPullRequestLock("com.atlassian.bitbucket.server.bitbucket-git:pull-request-rebase"));
    }

    @Bean
    public ScmUrlFormatter gitSshUrlFormatter() {
        return new GitSshUrlFormatter();
    }

    @Bean
    public MeshMigrationHook meshMigrationHook(I18nService i18nService, MigrationStateManager migrationStateManager) {
        return new MeshMigrationHook(i18nService, migrationStateManager);
    }

    @Bean
    public OsgiServiceDefinition osgiGitBulkContentCommandFactory(GitBulkContentCommandFactory factory) {
        return new OsgiServiceDefinition.Builder((Object)factory).interfaces(GitBulkContentCommandFactory.class, new Class[0]).build();
    }

    @Bean
    public OsgiServiceDefinition osgiGitCommandBuilderFactory(GitCommandBuilderFactory factory) {
        return new OsgiServiceDefinition.Builder((Object)factory).interfaces(GitCommandBuilderFactory.class, new Class[0]).build();
    }

    @Bean
    public OsgiServiceDefinition osgiGitCommandFactory(GitCommandFactory factory) {
        return new OsgiServiceDefinition.Builder((Object)factory).interfaces(GitCommandFactory.class, new Class[0]).build();
    }

    @Bean
    public OsgiServiceDefinition osgiGitCompareCommandFactory(GitCompareCommandFactory factory) {
        return new OsgiServiceDefinition.Builder((Object)factory).interfaces(GitCompareCommandFactory.class, new Class[0]).build();
    }

    @Bean
    public OsgiServiceDefinition osgiGitExtendedCommandFactory(GitExtendedCommandFactory factory) {
        return new OsgiServiceDefinition.Builder((Object)factory).interfaces(GitExtendedCommandFactory.class, new Class[0]).build();
    }

    @Bean
    public OsgiServiceDefinition osgiGitHttpScmRequestHandler(GitHttpScmRequestHandler handler) {
        return new OsgiServiceDefinition.Builder((Object)handler).interfaces(GitHttpScmRequestHandler.class, new Class[0]).build();
    }

    @Bean
    public OsgiServiceDefinition osgiGitIntegrityCheckCommandFactory(GitIntegrityCheckCommandFactory factory) {
        return new OsgiServiceDefinition.Builder((Object)factory).interfaces(GitIntegrityCheckCommandFactory.class, new Class[0]).build();
    }

    @Bean
    public OsgiServiceDefinition osgiGitMirrorCommandFactory(GitMirrorCommandFactory factory) {
        return new OsgiServiceDefinition.Builder((Object)factory).interfaces(GitMirrorCommandFactory.class, new Class[0]).build();
    }

    @Bean
    public OsgiServiceDefinition osgiGitPullRequestCommandFactory(GitPullRequestCommandFactory factory) {
        return new OsgiServiceDefinition.Builder((Object)factory).interfaces(GitPullRequestCommandFactory.class, new Class[0]).build();
    }

    @Bean
    public OsgiServiceDefinition osgiGitRefCommandFactory(GitRefCommandFactory factory) {
        return new OsgiServiceDefinition.Builder((Object)factory).interfaces(GitRefCommandFactory.class, new Class[0]).build();
    }

    @Bean
    public OsgiServiceDefinition osgiGitScm(GitScm gitScm) {
        return new OsgiServiceDefinition.Builder((Object)gitScm).interfaces(GitScm.class, new Class[0]).build();
    }

    @Bean
    public OsgiServiceDefinition osgiGitSshScmRequestHandler(GitSshScmRequestHandler handler) {
        return new OsgiServiceDefinition.Builder((Object)handler).interfaces(GitSshScmRequestHandler.class, new Class[0]).build();
    }

    @Bean
    public OsgiServiceDefinition osgiGitWorkTreeBuilderFactory(GitWorkTreeBuilderFactory factory) {
        return new OsgiServiceDefinition.Builder((Object)factory).interfaces(GitWorkTreeBuilderFactory.class, new Class[0]).build();
    }

    @Bean(value={"gitSshScmRequestHandler"}, autowireCandidate=false)
    public GitSshScmRequestHandler pluginModuleGitSshScmRequestHandler(GitSshScmRequestHandler handler) {
        return handler;
    }

    @Bean(destroyMethod="shutdown", name={"asyncCommandExecutor"})
    ExecutorService asyncCommandExecutor(TransferableStateManager transferableStateManager) {
        return new StateTransferringExecutorService(Executors.newCachedThreadPool(ThreadFactories.namedThreadFactory((String)"git-async-command")), transferableStateManager);
    }

    @Bean(destroyMethod="destroy", initMethod="init")
    GitAnalyticsJob gitAnalyticsJob(GitScmConfig config, EventPublisher eventPublisher, SchedulerService schedulerService) {
        return new GitAnalyticsJob(config, eventPublisher, schedulerService);
    }

    @Bean
    GitBinaryHelper gitBinaryHelper(@Value(value="${plugin.bitbucket-git.version.unsupported-from:}") String unsupportedFrom) {
        DefaultGitBinaryHelper helper = new DefaultGitBinaryHelper();
        if (StringUtils.isNotBlank((CharSequence)unsupportedFrom)) {
            Version unsupportedFromVersion = new Version(unsupportedFrom);
            helper.setUnsupportedFromVersion(unsupportedFromVersion);
        }
        return helper;
    }

    @Bean(initMethod="unpack")
    BundledResources gitBundledResources(GitScmConfig config) {
        return new BundledResources(config);
    }

    @Bean
    GitCommandCreator gitCommandCreator(@Qualifier(value="ioPumpThreadPoolExecutor") ThreadPoolExecutor bioExecutor, I18nService i18nService, NioProcessHelper processHelper) {
        return new NioGitCommandCreator(bioExecutor, i18nService, processHelper);
    }

    @Bean
    public GitHttpErrorHelper gitHttpErrorHelper(@Value(value="${http.scmrequest.process.error.response.status.override}") boolean overrideResponseCode) {
        return new GitHttpErrorHelper(overrideResponseCode);
    }

    @Bean
    GitEventListener gitEventListener(AuditService auditService) {
        return new GitEventListener(auditService);
    }

    @Bean
    GitPullRequestCache gitPullRequestCache(GitPullRequestCachedAncestorDao cachedAncestorDao, GitPullRequestCachedMergeDao cachedMergeDao, EventPublisher eventPublisher, Optional<LegacyPullRequestMergeCache> mergeCache, PlatformTransactionManager transactionManager) {
        return new DefaultGitPullRequestCache(cachedAncestorDao, cachedMergeDao, eventPublisher, mergeCache.orElse(null), transactionManager);
    }

    @Bean
    GitRepositoryConfig gitRepositoryConfig(GitScmConfig config) {
        return new DefaultGitRepositoryConfig(config);
    }

    @Bean
    GitScmConfig gitScmConfig(GitBinaryHelper binaryHelper, HomeLayout homeLayout, I18nService i18nService, ApplicationPropertiesService propertiesService, InternalStorageService storageService) {
        return new DefaultGitScmConfig(binaryHelper, homeLayout, i18nService, propertiesService, storageService);
    }

    @Bean
    GitSubmoduleUriHandler gitSubmoduleUriHandler(NavBuilder navBuilder, PluginAccessor pluginAccessor) {
        return new DefaultGitSubmoduleUriHandler(navBuilder, pluginAccessor);
    }

    @Bean
    MigrationStateManager migrationStateManager(HomeLayout homeLayout) {
        return new DefaultMigrationStateManager(homeLayout.getHierarchiesDir());
    }

    @Bean
    PullRequestLock pullRequestLock(LockService lockService) {
        return lockService.getPullRequestLock("com.atlassian.bitbucket.server.bitbucket-git:pull-request-effective-diff");
    }

    @Bean
    GitPullRequestSupplier pullRequestSupplier(I18nService i18nService, PullRequestService pullRequestService, RepositoryService repositoryService) {
        return new DefaultGitPullRequestSupplier(i18nService, pullRequestService, repositoryService);
    }

    @Bean
    ScmHostingStatistics scmHostingStatistics() {
        return new ScmHostingStatistics();
    }

    @Bean
    SubmoduleUrlBuilder submoduleUrlBuilder(RepositoryService repositoryService, GitSubmoduleUriHandler uriHandler) {
        return new DefaultSubmoduleUrlBuilder(uriHandler, repositoryService);
    }

    @Bean
    GitWriteTracker writeTracker() {
        return new CountingGitWriteTracker();
    }

    @Configuration
    public static class MeshWiring {
        private static final int ORDER_INTERCEPTOR_AUTH = 9;
        private static final int ORDER_INTERCEPTOR_DEADLINE = 4;
        private static final int ORDER_INTERCEPTOR_ERROR_HANDLER = 3;
        private static final int ORDER_INTERCEPTOR_LOGGING = 2;
        private static final int ORDER_INTERCEPTOR_METADATA = 5;
        private static final int ORDER_INTERCEPTOR_METRICS = 1;
        private static final int ORDER_INTERCEPTOR_ROUTING = 8;
        private static final int ORDER_INTERCEPTOR_STATE_TRANSFER = 7;
        private static final int ORDER_INTERCEPTOR_ZERO_COPY = 6;
        private static final String PROP_AUTH_EXPIRY_INTERVAL = "${plugin.bitbucket-git.mesh.authentication.expiry-interval:30s}";

        @Bean
        public MeshRepositoryArgumentCodec argumentEncoder(GitScmConfig config, RepositorySupplier repositorySupplier, GitRequestHelper requestHelper, SecurityService securityService) {
            return new DefaultMeshRepositoryArgumentCodec(config, repositorySupplier, requestHelper, securityService);
        }

        @Bean
        public CoreMeshConfigProvider coreMeshConfigProvider(StorageService storageService) {
            return new CoreMeshConfigProvider(new Resource[]{new ClassPathResource("application-internal.properties"), new ClassPathResource("application-default.properties"), new FileSystemResource(storageService.getSharedHomeDir().resolve("bitbucket.properties"))});
        }

        @Bean(value={"meshGitBulkContentCommandFactory"})
        public GitBulkContentCommandFactory gitBulkContentCommandFactory(RpcBatchClient batchClient, RpcCommitClient commitClient, GitScmConfig config, @Qualifier(value="asyncCommandExecutor") ExecutorService executorService, RpcPlumbingClient plumbingClient, GitRequestHelper requestHelper) {
            return new MeshGitBulkContentCommandFactory(batchClient, commitClient, config, executorService, plumbingClient, requestHelper);
        }

        @Bean(value={"meshGitCommandBuilderFactory"})
        public InternalGitCommandBuilderFactory gitCommandBuilderFactory(MeshRepositoryArgumentCodec argumentCodec, @Qualifier(value="ioPumpThreadPoolExecutor") ThreadPoolExecutor bioExecutor, GitCommandCreator commandCreator, GitScmConfig config, @Qualifier(value="asyncCommandExecutor") ExecutorService executorService, I18nService i18nService, RpcPlumbingClient plumbingClient, GitRequestHelper requestHelper, TransferableStateManager stateManager) {
            return new MeshGitCommandBuilderFactory(argumentCodec, (ExecutorService)new StateTransferringExecutorService((ExecutorService)bioExecutor, stateManager), commandCreator, config, executorService, i18nService, plumbingClient, requestHelper);
        }

        @Bean(value={"meshGitCommandFactory"})
        @DependsOn(value={"gitBundledResources"})
        public GitCommandFactory gitCommandFactory(RpcCommitClient commitClient, RpcContentClient contentClient, GitScmConfig config, @Qualifier(value="asyncCommandExecutor") ExecutorService executorService, I18nService i18nService, RpcPlumbingClient plumbingClient, RpcPorcelainClient porcelainClient, RpcRefClient refClient, RpcRepositoryClient repositoryClient, RpcDiffClient diffClient, GitRepositoryConfig repositoryConfig, GitRequestHelper requestHelper) {
            return new MeshGitCommandFactory(commitClient, config, contentClient, executorService, i18nService, plumbingClient, porcelainClient, refClient, repositoryClient, diffClient, repositoryConfig, requestHelper);
        }

        @Bean(value={"meshGitCompareCommandFactory"})
        public GitCompareCommandFactory gitCompareCommandFactory(RpcCommitClient commitClient, GitScmConfig config, RpcDiffClient diffClient, @Qualifier(value="asyncCommandExecutor") ExecutorService executorService, I18nService i18nService, RpcPlumbingClient plumbingClient, RpcPorcelainClient porcelainClient, RpcRefClient refClient, GitRepositoryConfig repositoryConfig, GitRequestHelper requestHelper) {
            return new MeshGitCompareCommandFactory(commitClient, config, diffClient, executorService, i18nService, plumbingClient, porcelainClient, refClient, repositoryConfig, requestHelper);
        }

        @Bean(value={"meshGitExtendedCommandFactory"})
        @DependsOn(value={"gitBundledResources"})
        public GitExtendedCommandFactory gitExtendedCommandFactory(RpcCommitClient commitClient, GitScmConfig config, @Qualifier(value="asyncCommandExecutor") ExecutorService executorService, I18nService i18nService, RpcPlumbingClient plumbingClient, RpcPorcelainClient porcelainClient, RpcRefClient refClient, RpcRepositoryClient repositoryClient, GitRepositoryConfig repositoryConfig, GitRequestHelper requestHelper) {
            return new MeshGitExtendedCommandFactory(config, commitClient, executorService, i18nService, plumbingClient, porcelainClient, refClient, repositoryClient, repositoryConfig, requestHelper);
        }

        @Bean(value={"meshGitGarbageTruck"})
        public GitGarbageTruck gitGarbageTruck(RpcRepositoryClient repositoryClient) {
            return new MeshGitGarbageTruck(repositoryClient);
        }

        @Bean(value={"meshGitHookHandlerFactory"})
        public MeshGitHookHandlerFactory gitHookHandlerFactory(RpcRefClient refClient) {
            return new MeshGitHookHandlerFactory(refClient);
        }

        @Bean(value={"meshGitIntegrityCheckCommandFactory"})
        public GitIntegrityCheckCommandFactory gitIntegrityCheckCommandFactory(@Qualifier(value="asyncCommandExecutor") ExecutorService executorService, DmzMeshService meshService, InternalMeshPartitionRegistry partitionRegistry, RpcRepositoryClient rpcRepositoryClient, RepositorySupplier repositorySupplier, GitRequestHelper requestHelper) {
            return new MeshGitIntegrityCheckCommandFactory(executorService, meshService, partitionRegistry, rpcRepositoryClient, repositorySupplier, requestHelper);
        }

        @Bean(value={"meshGitMirrorCommandFactory"})
        @DependsOn(value={"gitBundledResources"})
        public GitMirrorCommandFactory gitMirrorCommandFactory(@Qualifier(value="asyncCommandExecutor") ExecutorService executorService, I18nService i18nService, RpcRefClient refClient, RpcRepositoryClient repositoryClient) {
            return new MeshGitMirrorCommandFactory(executorService, i18nService, refClient, repositoryClient);
        }

        @Bean(value={"meshGitPullRequestCommandFactory"})
        public GitPullRequestCommandFactory gitPullRequestCommandFactory(GitScmConfig config, @Qualifier(value="asyncCommandExecutor") ExecutorService executorService, RpcPullRequestClient pullRequestClient, @Qualifier(value="meshPullRequestRefHelper") PullRequestRefHelper refHelper, GitRepositoryConfig repositoryConfig) {
            return new MeshGitPullRequestCommandFactory(config, executorService, pullRequestClient, refHelper, repositoryConfig);
        }

        @Bean(value={"meshGitRefCommandFactory"})
        public GitRefCommandFactory gitRefCommandFactory(AuthenticationContext authenticationContext, @Qualifier(value="asyncCommandExecutor") ExecutorService executorService, I18nService i18nService, RpcRefClient refClient, GitRepositoryConfig repositoryConfig) {
            return new MeshGitRefCommandFactory(authenticationContext, executorService, i18nService, refClient, repositoryConfig);
        }

        @Bean(value={"gitScm"})
        public MeshGitScm gitScm(@Qualifier(value="meshGitCommandBuilderFactory") GitCommandBuilderFactory builderFactory, @Qualifier(value="meshGitBulkContentCommandFactory") GitBulkContentCommandFactory bulkContentCommandFactory, @Qualifier(value="meshGitCommandFactory") GitCommandFactory commandFactory, @Qualifier(value="meshGitCompareCommandFactory") GitCompareCommandFactory compareCommandFactory, GitScmConfig config, @Qualifier(value="meshGitExtendedCommandFactory") GitExtendedCommandFactory extendedCommandFactory, FeatureManager featureManager, @Qualifier(value="meshGitHookHandlerFactory") GitHookHandlerFactory hookHandlerFactory, I18nService i18nService, @Qualifier(value="meshGitIntegrityCheckCommandFactory") GitIntegrityCheckCommandFactory integrityCheckCommandFactory, @Qualifier(value="meshGitMirrorCommandFactory") GitMirrorCommandFactory mirrorCommandFactory, @Qualifier(value="meshGitPullRequestCommandFactory") GitPullRequestCommandFactory pullRequestCommandFactory, @Qualifier(value="meshGitRefCommandFactory") GitRefCommandFactory refCommandFactory, RpcRepositoryClient repositoryClient, SidecarManager sidecarManager, @Qualifier(value="meshGitWorkTreeBuilderFactory") GitWorkTreeBuilderFactory workTreeBuilderFactory, GitWriteTracker writeTracker) {
            return new MeshGitScm(builderFactory, bulkContentCommandFactory, commandFactory, compareCommandFactory, config, extendedCommandFactory, featureManager, hookHandlerFactory, i18nService, integrityCheckCommandFactory, mirrorCommandFactory, pullRequestCommandFactory, refCommandFactory, repositoryClient, sidecarManager, workTreeBuilderFactory, writeTracker);
        }

        @Bean
        public RepositoryMeshMigrator repositoryMigrator(GitCommandBuilderFactory builderFactory, RpcDataClient dataClient, I18nService i18nService, RpcManagementClient managementClient, DmzMeshService meshService, MigrationStateManager migrationStateManager, DmzMeshPartitionRegistry partitionRegistry, RepositorySupplier repositorySupplier, DmzStorageService storageService, RpcTransactionClient transactionClient, TranscodeService transcodeService) {
            return new RepositoryMeshMigrator(builderFactory, dataClient, i18nService, managementClient, meshService, migrationStateManager, partitionRegistry, repositorySupplier, storageService, transactionClient, transcodeService);
        }

        @Bean(value={"meshRepositoryOfflineSupplier"})
        @Primary
        public RepositoryOfflineSupplier repositoryOfflineSupplier(DmzMeshPartitionRegistry partitionRegistry, SidecarManager sidecarManager) {
            return new MeshRepositoryOfflineSupplier(partitionRegistry, sidecarManager.getSidecar());
        }

        @Bean(value={"meshTranscodeService"})
        public TranscodeService transcodeService(EventPublisher eventPublisher, RpcRepositoryClient repositoryClient) {
            return new MeshTranscodeService(eventPublisher, repositoryClient);
        }

        @Bean(value={"meshGitWorkTreeBuilderFactory"})
        public GitWorkTreeBuilderFactory workTreeBuilderFactory(GitScmConfig config, GitRequestHelper requestHelper, RpcGitWorkTreeClient workTreeClient, I18nService i18nService) {
            return new MeshWorkTreeBuilderFactory(config, i18nService, requestHelper, workTreeClient);
        }

        @Bean(value={"meshGitWorkTreeCommandBuilderFactory"})
        public GitWorkTreeCommandBuilderFactory workTreeCommandBuilderFactory(MeshRepositoryArgumentCodec argumentCodec, @Qualifier(value="asyncCommandExecutor") ExecutorService executorService, GitCommandCreator commandCreator, GitRequestHelper requestHelper, GitScmConfig config, I18nService i18nService, List<GitCommandBuilderConfigurer> configurers, @Qualifier(value="ioPumpThreadPoolExecutor") ThreadPoolExecutor bioExecutor, RpcPlumbingClient plumbingClient) {
            return new MeshGitWorkTreeCommandBuilderFactory(argumentCodec, executorService, commandCreator, config, requestHelper, i18nService, configurers, bioExecutor, plumbingClient);
        }

        @Bean
        @Order(value=9)
        @ConditionalOnProperty(name={"mesh.authentication.enabled"}, havingValue="true")
        AuthenticationClientInterceptor authenticationClientInterceptor(MeshKeyManager keyManager, @Value(value="${plugin.bitbucket-git.mesh.sidecar.authentication.enabled}") boolean sidecarAuthenticationEnabled) {
            return new AuthenticationClientInterceptor(keyManager, sidecarAuthenticationEnabled);
        }

        @Bean(destroyMethod="shutdown")
        @Order(value=4)
        DeadlinePropagatingClientInterceptor deadlinePropagatingClientInterceptor() {
            return new DeadlinePropagatingClientInterceptor();
        }

        @Bean
        @Order(value=3)
        ErrorHandlingClientInterceptor errorHandlingClientInterceptor(EventPublisher eventPublisher, @Lazy MeshController meshController, RepositorySupplier repositorySupplier, SecurityService securityService) {
            return new ErrorHandlingClientInterceptor(eventPublisher, meshController, repositorySupplier, securityService);
        }

        @Bean
        GitRepositorySupplier gitRepositorySupplier(InternalRepositoryService repositoryService) {
            return new DefaultGitRepositorySupplier(repositoryService);
        }

        @Bean
        GitRequestHelper gitRequestHelper(MeshRouter meshRouter, MessagePreparer[] messagePreparers, DmzStorageService storageService, @Value(value="${process.timeout.execution:120}") long executionTimeout, @Value(value="${process.timeout.idle:60}") long idleTimeout) {
            return new DefaultGitRequestHelper(meshRouter, messagePreparers, storageService, executionTimeout, idleTimeout);
        }

        @Bean
        @Order(value=2)
        LoggingClientInterceptor loggingClientInterceptor(Environment env, GitScmConfig config) {
            return new LoggingClientInterceptor(env.matchesProfiles(new String[]{"dev"}), config.getGrpcMaxMessageSize());
        }

        @Bean
        MeshNodeLoggingConfigProvider loggingConfigProvider(LoggingService loggingService, ProfilingService profilingService, SecurityService securityService) {
            return new MeshNodeLoggingConfigProvider(loggingService, profilingService, securityService);
        }

        @Bean(destroyMethod="shutdown")
        DefaultMeshClient meshClient(@Qualifier(value="applicationClassLoader") ClassLoader classLoader, GitScmConfig config, ClientInterceptor[] interceptors, MeshService meshService, MutableMeshNodeRegistry nodeRegistry, MeshRouter router, SecurityService securityService, MeshSidebandRegistry sidebandRegistry, TopicService topicService) {
            return new DefaultMeshClient(classLoader, interceptors, meshService, nodeRegistry, router, securityService, sidebandRegistry, topicService, config.getGrpcKeepAliveTime(), config.isGrpcKeepAliveWithoutCallsEnabled(), config.getGrpcMaxMessageSize(), config.getGrpcMaxMetadataSize());
        }

        @Bean
        DmzMeshConsistencyCheckService meshConsistencyCheckService(@Qualifier(value="asyncCommandExecutor") ExecutorService executorService, InternalMeshPartitionRegistry partitionRegistry, RpcRepositoryClient repositoryClient, InternalScmService scmService) {
            return new DefaultMeshConsistencyCheckService(executorService, partitionRegistry, repositoryClient, scmService, 10);
        }

        @Bean
        MeshKeyManager meshKeyManager(@Qualifier(value="applicationClassLoader") ClassLoader classLoader, CacheFactory cacheFactory, MeshKeyRegistry keyRegistry, LockService lockService, @Value(value="${plugin.bitbucket-git.mesh.authentication.expiry-interval:30s}") @DurationUnit(value=ChronoUnit.SECONDS) Duration tokenExpiry) {
            return new DefaultMeshKeyManager(classLoader, cacheFactory, keyRegistry, lockService, tokenExpiry);
        }

        @Bean
        MeshRouter meshRouter(MeshClientConfig clientConfig, ClusterService clusterService, I18nService i18nService, DmzMeshNodeRegistry nodeRegistry, DmzMeshPartitionRegistry partitionRegistry, RequestManager requestManager, SidecarManager sidecarManager) {
            return new DefaultMeshRouter(clientConfig, clusterService, i18nService, nodeRegistry, partitionRegistry, requestManager, sidecarManager);
        }

        @Bean(destroyMethod="shutdown")
        DefaultMeshSidebandRegistry meshSidebandRegistry(EventPublisher eventPublisher, InternalRepositoryHookService hookService, I18nService i18nService, MeshKeyManager meshKeyManager, InternalMeshPartitionRegistry partitionRegistry, RepositorySizeCache repositorySizeCache, RepositorySupplier repositorySupplier, SecurityService securityService, UserService userService) {
            return new DefaultMeshSidebandRegistry(eventPublisher, hookService, i18nService, meshKeyManager, partitionRegistry, repositorySizeCache, repositorySupplier, securityService, userService);
        }

        @Bean
        @DefaultApplicationMode
        DmzMeshTroubleshootingService meshTroubleshootingService(RpcManagementClient managementClient, MeshController meshController, DmzMeshService meshService, InternalMeshPartitionRegistry partitionRegistry, RpcRepositoryClient repositoryClient, RepositoryDao repositoryDao, RepositoryIntegrityHelper repositoryIntegrityHelper) {
            return new DefaultMeshTroubleshootingService(managementClient, meshController, meshService, partitionRegistry, repositoryClient, repositoryDao, repositoryIntegrityHelper);
        }

        @Bean
        @Order(value=5)
        MetadataClientInterceptor metadataClientInterceptor(MetadataProvider[] providers) {
            return new MetadataClientInterceptor(providers);
        }

        @Bean
        MeshNodeLoggingEventListener nodeLoggingEventListener(DmzMeshController controller, SecurityService securityService, TopicService topicService) {
            return new MeshNodeLoggingEventListener(controller, securityService, topicService);
        }

        @Bean(value={"meshPullRequestRefHelper"})
        PullRequestRefHelper pullRequestRefHelper(AuthenticationContext authenticationContext, GitPullRequestCache cache, GitScmConfig config, PullRequestLock lock, RpcPullRequestClient pullRequestClient, GitPullRequestSupplier pullRequestSupplier, DmzStorageService storageService) {
            return new MeshPullRequestRefHelper(authenticationContext, cache, config, lock, pullRequestClient, pullRequestSupplier, storageService);
        }

        @Bean
        @Order(value=8)
        RoutePropagatingClientInterceptor routePropagatingClientInterceptor(MeshRouter router) {
            return new RoutePropagatingClientInterceptor(router);
        }

        @Bean
        RpcBatchClient rpcBatchClient(MeshClient client, I18nService i18nService, GitRequestHelper requestHelper) {
            return new GrpcBatchClient(i18nService, requestHelper, client.newStub(BatchServiceGrpc::newStub));
        }

        @Bean
        RpcCapabilityClient rpcCapabilityClient(MeshClient client, I18nService i18nService, MeshClient meshClient, GitRequestHelper requestHelper) {
            return new GrpcCapabilityClient(i18nService, meshClient, requestHelper, client.newStub(CapabilityServiceGrpc::newStub));
        }

        @Bean
        RpcCommitClient rpcCommitClient(MeshClient client, GitScmConfig config, RepositoryHookService hookService, I18nService i18nService, GitRequestHelper requestHelper) {
            return new GrpcCommitClient(hookService, i18nService, requestHelper, config.getDeadlinePaddingForHooks(), config.getGrpcMaxFragmentSize(), client.newStub(CommitServiceGrpc::newStub));
        }

        @Bean
        RpcContentClient rpcContentClient(MeshClient client, I18nService i18nService, GitRequestHelper requestHelper, SubmoduleUrlBuilder submoduleUrlBuilder) {
            return new GrpcContentClient(i18nService, requestHelper, submoduleUrlBuilder, client.newStub(ContentServiceGrpc::newStub));
        }

        @Bean
        RpcDataClient rpcDataClient(GitCommandBuilderFactory builderFactory, MeshClient client, I18nService i18nService, GitRequestHelper requestHelper, @Value(value="${plugin.bitbucket-git.mesh.upload-files.batch-size:10000}") int batchSize) {
            return new GrpcDataClient(builderFactory, i18nService, requestHelper, client.newStub(GitDataServiceGrpc::newStub), batchSize);
        }

        @Bean
        RpcDiffClient rpcDiffClient(MeshClient client, I18nService i18nService, GitRequestHelper requestHelper) {
            return new GrpcDiffClient(i18nService, requestHelper, client.newStub(DiffServiceGrpc::newStub));
        }

        @Bean
        RpcGitWorkTreeClient rpcGitWorkTreeClient(@Qualifier(value="meshGitWorkTreeCommandBuilderFactory") GitWorkTreeCommandBuilderFactory builderFactory, MeshClient client, I18nService i18nService, GitRequestHelper requestHelper, HomeLayout homeLayout) {
            return new GrpcGitWorkTreeClient(i18nService, requestHelper, builderFactory, homeLayout, client.newStub(WorkTreeServiceGrpc::newStub));
        }

        @Bean
        RpcHookScriptClient rpcHookScriptClient(MeshClient client, I18nService i18nService, GitRequestHelper requestHelper) {
            return new GrpcHookScriptClient(i18nService, requestHelper, client.newStub(HookScriptServiceGrpc::newStub));
        }

        @Bean
        RpcHostingClient rpcHostingClient(MeshClient client, I18nService i18nService, GitRequestHelper requestHelper, InternalRepositoryHookService hookService) {
            return new GrpcHostingClient(i18nService, requestHelper, hookService, client.newStub(HostingServiceGrpc::newStub));
        }

        @Bean
        RpcManagementClient rpcManagementClient(MeshClient client, I18nService i18nService, MeshKeyManager keyManager, GitRepositorySupplier repositorySupplier, GitRequestHelper requestHelper, @Value(value="${mesh.support-zip.rpc-timeout:5}") @DurationUnit(value=ChronoUnit.MINUTES) Duration supportZipTimeout, StorageService storageService) {
            return new GrpcManagementClient(i18nService, keyManager, client, repositorySupplier, requestHelper, storageService, supportZipTimeout, client.newStub(ManagementServiceGrpc::newStub));
        }

        @Bean
        @Order(value=1)
        RpcMetricsClientInterceptor rpcMetricsClientInterceptor(@Value(value="${plugin.bitbucket-git.mesh.diagnostics.too-many-rpcs-per-request.threshold}") int rpcCountThreshold, RequestManager requestManager) {
            return new RpcMetricsClientInterceptor(rpcCountThreshold, requestManager);
        }

        @Bean
        RpcPackCacheClient rpcPackCacheClient(MeshClient client, I18nService i18nService, GitRequestHelper requestHelper) {
            return new GrpcPackCacheClient(i18nService, requestHelper, client.newStub(PackCacheServiceGrpc::newStub));
        }

        @Bean
        RpcPlumbingClient rpcPlumbingClient(MeshClient client, I18nService i18nService, GitRequestHelper requestHelper) {
            return new GrpcPlumbingClient(i18nService, requestHelper, client.newStub(PlumbingServiceGrpc::newStub));
        }

        @Bean
        RpcPorcelainClient rpcPorcelainClient(MeshClient client, I18nService i18nService, GitRequestHelper requestHelper) {
            return new GrpcPorcelainClient(i18nService, requestHelper, client.newStub(PorcelainServiceGrpc::newStub));
        }

        @Bean
        RpcPullRequestClient rpcPullRequestClient(MeshClient client, GitScmConfig config, EventPublisher eventPublisher, RepositoryHookService hookService, I18nService i18nService, GitRequestHelper requestHelper) {
            return new GrpcPullRequestClient(eventPublisher, hookService, i18nService, config.getPullRequestOperationTimeout(), requestHelper, client.newStub(PullRequestServiceGrpc::newStub));
        }

        @Bean
        RpcRefClient rpcRefClient(MeshClient client, I18nService i18nService, GitRequestHelper requestHelper) {
            return new GrpcRefClient(i18nService, requestHelper, client.newStub(RefServiceGrpc::newStub));
        }

        @Bean
        RpcRepositoryClient rpcRepositoryClient(MeshClient client, I18nService i18nService, GitRequestHelper requestHelper, @Value(value="${integrity.check.repository.consistencyChecks.timeout:180}") long verifyConsistencyCheckSeconds) {
            return new GrpcRepositoryClient(i18nService, requestHelper, Duration.ofSeconds(Math.max(5L, verifyConsistencyCheckSeconds)), client.newStub(RepositoryServiceGrpc::newStub));
        }

        @Bean
        RpcTransactionClient rpcTransactionClient(MeshClient client, I18nService i18nService, GitRequestHelper requestHelper) {
            return new GrpcTransactionClient(i18nService, requestHelper, client.newStub(TransactionServiceGrpc::newStub));
        }

        @Bean
        @Order(value=7)
        StateTransferringClientInterceptor stateTransferringClientInterceptor(TransferableStateManager stateManager) {
            return new StateTransferringClientInterceptor(stateManager);
        }

        @Bean
        @Order(value=6)
        ZeroCopyClientInterceptor zeroCopyClientInterceptor(@Value(value="${plugin.bitbucket-git.mesh.grpc.zero-copy:false}") boolean enabled) {
            return new ZeroCopyClientInterceptor(enabled);
        }
    }

    @Configuration
    @EnableConfigurationProperties
    public static class MeshHostingWiring {
        @Bean(value={"gitHttpScmRequestHandler"})
        public GitHttpScmRequestHandler gitHttpScmRequestHandler(AuthenticationContext authenticationContext, GitScmConfig config, EventPublisher eventPublisher, GitHttpErrorHelper gitHttpErrorHelper, HelpPathService helpPathService, RpcHostingClient hostingClient, I18nService i18nService, RepositorySupplier repositorySupplier, RequestManager requestManager, GitWriteTracker writeTracker) {
            return new MeshHttpScmRequestHandler(authenticationContext, config, eventPublisher, gitHttpErrorHelper, helpPathService, hostingClient, i18nService, repositorySupplier, requestManager, writeTracker);
        }

        @Bean(value={"meshGitSshScmRequestHandler"})
        public GitSshScmRequestHandler gitSshScmRequestHandler(GitScmConfig config, EventPublisher eventPublisher, HelpPathService helpPathService, RpcHostingClient hostingClient, I18nService i18nService, RepositorySupplier repositorySupplier, RequestManager requestManager, GitWriteTracker writeTracker) {
            return new MeshSshScmRequestHandler(i18nService, repositorySupplier, config, eventPublisher, helpPathService, hostingClient, requestManager, writeTracker);
        }

        @Bean
        ClusterMetadataProvider clusterMetadataProvider(ClusterService clusterService) {
            return new ClusterMetadataProvider(clusterService);
        }

        @Bean
        MeshGitRepositoryConfigListener gitRepositoryConfigListener(ScheduledExecutorService executorService, RpcRepositoryClient repositoryClient, RepositoryService repositoryService, SecurityService securityService) {
            return new MeshGitRepositoryConfigListener(executorService, repositoryClient, repositoryService, securityService, this.sidecarProperties().isEnabled());
        }

        @Bean
        RequestMetadataProvider requestMetadataProvider(AuthenticationContext authenticationContext, RequestManager requestManager) {
            return new RequestMetadataProvider(authenticationContext, requestManager);
        }

        @Bean
        SidecarProperties sidecarProperties() {
            return new SidecarProperties();
        }
    }
}

