/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git;

import com.atlassian.bitbucket.mesh.rpc.util.ByteStringUtils;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcResolveAnnotatedTagRequest;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.RefChangeType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.SimpleRefChange;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.stash.internal.hook.HookHandler;
import com.atlassian.stash.internal.hook.HookRequest;
import com.atlassian.stash.internal.scm.git.GitHookHandlerFactory;
import com.atlassian.stash.internal.scm.git.mesh.RpcRefClient;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MeshGitHookHandlerFactory
implements GitHookHandlerFactory {
    private final RpcRefClient refClient;

    public MeshGitHookHandlerFactory(RpcRefClient refClient) {
        this.refClient = refClient;
    }

    public HookHandler create(@Nonnull Repository repository, @Nonnull HookRequest hookRequest) {
        return null;
    }

    @Nonnull
    public Collection<RefChange> peelRefChanges(@Nonnull Repository repository, @Nonnull Collection<RefChange> refChanges) {
        Set<String> tagHashes = MeshGitHookHandlerFactory.mapTagHashes(refChanges);
        if (tagHashes.isEmpty()) {
            return refChanges;
        }
        Map<String, String> peeledTags = this.peelTags(repository, tagHashes);
        if (peeledTags.isEmpty()) {
            return refChanges;
        }
        return (Collection)refChanges.stream().map(refChange -> {
            if (refChange.getRef().getType() == StandardRefType.TAG) {
                RefChangeType type = refChange.getType();
                String originalFrom = refChange.getFromHash();
                String originalTo = refChange.getToHash();
                String peeledFrom = type == RefChangeType.ADD ? originalFrom : (String)peeledTags.get(originalFrom);
                String peeledTo = type == RefChangeType.DELETE ? originalTo : (String)peeledTags.get(originalTo);
                return ((SimpleRefChange.Builder)((SimpleRefChange.Builder)new SimpleRefChange.Builder(refChange).fromHash((String)MoreObjects.firstNonNull((Object)peeledFrom, (Object)originalFrom))).toHash((String)MoreObjects.firstNonNull((Object)peeledTo, (Object)originalTo))).build();
            }
            return refChange;
        }).collect(MoreCollectors.toImmutableList());
    }

    private static Set<String> mapTagHashes(Collection<RefChange> refChanges) {
        HashSet<String> tagHashes = new HashSet<String>();
        for (RefChange refChange : refChanges) {
            if (refChange.getRef().getType() != StandardRefType.TAG) continue;
            RefChangeType type = refChange.getType();
            if (type != RefChangeType.ADD) {
                tagHashes.add(refChange.getFromHash());
            }
            if (type == RefChangeType.DELETE) continue;
            tagHashes.add(refChange.getToHash());
        }
        return tagHashes;
    }

    private Map<String, String> peelTags(Repository repository, Set<String> tagHashes) {
        HashMap<String, String> peeledTags = new HashMap<String, String>();
        this.refClient.resolveAnnotatedTags(repository, RpcResolveAnnotatedTagRequest.newBuilder().addAllTagIds(ByteStringUtils.toByteStringsLazily(tagHashes)).setMaxMessageLength(0), tag -> {
            peeledTags.put(tag.getHash(), tag.getLatestCommit());
            return true;
        });
        return peeledTags;
    }
}

