/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.io.IoFunction;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.NoDefaultBranchException;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.SimpleBranch;
import com.atlassian.bitbucket.repository.SimpleRef;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.bitbucket.scm.CommandFailedException;
import com.atlassian.bitbucket.scm.git.GitDetachedHeadException;
import com.atlassian.bitbucket.scm.git.GitException;
import com.atlassian.bitbucket.scm.git.GitRefPattern;
import com.atlassian.bitbucket.scm.git.GitRepositoryLayoutException;
import com.atlassian.bitbucket.util.MoreFiles;
import com.atlassian.stash.internal.scm.git.GitAgent;
import com.atlassian.stash.internal.scm.git.GitScmConfig;
import com.google.common.base.MoreObjects;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import io.atlassian.fugue.Either;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawGitAgent
implements GitAgent {
    private static final String SYMBOLIC_REF = "ref: ";
    private static final Logger log = LoggerFactory.getLogger(RawGitAgent.class);
    private final I18nService i18nService;
    private final GitScmConfig config;

    public RawGitAgent(I18nService i18nService, GitScmConfig config) {
        this.i18nService = i18nService;
        this.config = config;
    }

    @Override
    public void addAlternate(@Nonnull Path repositoryDir, @Nonnull String alternate) {
        Path alternates = MoreFiles.resolve((Path)repositoryDir, (String)"objects", (String[])new String[]{"info", "alternates"});
        Path info = alternates.getParent();
        try {
            MoreFiles.mkdir((Path)info);
        }
        catch (IllegalStateException e) {
            throw new GitRepositoryLayoutException(this.i18nService.createKeyedMessage("bitbucket.git.layout.missing.objects", new Object[]{"objects" + File.separator + String.valueOf(info.getFileName())}), info.toFile());
        }
        try (BufferedWriter writer = Files.newBufferedWriter(alternates, StandardCharsets.UTF_8, StandardOpenOption.APPEND, StandardOpenOption.CREATE);){
            writer.write(alternate);
            writer.write(10);
        }
        catch (IOException e) {
            throw new GitException(this.i18nService.createKeyedMessage("bitbucket.git.alternate.writefailed", new Object[]{alternate, repositoryDir.toAbsolutePath()}), (Throwable)e);
        }
    }

    @Override
    public void createRef(@Nonnull Repository repository, @Nonnull String refName, @Nonnull String hash) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(refName, "refName");
        Objects.requireNonNull(hash, "hash");
        this.createLooseRef(repository, this.config.getRepositoryDir(repository), refName, hash);
    }

    @Override
    public void createSymbolicRef(Repository repository, String refName, String targetRef) {
        Objects.requireNonNull(targetRef, "targetRef");
        this.createRef(repository, refName, SYMBOLIC_REF + targetRef);
    }

    @Override
    public void enableReflog(@Nonnull Repository repository, @Nonnull String refName) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(refName, "refName");
        Path repositoryDir = this.config.getRepositoryDir(repository);
        Path logsDir = repositoryDir.resolve("logs");
        Path ref = logsDir.resolve(refName);
        this.requireFileWithin(ref, repositoryDir);
        if (Files.exists(ref, new LinkOption[0])) {
            log.trace("Logging has already been enabled for {}", (Object)refName);
            return;
        }
        Path refDirectory = ref.getParent();
        try {
            MoreFiles.mkdir((Path)refDirectory);
        }
        catch (IllegalStateException e) {
            throw new CommandFailedException(this.i18nService.createKeyedMessage("bitbucket.git.ref.log.enablefailed", new Object[]{refName, repository.getName(), repository.getId()}), e.getCause());
        }
        try {
            MoreFiles.touch((Path)ref);
        }
        catch (IOException e) {
            throw new CommandFailedException(this.i18nService.createKeyedMessage("bitbucket.git.ref.log.enablefailed", new Object[]{refName, repository.getName(), repository.getId()}));
        }
    }

    @Override
    @Nonnull
    public String getHead(@Nonnull Repository repository) throws GitDetachedHeadException, NoDefaultBranchException {
        Objects.requireNonNull(repository, "repository");
        Path head = this.config.getRepositoryDir(repository).resolve("HEAD");
        log.trace("{}: Loading HEAD from {}", (Object)repository.getId(), (Object)head);
        String value = this.execute(new FirstLineCallback(), head);
        if (value == null) {
            throw new NoDefaultBranchException(this.i18nService.createKeyedMessage("bitbucket.git.no.default.branch.defined", new Object[0]), repository.getName(), null);
        }
        if (value.startsWith(SYMBOLIC_REF)) {
            return value.substring(SYMBOLIC_REF.length());
        }
        KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.git.detached.head", new Object[]{repository.getName(), repository.getId()});
        throw new GitDetachedHeadException(message, value);
    }

    @Override
    public boolean isEmpty(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        Path repositoryDir = Objects.requireNonNull(this.config.getRepositoryDir(repository), "repositoryDir");
        if (this.hasPackedRefs(repositoryDir) || this.hasLooseRefs(repositoryDir)) {
            log.debug("{}: Repository is not empty", (Object)repository);
            return false;
        }
        log.debug("{}: Repository is empty", (Object)repository);
        return true;
    }

    @Override
    @Nonnull
    public String qualifyBranch(@Nonnull String refName) {
        Objects.requireNonNull(refName, "refName");
        return GitRefPattern.HEADS.qualify(refName);
    }

    @Override
    @Nonnull
    public String qualifyTag(@Nonnull String refName) {
        Objects.requireNonNull(refName, "refName");
        return GitRefPattern.TAGS.qualify(refName);
    }

    @Override
    @Nullable
    public Branch resolveBranch(@Nonnull Repository repository, @Nonnull String refName) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(refName, "refName");
        return this.resolveBranch(repository, refName, false);
    }

    @Override
    @Nullable
    public Branch resolveBranch(@Nonnull Repository repository, @Nonnull String refName, boolean absolute) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(refName, "refName");
        String head = this.getHead(repository);
        return this.resolveBranch(repository, refName, absolute, head);
    }

    @Override
    @Nonnull
    public Branch resolveHead(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        String head = this.getHead(repository);
        log.trace("{}: Resolving head {}", (Object)repository.getId(), (Object)head);
        Branch branch = this.resolveBranch(repository, head, true, head);
        if (branch == null) {
            throw new NoDefaultBranchException(this.i18nService.createKeyedMessage("bitbucket.git.no.default.branch", new Object[]{head}), repository.getName(), head);
        }
        return branch;
    }

    @Override
    @Nonnull
    public String revParse(@Nonnull Path repositoryDir, @Nonnull String value) {
        String result;
        Objects.requireNonNull(repositoryDir, "repositoryDir");
        String next = Objects.requireNonNull(value, "value");
        while ((result = this.execute(new FirstLineCallback(), this.safeSubPath(repositoryDir, next))) != null) {
            if (result.startsWith(SYMBOLIC_REF)) {
                next = result.substring(SYMBOLIC_REF.length());
                continue;
            }
            return result;
        }
        String searchId = next;
        String found = this.streamPackedRefs(repositoryDir.resolve(this.isDarkRef(next) ? "stash-packed-refs" : "packed-refs"), (String hash, String refId) -> {
            if (searchId.equals(refId)) {
                return hash;
            }
            return null;
        });
        return (String)MoreObjects.firstNonNull((Object)found, (Object)value);
    }

    @Override
    public void setHead(@Nonnull Path repositoryDir, @Nonnull String refId) {
        Objects.requireNonNull(repositoryDir, "repositoryDir");
        Objects.requireNonNull(refId, "refId");
        Path head = repositoryDir.resolve("HEAD");
        this.requireFileWithin(repositoryDir.resolve(refId), repositoryDir);
        try {
            Files.write(head, Collections.singleton(SYMBOLIC_REF + refId), StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new CommandFailedException(this.i18nService.createKeyedMessage("bitbucket.git.ref.setHead.failed", new Object[]{refId, repositoryDir.getFileName()}), (Throwable)e);
        }
    }

    @Override
    @Nonnull
    public Map<String, Ref> shallowResolveRefs(@Nonnull Repository repository, @Nonnull Collection<String> refIds, boolean absolute) {
        if (refIds.isEmpty()) {
            return Collections.emptyMap();
        }
        Path repositoryDir = this.config.getRepositoryDir(repository);
        HashMap<String, String> absoluteIdByRefId = new HashMap<String, String>();
        HashMap<String, String> resolvedHashByAbsoluteId = new HashMap<String, String>();
        HashMap<String, String> targetRefByAbsoluteId = new HashMap<String, String>();
        HashMap refsToResolve = new HashMap();
        if (absolute) {
            refIds.forEach(refId -> refsToResolve.put(refId, Collections.singletonList(refId)));
        } else {
            refIds.forEach(refId -> refsToResolve.put(refId, this.getRefCandidates((String)refId)));
        }
        Iterator unresolvedIt = refsToResolve.entrySet().iterator();
        block0: while (unresolvedIt.hasNext()) {
            Map.Entry unresolved = unresolvedIt.next();
            List candidates = (List)unresolved.getValue();
            for (int i = 0; i < candidates.size(); ++i) {
                String hash2;
                String candidate = (String)candidates.get(i);
                if (!resolvedHashByAbsoluteId.containsKey(candidate)) {
                    Either<String, Optional<String>> resolved = this.resolveLooseRef(repository, candidate);
                    if (resolved.isLeft()) {
                        unresolvedIt.remove();
                        absoluteIdByRefId.put((String)unresolved.getKey(), candidate);
                        targetRefByAbsoluteId.put(candidate, (String)resolved.left().get());
                    }
                    resolvedHashByAbsoluteId.put(candidate, ((Optional)resolved.getOrElse(Optional.empty())).orElse(null));
                }
                if ((hash2 = (String)resolvedHashByAbsoluteId.get(candidate)) == null) continue;
                absoluteIdByRefId.put((String)unresolved.getKey(), candidate);
                if (i == 0) {
                    unresolvedIt.remove();
                    continue block0;
                }
                unresolved.setValue(candidates.subList(0, i));
                continue block0;
            }
        }
        BiConsumer<String, String> packedRefCallback = (hash, refId) -> {
            Iterator it = refsToResolve.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry unresolved = it.next();
                List candidates = (List)unresolved.getValue();
                for (int i = 0; i < candidates.size(); ++i) {
                    if (!refId.equals(candidates.get(i))) continue;
                    absoluteIdByRefId.put((String)unresolved.getKey(), (String)refId);
                    resolvedHashByAbsoluteId.putIfAbsent((String)refId, (String)hash);
                    if (i == 0) {
                        it.remove();
                        continue;
                    }
                    unresolved.setValue(candidates.subList(0, i + 1));
                }
            }
            targetRefByAbsoluteId.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(refId)).map(Map.Entry::getKey).forEach(absoluteId -> resolvedHashByAbsoluteId.put((String)absoluteId, (String)hash));
        };
        if (!refsToResolve.isEmpty() || !targetRefByAbsoluteId.isEmpty()) {
            this.streamPackedRefs(repositoryDir.resolve("packed-refs"), packedRefCallback);
        }
        if (absolute && !refsToResolve.isEmpty() && refsToResolve.keySet().stream().anyMatch(this::isDarkRef)) {
            this.streamPackedRefs(repositoryDir.resolve("stash-packed-refs"), packedRefCallback);
        }
        Supplier defaultBranchName = Suppliers.memoize(() -> this.getHead(repository));
        HashMap<String, Ref> result = new HashMap<String, Ref>();
        for (String refId2 : refIds) {
            String absoluteId = (String)absoluteIdByRefId.get(refId2);
            if (absoluteId == null) continue;
            if (absoluteId.startsWith(GitRefPattern.TAGS.getPath())) {
                result.put(refId2, (Ref)((SimpleRef.Builder)((SimpleRef.Builder)((SimpleRef.Builder)new SimpleRef.Builder().type((RefType)StandardRefType.TAG).displayId(GitRefPattern.TAGS.unqualify(absoluteId))).id(absoluteId)).latestCommit((String)resolvedHashByAbsoluteId.get(absoluteId))).build());
                continue;
            }
            result.put(refId2, (Ref)((SimpleBranch.Builder)((SimpleBranch.Builder)((SimpleBranch.Builder)((SimpleBranch.Builder)new SimpleBranch.Builder().displayId(GitRefPattern.HEADS.unqualify(absoluteId))).id(absoluteId)).isDefault(absoluteId.equals(defaultBranchName.get()))).latestCommit((String)resolvedHashByAbsoluteId.get(absoluteId))).build());
        }
        return result;
    }

    private void createLooseRef(Repository repository, Path repositoryDir, String refName, String hash) {
        Path ref = this.safeSubPath(repositoryDir, refName);
        Path refDirectory = ref.getParent();
        try {
            MoreFiles.mkdir((Path)refDirectory);
        }
        catch (IllegalStateException e) {
            throw new CommandFailedException(this.i18nService.createKeyedMessage("bitbucket.git.ref.created.failed", new Object[]{refName, repository.getName(), repository.getId()}), e.getCause());
        }
        try {
            Files.write(ref, Collections.singleton(hash), StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new CommandFailedException(this.i18nService.createKeyedMessage("bitbucket.git.ref.created.failed", new Object[]{refName, repository.getName(), repository.getId()}), (Throwable)e);
        }
    }

    private <T> T execute(IoFunction<LineReader, T> callback, Path file) {
        return this.execute(callback, file, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T execute(IoFunction<LineReader, T> callback, Path file, T defaultValue) {
        try (BufferedLineReader reader = new BufferedLineReader(file);){
            Object object = callback.apply((Object)reader);
            return (T)object;
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            return defaultValue;
        }
        catch (IOException e) {
            if (!Files.isDirectory(file, new LinkOption[0])) throw new RuntimeException("Error opening/reading [" + String.valueOf(file.toAbsolutePath()) + "]", e);
            log.debug("{}: Directory found where file was expected", (Object)file, (Object)e);
            return defaultValue;
        }
    }

    private List<String> getRefCandidates(@Nonnull String refId) {
        return Arrays.asList(refId, "refs/" + refId, "refs/tags/" + refId, "refs/heads/" + refId, "refs/remotes/" + refId);
    }

    private boolean hasLooseRefs(Path repositoryDir) {
        final MutableBoolean loose = new MutableBoolean(false);
        final MutableInt directoriesChecked = new MutableInt(0);
        boolean refsDirExists = true;
        try {
            Files.walkFileTree(repositoryDir.resolve("refs"), EnumSet.noneOf(FileVisitOption.class), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    directoriesChecked.increment();
                    return super.preVisitDirectory(dir, attrs);
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    if (file.toString().endsWith(".lock")) {
                        return FileVisitResult.CONTINUE;
                    }
                    loose.setValue(true);
                    return FileVisitResult.TERMINATE;
                }
            });
        }
        catch (NoSuchFileException e) {
            refsDirExists = false;
        }
        catch (IOException e) {
            log.warn("{}: Failed to check for loose refs", (Object)repositoryDir.getFileName(), (Object)e);
        }
        if (loose.isFalse()) {
            log.debug("{}: No loose refs found ('refs/' exists: {}, Directories checked: {})", new Object[]{repositoryDir.getFileName(), refsDirExists, directoriesChecked});
        }
        return loose.isTrue();
    }

    private boolean hasPackedRefs(Path repositoryDir) {
        MutableBoolean packFileExists = new MutableBoolean(false);
        MutableInt linesChecked = new MutableInt(0);
        Path packedRefs = repositoryDir.resolve("packed-refs");
        boolean packed = this.execute(reader -> {
            packFileExists.setTrue();
            String line = reader.readLine();
            while (line != null) {
                linesChecked.increment();
                if (!line.startsWith("#")) {
                    return Boolean.TRUE;
                }
                line = reader.readLine();
            }
            return Boolean.FALSE;
        }, packedRefs, Boolean.FALSE);
        if (!packed) {
            log.debug("{}: No packed refs found (packed-refs exists: {}; lines checked: {})", new Object[]{repositoryDir, packFileExists, linesChecked});
        }
        return packed;
    }

    private boolean isDarkRef(String refId) {
        return !refId.startsWith("refs/");
    }

    private void requireFileWithin(Path testPath, Path expectedParent) {
        try {
            MoreFiles.requireWithin((Path)testPath, (Path)expectedParent);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not verify nested path", e);
        }
    }

    private Branch resolveBranch(Repository repository, String name, boolean absolute, String defaultName) {
        Path repositoryDir = this.config.getRepositoryDir(repository);
        List searchIds = absolute ? Collections.singletonList(name) : GitRefPattern.HEADS.getSearchOrder(name);
        for (String searchId : searchIds) {
            SimpleBranch.Builder builder;
            Path ref = this.safeSubPath(repositoryDir, searchId);
            String hash2 = this.execute(new FirstLineCallback(), ref);
            if (hash2 == null) continue;
            if (hash2.startsWith(SYMBOLIC_REF)) {
                String target = hash2.substring(SYMBOLIC_REF.length());
                Branch resolved = this.resolveBranch(repository, target, true, defaultName);
                if (resolved == null) {
                    log.warn("{}: {} is a symbolic ref to non-existent branch {}", new Object[]{repository.getId(), name, target});
                    return null;
                }
                if (log.isTraceEnabled()) {
                    log.trace("{}: Resolved {} from {} via symbolic ref to {}", new Object[]{repository.getId(), searchId, ref, target});
                }
                builder = new SimpleBranch.Builder(resolved);
            } else {
                if (log.isTraceEnabled()) {
                    log.trace("{}: Resolved {} from {}", new Object[]{repository.getId(), searchId, ref});
                }
                builder = (SimpleBranch.Builder)new SimpleBranch.Builder().latestCommit(hash2);
            }
            return ((SimpleBranch.Builder)((SimpleBranch.Builder)((SimpleBranch.Builder)builder.displayId(GitRefPattern.HEADS.unqualify(searchId))).id(searchId)).isDefault(defaultName.equals(searchId))).build();
        }
        boolean darkRef = absolute && this.isDarkRef(name);
        Path packedRefs = repositoryDir.resolve(darkRef ? "stash-packed-refs" : "packed-refs");
        log.trace("{}: Attempting to resolve {} from {}", new Object[]{repository.getId(), name, packedRefs});
        Branch branch = (Branch)this.streamPackedRefs(packedRefs, (String hash, String refId) -> {
            for (String searchId : searchIds) {
                if (!searchId.equals(refId)) continue;
                refId = GitRefPattern.HEADS.unqualify(refId);
                if (darkRef) {
                    this.createLooseRef(repository, repositoryDir, (String)refId, (String)hash);
                    log.debug("{}: Unpacked {}", (Object)repository, refId);
                }
                return ((SimpleBranch.Builder)((SimpleBranch.Builder)((SimpleBranch.Builder)((SimpleBranch.Builder)new SimpleBranch.Builder().displayId(refId)).id(searchId)).isDefault(defaultName.equals(searchId))).latestCommit(hash)).build();
            }
            return null;
        });
        if (branch == null) {
            log.debug("{}: Could not resolve {} directly or from packed-refs", (Object)repository.getId(), (Object)name);
        }
        return branch;
    }

    private Either<String, Optional<String>> resolveLooseRef(@Nonnull Repository repository, @Nonnull String absoluteRefId) {
        if (absoluteRefId.contains("..")) {
            return Either.right(Optional.empty());
        }
        Path ref = this.safeSubPath(this.config.getRepositoryDir(repository), absoluteRefId);
        String hash = this.execute(new FirstLineCallback(), ref);
        if (hash == null) {
            return Either.right(Optional.empty());
        }
        if (hash.startsWith(SYMBOLIC_REF)) {
            String target = hash.substring(SYMBOLIC_REF.length());
            Either<String, Optional<String>> resolvedTarget = this.resolveLooseRef(repository, target);
            if (resolvedTarget.isLeft() || ((Optional)resolvedTarget.right().get()).isPresent()) {
                return resolvedTarget;
            }
            log.trace("{}: {} is a symbolic ref to {}", new Object[]{repository.getId(), absoluteRefId, target});
            return Either.left((Object)target);
        }
        log.trace("{}: Resolved {} from {} to {}", new Object[]{repository.getId(), absoluteRefId, ref, hash});
        return Either.right(Optional.of(hash));
    }

    private Path safeSubPath(Path parent, String child) {
        Path subPath = parent.resolve(child);
        this.requireFileWithin(subPath, parent);
        return subPath;
    }

    private void streamPackedRefs(Path packedRefsFile, BiConsumer<String, String> refConsumer) {
        this.streamPackedRefs(packedRefsFile, (String hash, String refId) -> {
            refConsumer.accept((String)hash, (String)refId);
            return null;
        });
    }

    private <T> T streamPackedRefs(Path packedRefsFile, BiFunction<String, String, T> refCallback) {
        return this.execute(reader -> {
            String line = reader.readLine();
            while (line != null) {
                if (!line.startsWith("^") && !line.startsWith("#")) {
                    String refId;
                    int index = line.indexOf(32);
                    if (index == -1) {
                        throw new IllegalStateException("Unexpected entry [" + line + "] in " + String.valueOf(packedRefsFile.getFileName()));
                    }
                    String hash = line.substring(0, index);
                    Object result = refCallback.apply(hash, refId = line.substring(index + 1));
                    if (result != null) {
                        return result;
                    }
                }
                line = reader.readLine();
            }
            return null;
        }, packedRefsFile);
    }

    private static class FirstLineCallback
    implements IoFunction<LineReader, String> {
        private FirstLineCallback() {
        }

        public String apply(@Nonnull LineReader reader) throws IOException {
            return reader.readLine();
        }
    }

    private static class BufferedLineReader
    implements LineReader {
        private final Path file;
        private final BufferedReader reader;

        BufferedLineReader(Path file) throws IOException {
            this.file = file;
            this.reader = new BufferedReader(new InputStreamReader(Files.newInputStream(file, new OpenOption[0]), StandardCharsets.UTF_8));
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }

        @Override
        public String readLine() throws IOException {
            String line = this.reader.readLine();
            if (line != null && line.indexOf(65533) != -1) {
                log.warn("{}: Found one or more non-UTF-8 characters: {}", (Object)this.file, (Object)line);
            }
            return line;
        }
    }

    private static interface LineReader
    extends AutoCloseable {
        @Override
        public void close() throws IOException;

        @Nullable
        public String readLine() throws IOException;
    }

    private static class TimeLimitedSizeFileVisitor
    extends SizeFileVisitor {
        private final Repository repository;
        private final long timeoutNs;

        private TimeLimitedSizeFileVisitor(Repository repository, Duration timeout) {
            this.repository = repository;
            this.timeoutNs = System.nanoTime() + timeout.toNanos();
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (System.nanoTime() > this.timeoutNs) {
                log.debug("{}: Timed out sizing loose objects", (Object)this.repository);
                return FileVisitResult.TERMINATE;
            }
            return super.visitFile(file, attrs);
        }
    }

    private static class SizeFileVisitor
    extends SimpleFileVisitor<Path> {
        private long size;

        private SizeFileVisitor() {
        }

        public long getSize() {
            return this.size;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException e) throws IOException {
            if (e instanceof NoSuchFileException) {
                return FileVisitResult.CONTINUE;
            }
            throw e;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (attrs.isRegularFile()) {
                this.size += attrs.size();
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

