/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.scm.cache.ScmCacheConfig;
import com.atlassian.bitbucket.scm.cache.ScmCacheService;
import com.atlassian.bitbucket.scm.cache.internal.DefaultScmCacheService;
import com.atlassian.bitbucket.scm.cache.internal.InternalScmCacheConfig;
import com.atlassian.bitbucket.scm.cache.internal.MeshScmCacheService;
import com.atlassian.bitbucket.scm.cache.internal.ScmCacheExpiryStrategy;
import com.atlassian.bitbucket.scm.cache.internal.mesh.MeshScmCacheConfig;
import com.atlassian.bitbucket.server.ApplicationModeSupplier;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.server.StorageService;
import com.atlassian.bitbucket.topic.TopicService;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.stash.internal.plugin.OsgiServiceDefinition;
import com.atlassian.stash.internal.scm.git.mesh.RpcPackCacheClient;
import com.atlassian.util.contentcache.BackgroundThreadStreamPumper;
import com.atlassian.util.contentcache.CacheExpiryStrategy;
import com.atlassian.util.contentcache.ContentCacheManager;
import com.atlassian.util.contentcache.EvictionStrategy;
import com.atlassian.util.contentcache.FileContentCacheManager;
import com.atlassian.util.contentcache.LruEvictionStrategy;
import com.atlassian.util.contentcache.StreamPumper;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ScmCacheWiring {
    @Bean
    public OsgiServiceDefinition osgiScmCacheConfig(ScmCacheConfig scmCacheConfig) {
        return new OsgiServiceDefinition.Builder((Object)scmCacheConfig).interfaces(ScmCacheConfig.class, new Class[0]).build();
    }

    @Bean
    public OsgiServiceDefinition osgiScmCacheService(ScmCacheService scmCacheService) {
        return new OsgiServiceDefinition.Builder((Object)scmCacheService).interfaces(ScmCacheService.class, new Class[0]).build();
    }

    @Bean(destroyMethod="shutdown")
    FileContentCacheManager scmCacheManager(InternalScmCacheConfig cacheConfig) {
        return new FileContentCacheManager.Builder(cacheConfig.getCacheDir()).evictionFreeSpaceBytes(cacheConfig.getEvictionFreeSpace()).evictionStrategy((EvictionStrategy)new LruEvictionStrategy()).expiryCheckInterval(cacheConfig.getExpiryCheckInterval().getSeconds(), TimeUnit.SECONDS).expiryStrategy((CacheExpiryStrategy)new ScmCacheExpiryStrategy((ScmCacheConfig)cacheConfig)).hysteresis(cacheConfig.getEvictionHysteresis()).minFreeSpaceBytes(cacheConfig.getMinimumFreeSpace()).streamPumper((StreamPumper)new BackgroundThreadStreamPumper("scm-cache-streamer")).build();
    }

    @Configuration
    public static class MeshWiring {
        @Bean(value={"meshScmCacheConfig"}, destroyMethod="destroy", initMethod="init")
        public MeshScmCacheConfig scmCacheConfig(EventPublisher eventPublisher, I18nService i18nService, PluginSettingsFactory pluginSettingsFactory, ApplicationPropertiesService propertiesService, StorageService storageService, PermissionValidationService validationService) {
            return new MeshScmCacheConfig(eventPublisher, i18nService, pluginSettingsFactory, propertiesService, storageService, validationService);
        }

        @Bean(value={"meshScmCacheService"}, destroyMethod="destroy", initMethod="init")
        public DefaultScmCacheService scmCacheService(ApplicationModeSupplier applicationModeSupplier, ContentCacheManager cacheManager, ExecutorService executorService, RpcPackCacheClient packCacheClient, RepositoryService repositoryService, SecurityService securityService, TopicService topicService, PermissionValidationService validationService, @Value(value="${plugin.bitbucket-git.mesh.sidecar.enabled:true}") boolean sidecarEnabled) {
            return new MeshScmCacheService(cacheManager, executorService, packCacheClient, repositoryService, securityService, sidecarEnabled, topicService, validationService, applicationModeSupplier);
        }
    }
}

