/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git;

import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.BitSet;
import org.apache.commons.codec.net.URLCodec;

public class UriEncodingUtils {
    static final BitSet ALPHANUMERIC_CHARS;
    static final BitSet ENCODE_URI_COMPONENTS_WHITELIST;
    static final BitSet ENCODE_URI_COMPONENTS_SHELL_WHITELIST;
    static final BitSet ENCODE_USER_INFO_WHITELISTS;

    private UriEncodingUtils() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is a utility class and should not be instantiated");
    }

    private static String encode(String unescaped, BitSet allowed, String charset) throws URISyntaxException {
        byte[] rawData;
        try {
            rawData = unescaped.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            rawData = unescaped.getBytes();
        }
        try {
            byte[] encoded = URLCodec.encodeUrl((BitSet)allowed, (byte[])rawData);
            return new String(encoded, 0, encoded.length, "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new URISyntaxException(unescaped, "Unable to encode URI");
        }
    }

    public static String encodeComponentForShell(String component, String encoding) throws URISyntaxException {
        return UriEncodingUtils.encode(component, ENCODE_URI_COMPONENTS_SHELL_WHITELIST, encoding);
    }

    public static String encodeURIComponent(String component, String encoding) throws URISyntaxException {
        return UriEncodingUtils.encode(component, ENCODE_URI_COMPONENTS_WHITELIST, encoding);
    }

    public static String encodeUserInfo(String userInfo, String encoding) throws URISyntaxException {
        return UriEncodingUtils.encode(userInfo, ENCODE_USER_INFO_WHITELISTS, encoding);
    }

    static {
        int i;
        ALPHANUMERIC_CHARS = new BitSet(256);
        for (i = 48; i <= 57; ++i) {
            ALPHANUMERIC_CHARS.set(i);
        }
        for (i = 97; i <= 122; ++i) {
            ALPHANUMERIC_CHARS.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            ALPHANUMERIC_CHARS.set(i);
        }
        ENCODE_URI_COMPONENTS_WHITELIST = new BitSet(256);
        ENCODE_URI_COMPONENTS_WHITELIST.or(ALPHANUMERIC_CHARS);
        ENCODE_URI_COMPONENTS_WHITELIST.set(45);
        ENCODE_URI_COMPONENTS_WHITELIST.set(95);
        ENCODE_URI_COMPONENTS_WHITELIST.set(46);
        ENCODE_URI_COMPONENTS_WHITELIST.set(33);
        ENCODE_URI_COMPONENTS_WHITELIST.set(126);
        ENCODE_URI_COMPONENTS_WHITELIST.set(42);
        ENCODE_URI_COMPONENTS_WHITELIST.set(39);
        ENCODE_URI_COMPONENTS_WHITELIST.set(40);
        ENCODE_URI_COMPONENTS_WHITELIST.set(41);
        ENCODE_URI_COMPONENTS_SHELL_WHITELIST = new BitSet(256);
        ENCODE_URI_COMPONENTS_SHELL_WHITELIST.or(ALPHANUMERIC_CHARS);
        ENCODE_URI_COMPONENTS_SHELL_WHITELIST.set(45);
        ENCODE_URI_COMPONENTS_SHELL_WHITELIST.set(95);
        ENCODE_URI_COMPONENTS_SHELL_WHITELIST.set(46);
        ENCODE_URI_COMPONENTS_SHELL_WHITELIST.set(126);
        ENCODE_USER_INFO_WHITELISTS = new BitSet(256);
        ENCODE_USER_INFO_WHITELISTS.or(ALPHANUMERIC_CHARS);
        ENCODE_USER_INFO_WHITELISTS.set(45);
        ENCODE_USER_INFO_WHITELISTS.set(95);
        ENCODE_USER_INFO_WHITELISTS.set(46);
        ENCODE_USER_INFO_WHITELISTS.set(33);
        ENCODE_USER_INFO_WHITELISTS.set(126);
        ENCODE_USER_INFO_WHITELISTS.set(42);
        ENCODE_USER_INFO_WHITELISTS.set(39);
        ENCODE_USER_INFO_WHITELISTS.set(40);
        ENCODE_USER_INFO_WHITELISTS.set(41);
        ENCODE_USER_INFO_WHITELISTS.set(38);
        ENCODE_USER_INFO_WHITELISTS.set(36);
        ENCODE_USER_INFO_WHITELISTS.set(43);
        ENCODE_USER_INFO_WHITELISTS.set(44);
        ENCODE_USER_INFO_WHITELISTS.set(59);
        ENCODE_USER_INFO_WHITELISTS.set(61);
        ENCODE_USER_INFO_WHITELISTS.set(58);
    }
}

