/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.analytics;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.stash.internal.scm.git.GitScmConfig;
import com.atlassian.stash.internal.scm.git.analytics.GitAttributesAnalyticsEvent;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class GitAnalyticsJob {
    private static final JobId INFORMATION_ANALYTICS_JOB_ID = JobId.of((String)GitAnalyticsJobRunner.class.getSimpleName());
    private static final JobRunnerKey INFORMATION_ANALYTICS_JOB_RUNNER_KEY = JobRunnerKey.of((String)GitAnalyticsJobRunner.class.getName());
    private GitScmConfig config;
    private EventPublisher eventPublisher;
    private SchedulerService schedulerService;

    public GitAnalyticsJob(GitScmConfig config, EventPublisher eventPublisher, SchedulerService schedulerService) {
        this.config = config;
        this.eventPublisher = eventPublisher;
        this.schedulerService = schedulerService;
    }

    public void init() throws Exception {
        this.scheduleJob();
    }

    public void destroy() {
        this.unscheduleJob();
    }

    private void scheduleJob() throws SchedulerServiceException {
        long interval = TimeUnit.DAYS.toMillis(1L);
        long firstRun = TimeUnit.MINUTES.toMillis(30L);
        GitAnalyticsJobRunner jobRunner = new GitAnalyticsJobRunner();
        this.schedulerService.registerJobRunner(INFORMATION_ANALYTICS_JOB_RUNNER_KEY, (JobRunner)jobRunner);
        this.schedulerService.scheduleJob(INFORMATION_ANALYTICS_JOB_ID, JobConfig.forJobRunnerKey((JobRunnerKey)INFORMATION_ANALYTICS_JOB_RUNNER_KEY).withRunMode(RunMode.RUN_LOCALLY).withSchedule(Schedule.forInterval((long)interval, (Date)new Date(System.currentTimeMillis() + firstRun))));
    }

    private void unscheduleJob() {
        this.schedulerService.unscheduleJob(INFORMATION_ANALYTICS_JOB_ID);
        this.schedulerService.unregisterJobRunner(INFORMATION_ANALYTICS_JOB_RUNNER_KEY);
    }

    private void publishAnalyticsEvent() {
        this.eventPublisher.publish((Object)new GitAttributesAnalyticsEvent(this, this.config.getVersion().toString()));
    }

    private class GitAnalyticsJobRunner
    implements JobRunner {
        private GitAnalyticsJobRunner() {
        }

        public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
            GitAnalyticsJob.this.publishAnalyticsEvent();
            return JobRunnerResponse.success();
        }
    }
}

