/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.atst;

import com.atlassian.bitbucket.scm.CommandOutputHandler;
import com.atlassian.bitbucket.scm.git.GitException;
import com.atlassian.bitbucket.scm.git.command.GitScmCommandBuilder;
import com.atlassian.bitbucket.util.Version;
import com.atlassian.stash.internal.scm.git.GitScmConfig;
import com.atlassian.stash.internal.scm.git.command.InternalGitCommandBuilderFactory;
import com.atlassian.stash.internal.scm.git.command.version.VersionStdoutHandler;
import com.atlassian.troubleshooting.spi.RootLevelSupportDataAppender;
import com.atlassian.troubleshooting.spi.SupportDataBuilder;
import org.slf4j.LoggerFactory;

public class GitSupportData
extends RootLevelSupportDataAppender {
    private final InternalGitCommandBuilderFactory builderFactory;
    private final GitScmConfig config;

    public GitSupportData(InternalGitCommandBuilderFactory builderFactory, GitScmConfig config) {
        this.builderFactory = builderFactory;
        this.config = config;
    }

    protected void addSupportData(SupportDataBuilder supportDataBuilder) {
        supportDataBuilder = supportDataBuilder.addCategory("bitbucket.atst.git");
        try {
            supportDataBuilder.addValue("bitbucket.atst.git.binary", this.config.getBinary()).addValue("bitbucket.atst.git.version", this.buildVersion());
        }
        catch (GitException e) {
            supportDataBuilder.addValue("bitbucket.atst.git.binary", e.getMessage());
        }
    }

    private String buildVersion() {
        Version currentVersion = null;
        try {
            currentVersion = (Version)((GitScmCommandBuilder)this.builderFactory.builder().command("version")).build((CommandOutputHandler)new VersionStdoutHandler()).call();
        }
        catch (Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Failed to retrieve Git version", (Throwable)e);
        }
        Version startupVersion = this.config.getVersion();
        return currentVersion == null || currentVersion.equals((Object)startupVersion) ? startupVersion.toString() : String.valueOf(currentVersion) + " (" + String.valueOf(startupVersion) + ")";
    }
}

