/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.audit;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.AuditUtils;
import com.atlassian.event.api.EventListener;
import com.atlassian.stash.internal.scm.git.transcode.GitTranscodeDiffSettingsChangedEvent;
import com.google.common.annotations.VisibleForTesting;

public class GitEventListener {
    @VisibleForTesting
    static final String GIT_TRANSCODE_DIFF_DISABLED = "bitbucket.git.audit.action.gittranscodediffdisabled";
    @VisibleForTesting
    static final String GIT_TRANSCODE_DIFF_ENABLED = "bitbucket.git.audit.action.gittranscodediffenabled";
    private final AuditService auditService;

    public GitEventListener(AuditService auditService) {
        this.auditService = auditService;
    }

    @EventListener
    public void onGitTranscodeDiffSettingsChangedEvent(GitTranscodeDiffSettingsChangedEvent event) {
        AuditType type = AuditType.fromI18nKeys((CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.ADVANCED, (String)"bitbucket.service.audit.category.repositories", (String)(event.isEnabled() ? GIT_TRANSCODE_DIFF_ENABLED : GIT_TRANSCODE_DIFF_DISABLED)).build();
        AuditEvent auditEvent = AuditEvent.builder((AuditType)type).affectedObjects(AuditUtils.auditResourcesForProjectAndRepository((Repository)event.getRepository())).build();
        this.auditService.audit(auditEvent);
    }
}

