/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.auth;

import com.atlassian.bitbucket.scm.git.auth.GitAuthHelper;
import com.atlassian.bitbucket.scm.git.command.GitCommandBuilderSupport;
import com.atlassian.stash.internal.scm.git.GitScmConfig;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGitAuthHelper
implements GitAuthHelper {
    private static final String CONFIG_CREDENTIAL_USERNAME = "credential.username";
    private static final String ENV_ASKPASS = "GIT_ASKPASS";
    private static final String ENV_ASKPASS_PASSWORD = "BITBUCKET_ASKPASS_PASSWORD";
    private static final String ENV_SSH = "GIT_SSH";
    private static final String ENV_SSH_EXEC = "BITBUCKET_SSH_EXEC";
    private static final String ENV_SSH_KEY = "BITBUCKET_SSH_KEY";
    private static final String ENV_SSH_VARIANT = "GIT_SSH_VARIANT";
    private static final Logger log = LoggerFactory.getLogger(DefaultGitAuthHelper.class);
    private final GitScmConfig gitScmConfig;

    public DefaultGitAuthHelper(GitScmConfig gitScmConfig) {
        this.gitScmConfig = gitScmConfig;
    }

    @Nonnull
    public <T extends GitCommandBuilderSupport<T>> GitCommandBuilderSupport<T> configure(@Nonnull GitCommandBuilderSupport<T> builder, @Nullable String username, @Nullable String password, @Nullable Path keyFile) {
        Objects.requireNonNull(builder, "builder");
        if (username != null) {
            this.configureDefaultUsername(builder, username);
        }
        this.configurePassword(builder, password);
        this.configureSsh(builder, keyFile);
        return builder;
    }

    private void configureDefaultUsername(@Nonnull GitCommandBuilderSupport<?> builder, @Nonnull String username) {
        Objects.requireNonNull(builder, "builder");
        Objects.requireNonNull(username, "username");
        builder.withConfiguration(CONFIG_CREDENTIAL_USERNAME, username);
    }

    private void configurePassword(@Nonnull GitCommandBuilderSupport<?> builder, String password) {
        Objects.requireNonNull(builder, "builder");
        Path askPassScript = this.gitScmConfig.getAskPassScript();
        if (Files.exists(askPassScript, new LinkOption[0])) {
            builder.withEnvironment(ENV_ASKPASS, askPassScript.toString());
            if (StringUtils.isNotBlank((CharSequence)password)) {
                builder.withEnvironment(ENV_ASKPASS_PASSWORD, password);
            }
        } else {
            log.warn("ASKPASS script {} does not exist. Git operations that require a password will fail", (Object)askPassScript);
        }
    }

    private void configureSsh(@Nonnull GitCommandBuilderSupport<?> builder, Path sshPrivateKeyFile) {
        Objects.requireNonNull(builder, "builder");
        Path sshScript = this.gitScmConfig.getSshScript();
        if (Files.exists(sshScript, new LinkOption[0])) {
            ((GitCommandBuilderSupport)((GitCommandBuilderSupport)builder.withEnvironment(ENV_SSH, sshScript.toString())).withEnvironment(ENV_SSH_VARIANT, "ssh")).withEnvironment(ENV_SSH_EXEC, this.gitScmConfig.getSshBinary());
            if (sshPrivateKeyFile != null) {
                log.trace("Configuring git to use SSH private key file {}", (Object)sshPrivateKeyFile.toAbsolutePath());
                builder.withEnvironment(ENV_SSH_KEY, sshPrivateKeyFile.toAbsolutePath().toString());
            }
        } else {
            log.warn("SSH script {} does not exist. Git operations accessing repositories over SSH may fail", (Object)sshScript);
        }
    }
}

