/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.bulk;

import com.atlassian.bitbucket.io.ByteBufferInputStream;
import com.atlassian.bitbucket.scm.CommandResult;
import com.atlassian.bitbucket.scm.CommandSummary;
import com.atlassian.bitbucket.scm.CommandSummaryHandler;
import com.atlassian.bitbucket.scm.bulk.BulkContentCallback;
import com.atlassian.bitbucket.scm.bulk.BulkFile;
import com.atlassian.stash.internal.scm.git.bulk.FileChangeWithSize;
import com.atlassian.stash.internal.scm.git.command.catfile.AbstractBatchCatFileStdioHandler;
import com.atlassian.stash.internal.scm.git.command.catfile.BatchHeader;
import com.atlassian.stash.internal.scm.git.io.NullTerminatedReader;
import com.atlassian.util.contentcache.util.PipedStreams;
import jakarta.annotation.Nonnull;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class FileReadingBatchCatFileStdioHandler
extends AbstractBatchCatFileStdioHandler<CommandResult>
implements CommandSummaryHandler {
    private final BulkContentCallback callback;
    private final ExecutorService executorService;
    private final NullTerminatedReader reader;
    private FileChangeWithSize fileChange;
    private Future<?> onFileFuture;
    private OnFileTask onFileTask;
    private CommandResult result;

    public FileReadingBatchCatFileStdioHandler(BulkContentCallback callback, ExecutorService executorService, BufferedReader reader) {
        this.callback = callback;
        this.executorService = executorService;
        this.reader = new NullTerminatedReader(reader);
    }

    public CommandResult getOutput() {
        return this.result;
    }

    public void onComplete(@Nonnull CommandSummary summary) {
        this.result = summary.getResult();
    }

    public void onExit(int exitCode) {
        if (this.onFileTask != null) {
            this.onFileTask.close();
            this.onFileTask = null;
        }
        if (this.onFileFuture != null) {
            try {
                this.onFileFuture.get(250L, TimeUnit.MILLISECONDS);
            }
            catch (CancellationException | ExecutionException exception) {
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (TimeoutException e) {
                this.onFileFuture.cancel(true);
            }
            finally {
                this.onFileFuture = null;
            }
        }
    }

    protected String getNextObjectId() {
        try {
            this.fileChange = FileChangeWithSize.read((NullTerminatedReader)this.reader);
            if (this.fileChange == null) {
                return null;
            }
            return this.fileChange.getContentId();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed reading next file change", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean onContent(@Nonnull ByteBuffer content, boolean closed) {
        if (this.onFileTask == null) {
            if (closed) {
                this.callback.onFile((BulkFile)this.fileChange, (InputStream)new ByteBufferInputStream(content));
                return false;
            }
            this.onFileTask = new OnFileTask();
            this.onFileFuture = this.executorService.submit(this.onFileTask);
        }
        RuntimeException toThrow = null;
        try {
            this.onFileTask.write(content, closed);
        }
        catch (IOException e) {
            toThrow = new UncheckedIOException("Failed streaming object contents to callback", e);
            this.onFileTask.close();
        }
        finally {
            if (closed) {
                try {
                    this.onFileFuture.get();
                }
                catch (ExecutionException e) {
                    RuntimeException cause = (RuntimeException)e.getCause();
                    if (toThrow != null) {
                        cause.addSuppressed(toThrow);
                    }
                    toThrow = cause;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                finally {
                    this.onFileFuture = null;
                    this.onFileTask = null;
                }
            }
        }
        if (toThrow != null) {
            throw toThrow;
        }
        return true;
    }

    @Override
    protected void onMissing(@Nonnull String objectId) {
        throw new IllegalStateException("Object with ID " + objectId + " was missing");
    }

    @Override
    protected boolean onObject(@Nonnull BatchHeader header) {
        return true;
    }

    private class OnFileTask
    implements Runnable {
        private final WritableByteChannel channel;
        private final PipedStreams streams = new PipedStreams(16384);

        public OnFileTask() {
            this.channel = Channels.newChannel(this.streams.output());
        }

        @Override
        public void run() {
            FileReadingBatchCatFileStdioHandler.this.callback.onFile((BulkFile)FileReadingBatchCatFileStdioHandler.this.fileChange, this.streams.input());
        }

        void close() {
            this.streams.close();
        }

        void write(ByteBuffer content, boolean closed) throws IOException {
            this.channel.write(content);
            if (closed) {
                this.channel.close();
            }
        }
    }
}

