/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.scm.CommandBuilder;
import com.atlassian.bitbucket.scm.CommandErrorHandler;
import com.atlassian.bitbucket.scm.CommandExitHandler;
import com.atlassian.bitbucket.scm.CommandInputHandler;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.lang3.StringUtils;

@NotThreadSafe
public abstract class AbstractCommandBuilder<B extends CommandBuilder<B>>
implements CommandBuilder<B> {
    protected final LinkedList<String> arguments;
    protected final String binary;
    protected final Map<String, String> environment;
    protected final I18nService i18nService;
    protected CommandExitHandler exitHandler;
    protected CommandInputHandler inputHandler;
    protected CommandErrorHandler errorHandler;
    protected Path workDir;

    protected AbstractCommandBuilder(@Nonnull I18nService i18nService, @Nonnull String binary) {
        this(i18nService, binary, null);
    }

    protected AbstractCommandBuilder(@Nonnull I18nService i18nService, @Nonnull String binary, @Nullable Path workDir) {
        this.binary = this.notBlank(binary);
        this.i18nService = Objects.requireNonNull(i18nService, "i18nService");
        this.workDir = this.directoryExistsOrIsNull(workDir);
        this.arguments = new LinkedList();
        this.environment = new HashMap<String, String>();
    }

    @Nonnull
    public B argument(@Nonnull String argument) {
        this.arguments.add(this.notBlank(argument));
        return this.self();
    }

    @Nonnull
    public B argumentAfter(@Nonnull String anchor, @Nonnull String argument) {
        int index = this.arguments.indexOf(this.notBlank(anchor, "anchor"));
        if (index == -1) {
            return this.argument(argument);
        }
        return this.argumentAt(index + 1, argument);
    }

    @Nonnull
    public B argumentAt(int index, @Nonnull String argument) {
        this.arguments.add(index, this.notBlank(argument));
        return this.self();
    }

    @Nonnull
    public B argumentBefore(@Nonnull String anchor, @Nonnull String argument) {
        int index = this.arguments.indexOf(this.notBlank(anchor, "anchor"));
        if (index == -1) {
            return this.argument(argument);
        }
        return this.argumentAt(index, argument);
    }

    @Nonnull
    public B clearArguments() {
        this.arguments.clear();
        return this.self();
    }

    @Nonnull
    public B clearEnvironment() {
        this.environment.clear();
        return this.self();
    }

    @Nonnull
    public B removeEnvironment(@Nonnull String name) {
        this.environment.remove(Objects.requireNonNull(name, "name"));
        return this.self();
    }

    @Nonnull
    public B clearInputHandler() {
        this.inputHandler = null;
        return this.self();
    }

    @Nonnull
    public B defaultErrorHandler() {
        this.errorHandler = null;
        return this.self();
    }

    @Nonnull
    public B defaultExitHandler() {
        this.exitHandler = null;
        return this.self();
    }

    @Nonnull
    public B errorHandler(@Nonnull CommandErrorHandler value) {
        this.errorHandler = Objects.requireNonNull(value, "errorHandler");
        return this.self();
    }

    @Nonnull
    public B exitHandler(@Nonnull CommandExitHandler value) {
        this.exitHandler = Objects.requireNonNull(value, "exitHandler");
        return this.self();
    }

    @Nonnull
    public B inputHandler(@Nonnull CommandInputHandler value) {
        this.inputHandler = Objects.requireNonNull(value, "inputHandler");
        return this.self();
    }

    @Nonnull
    public B rawArgument(@Nonnull String argument) {
        this.arguments.add(Objects.requireNonNull(argument, "argument"));
        return this.self();
    }

    @Nonnull
    public B rawArgumentAfter(@Nonnull String anchor, @Nonnull String argument) {
        int index = this.arguments.indexOf(Objects.requireNonNull(anchor, "anchor"));
        if (index == -1) {
            return this.rawArgument(argument);
        }
        return this.rawArgumentAt(index + 1, argument);
    }

    @Nonnull
    public B rawArgumentAt(int index, @Nonnull String argument) {
        this.arguments.add(index, Objects.requireNonNull(argument, "argument"));
        return this.self();
    }

    @Nonnull
    public B rawArgumentBefore(@Nonnull String anchor, @Nonnull String argument) {
        int index = this.arguments.indexOf(Objects.requireNonNull(anchor, "anchor"));
        if (index == -1) {
            return this.rawArgument(argument);
        }
        return this.rawArgumentAt(index, argument);
    }

    @Nonnull
    public B withEnvironment(@Nonnull String name, @Nonnull String value) {
        this.environment.put(this.notBlank(name, "name"), this.notBlank(value, "value"));
        return this.self();
    }

    @Nonnull
    protected Path directoryExists(@Nonnull Path value) {
        return AbstractCommandBuilder.existsAndIsDirectory(Objects.requireNonNull(value, "workDir"));
    }

    @Nullable
    protected Path directoryExistsOrIsNull(@Nullable Path value) {
        return value == null ? null : AbstractCommandBuilder.existsAndIsDirectory(value);
    }

    @Nonnull
    protected String notBlank(@Nullable String argument) {
        return this.notBlank(argument, "argument");
    }

    protected String notBlank(@Nullable String value, @Nullable String name) {
        Objects.requireNonNull(value, name);
        value = value.trim();
        if (value.isEmpty()) {
            throw new IllegalArgumentException("A non-blank " + StringUtils.defaultString((String)name, (String)"value") + " is required");
        }
        return value;
    }

    protected abstract B self();

    @Nonnull
    protected static Path existsAndIsDirectory(@Nonnull Path value) {
        if (Files.isDirectory(value, new LinkOption[0])) {
            return value;
        }
        if (Files.exists(value, new LinkOption[0])) {
            throw new IllegalArgumentException("[" + String.valueOf(value.toAbsolutePath()) + " is not a directory");
        }
        throw new IllegalArgumentException("[" + String.valueOf(value.toAbsolutePath()) + "] does not exist");
    }
}

