/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command;

import com.atlassian.bitbucket.dmz.process.LoggingStdoutHandler;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.CommandExitHandler;
import com.atlassian.bitbucket.scm.CommandOutputHandler;
import com.atlassian.bitbucket.scm.git.command.GitCommand;
import com.atlassian.bitbucket.scm.git.command.GitCommandBuilderSupport;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.Person;
import com.atlassian.stash.internal.scm.git.command.GitFreeFormCommandBuilder;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractGitCommandBuilder<B extends GitCommandBuilderSupport<B>>
implements GitCommandBuilderSupport<B> {
    protected final GitFreeFormCommandBuilder builder;

    protected AbstractGitCommandBuilder(GitFreeFormCommandBuilder builder) {
        this.builder = builder;
    }

    @Nonnull
    public B alternate(@Nonnull Repository alternate) {
        this.builder.alternate(alternate);
        return this.self();
    }

    @Nonnull
    public B alternates(@Nonnull Iterable<Repository> alternates) {
        this.builder.alternates(alternates);
        return this.self();
    }

    @Nonnull
    public B alternates(@Nonnull Repository alternate, Repository ... alternates) {
        this.builder.alternates(alternate, alternates);
        return this.self();
    }

    @Nonnull
    public B author(@Nonnull ApplicationUser value) {
        this.builder.author(value);
        return this.self();
    }

    @Nonnull
    public B author(@Nonnull Person value) {
        this.builder.author(value);
        return this.self();
    }

    @Nonnull
    public B author(@Nonnull String displayName, @Nonnull String email) {
        this.builder.author(displayName, email);
        return this.self();
    }

    @Nonnull
    public <T> GitCommand<T> build(@Nonnull CommandOutputHandler<T> outputHandler) {
        Objects.requireNonNull(outputHandler, "outputHandler");
        this.builder.clearArguments();
        this.applyArguments();
        return this.builder.build(outputHandler);
    }

    @Nonnull
    public B clearEnvironment() {
        this.builder.clearEnvironment();
        return this.self();
    }

    @Nonnull
    public B commitish(@Nonnull String value) {
        this.builder.commitish(value);
        return this.self();
    }

    @Nonnull
    public B committer(@Nonnull ApplicationUser value) {
        this.builder.committer(value);
        return this.self();
    }

    @Nonnull
    public B committer(@Nonnull Person value) {
        this.builder.committer(value);
        return this.self();
    }

    @Nonnull
    public B committer(@Nonnull String displayName, @Nonnull String email) {
        this.builder.committer(displayName, email);
        return this.self();
    }

    @Nonnull
    public B defaultExitHandler() {
        this.builder.defaultExitHandler();
        return this.self();
    }

    @Nonnull
    public B exitHandler(@Nonnull CommandExitHandler value) {
        this.builder.exitHandler(value);
        return this.self();
    }

    @Nonnull
    public B removeEnvironment(@Nonnull String name) {
        this.builder.removeEnvironment(name);
        return this.self();
    }

    @Nonnull
    public B treeish(@Nonnull String value) {
        this.builder.treeish(value);
        return this.self();
    }

    @Nonnull
    public B withConfiguration(@Nonnull String key) {
        this.builder.withConfiguration(key);
        return this.self();
    }

    @Nonnull
    public B withConfiguration(@Nonnull String key, boolean value) {
        this.builder.withConfiguration(key, value);
        return this.self();
    }

    @Nonnull
    public B withConfiguration(@Nonnull String key, long value) {
        this.builder.withConfiguration(key, value);
        return this.self();
    }

    @Nonnull
    public B withConfiguration(@Nonnull String key, @Nullable String value) {
        this.builder.withConfiguration(key, value);
        return this.self();
    }

    @Nonnull
    public B withEnvironment(@Nonnull String name, @Nonnull String value) {
        this.builder.withEnvironment(name, value);
        return this.self();
    }

    protected abstract void applyArguments();

    protected GitCommand<Void> buildWithLoggingHandler() {
        return this.build((CommandOutputHandler<T>)((CommandOutputHandler)new LoggingStdoutHandler()));
    }

    @Nonnull
    protected String checkNotBlank(String argument, String name) {
        Objects.requireNonNull(argument, name);
        argument = argument.trim();
        Preconditions.checkArgument((!argument.isEmpty() ? 1 : 0) != 0, (String)"A non-blank %s is required", (Object)StringUtils.defaultString((String)name, (String)"value"));
        return argument;
    }

    @Nonnull
    protected abstract B self();

    protected static boolean addIfNotBlank(Collection<String> collection, String value) {
        return StringUtils.isNotBlank((CharSequence)value) && collection.add(value);
    }

    protected static void addIfNotBlank(Collection<String> collection, String value, String ... values) {
        AbstractGitCommandBuilder.addIfNotBlank(collection, value);
        if (values != null && values.length > 0) {
            AbstractGitCommandBuilder.addIfNotBlank(collection, Arrays.asList(values));
        }
    }

    protected static void addIfNotBlank(Collection<String> collection, Iterable<String> values) {
        if (values != null) {
            Iterables.addAll(collection, (Iterable)Iterables.filter(values, StringUtils::isNotBlank));
        }
    }
}

