/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command;

import com.atlassian.bitbucket.dmz.process.NioProcess;
import com.atlassian.bitbucket.dmz.process.NioStdioHandler;
import com.atlassian.bitbucket.dmz.process.NioStdoutHandler;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.scm.CommandErrorHandler;
import com.atlassian.bitbucket.scm.CommandInputHandler;
import com.atlassian.bitbucket.scm.CommandOutputHandler;
import com.atlassian.bitbucket.scm.CommandOutputHandlerSupport;
import com.atlassian.bitbucket.scm.CommandSummary;
import com.atlassian.bitbucket.scm.CommandSummaryHandler;
import com.atlassian.bitbucket.scm.ProcessFailedException;
import com.atlassian.bitbucket.scm.Watchdog;
import com.atlassian.stash.internal.scm.git.command.Completable;
import com.atlassian.stash.internal.scm.git.command.InputPump;
import com.atlassian.stash.internal.scm.git.command.OutputPump;
import com.google.common.base.Throwables;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class BioStdioHandler<T>
implements CommandInputHandler,
CommandSummaryHandler,
NioStdoutHandler<T>,
NioStdioHandler<T> {
    private final ExecutorService executorService;
    private final I18nService i18nService;
    private final CommandOutputHandler<T> outputHandler;
    private final OutputPump stderr;
    private final InputPump stdin;
    private final OutputPump stdout;
    private volatile int exitCode;
    private volatile NioProcess process;
    private Future<?> stderrFuture;
    private Future<?> stdinFuture;
    private Future<?> stdoutFuture;
    private Throwable thrown;

    public BioStdioHandler(@Nonnull ExecutorService executorService, @Nonnull I18nService i18nService, CommandInputHandler inputHandler, @Nonnull CommandOutputHandler<T> outputHandler, CommandErrorHandler errorHandler) {
        this.executorService = Objects.requireNonNull(executorService, "executorService");
        this.i18nService = Objects.requireNonNull(i18nService, "i18nService");
        this.outputHandler = Objects.requireNonNull(outputHandler, "outputHandler");
        this.exitCode = -1;
        RemoteWatchdog watchdog = new RemoteWatchdog();
        this.stderr = errorHandler == null ? null : new OutputPump((CommandOutputHandlerSupport)errorHandler, watchdog);
        this.stdin = inputHandler == null ? null : new InputPump(inputHandler, watchdog);
        this.stdout = new OutputPump((CommandOutputHandlerSupport)outputHandler, watchdog);
    }

    public void complete() {
        throw new UnsupportedOperationException("BIO processes are not supported");
    }

    public T getOutput() {
        return (T)this.outputHandler.getOutput();
    }

    public boolean isNioOnly() {
        return false;
    }

    public void onComplete(@Nonnull CommandSummary summary) throws IOException {
        Throwable thrown = this.thrown;
        if (this.exitCode != 0 && thrown == null) {
            thrown = new ProcessFailedException(this.i18nService.createKeyedMessage("bitbucket.scm.command.failed", new Object[]{this.process.toString(), this.exitCode}), this.exitCode);
        }
        thrown = this.summarize(summary, thrown);
        Throwables.propagateIfPossible((Throwable)thrown, IOException.class);
    }

    public void onExit(int exitCode) {
        this.exitCode = exitCode;
        if (this.stderr != null) {
            this.stderr.close();
        }
        if (this.stdin != null) {
            this.stdin.close();
        }
        this.stdout.close();
        BioStdioHandler.getOrInterrupt(this.stdoutFuture);
        BioStdioHandler.getOrInterrupt(this.stderrFuture);
        BioStdioHandler.getOrInterrupt(this.stdinFuture);
    }

    public void onPreStart(@Nonnull NioProcess process) {
        this.process = process;
    }

    public void onStart(@Nonnull NioProcess process) {
        if (this.stderr != null) {
            this.stderrFuture = this.executorService.submit(this.stderr);
        }
        this.stdoutFuture = this.executorService.submit(this.stdout);
        if (this.stdin != null) {
            this.stdinFuture = this.executorService.submit(this.stdin);
            process.wantWrite();
        }
    }

    public void onStderr(@Nonnull ByteBuffer buffer, boolean closed) {
        if (this.stderr == null) {
            return;
        }
        this.stderr.pump(buffer);
    }

    public boolean onStdinReady(@Nonnull ByteBuffer buffer) {
        boolean hasMore;
        boolean bl = hasMore = this.stdin != null && this.stdin.onStdinReady(buffer);
        if (!hasMore) {
            this.process.closeStdin(false);
        }
        return hasMore;
    }

    public void onStdout(@Nonnull ByteBuffer buffer, boolean closed) {
        this.stdout.pump(buffer);
    }

    public void process(@Nonnull InputStream output) {
        throw new UnsupportedOperationException("BIO processes are not supported");
    }

    public void process(@Nonnull OutputStream input) {
        throw new UnsupportedOperationException("BIO processes are not supported");
    }

    public void setWatchdog(@Nonnull Watchdog watchdog) {
        throw new UnsupportedOperationException("BIO processes are not supported");
    }

    private static Throwable fireComplete(Completable pump, CommandSummary summary, Throwable thrown) {
        try {
            pump.complete(summary);
        }
        catch (IOException e) {
            if (thrown == null) {
                return e;
            }
            thrown.addSuppressed(e);
        }
        return thrown;
    }

    private static void getOrInterrupt(Future<?> future) {
        if (future == null) {
            return;
        }
        try {
            future.get(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | CancellationException | ExecutionException exception) {
        }
        catch (TimeoutException e) {
            future.cancel(true);
        }
    }

    private Throwable summarize(CommandSummary summary, Throwable thrown) {
        thrown = BioStdioHandler.fireComplete(this.stdout, summary, thrown);
        if (this.stderr != null) {
            thrown = BioStdioHandler.fireComplete(this.stderr, summary, thrown);
        }
        if (this.stdin != null) {
            thrown = BioStdioHandler.fireComplete(this.stdin, summary, thrown);
        }
        return thrown;
    }

    class RemoteWatchdog
    implements Watchdog {
        RemoteWatchdog() {
        }

        public void cancel() {
            BioStdioHandler.this.process.cancel();
        }

        public boolean isCanceled() {
            return BioStdioHandler.this.process.isCanceled();
        }

        public void reportError(@Nonnull Throwable t) {
            if (BioStdioHandler.this.thrown == null) {
                BioStdioHandler.this.thrown = t;
            } else {
                BioStdioHandler.this.thrown.addSuppressed(t);
            }
        }

        public void resetWatchdog() {
        }
    }
}

