/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.InvalidRefNameException;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.Command;
import com.atlassian.bitbucket.scm.CommandAware;
import com.atlassian.bitbucket.scm.CommandExitHandler;
import com.atlassian.bitbucket.scm.CommandOutputHandler;
import com.atlassian.bitbucket.scm.CommandSetupException;
import com.atlassian.bitbucket.scm.git.command.GitCommand;
import com.atlassian.bitbucket.scm.git.command.GitCommandExitHandler;
import com.atlassian.bitbucket.scm.git.worktree.GitWorkTree;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.Person;
import com.atlassian.bitbucket.util.MoreFiles;
import com.atlassian.stash.internal.scm.git.GitCommandCreator;
import com.atlassian.stash.internal.scm.git.GitQuarantineEnvironment;
import com.atlassian.stash.internal.scm.git.GitScmConfig;
import com.atlassian.stash.internal.scm.git.command.AbstractScmCommandBuilder;
import com.atlassian.stash.internal.scm.git.command.GitFreeFormCommandBuilder;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableInt;

public class DefaultGitFreeFormCommandBuilder
extends AbstractScmCommandBuilder<GitFreeFormCommandBuilder>
implements GitFreeFormCommandBuilder {
    protected final Set<Repository> alternates;
    protected final Map<String, String> configuration;
    protected final Repository repository;
    protected final GitWorkTree workTree;
    private final GitCommandCreator commandCreator;
    private final GitScmConfig config;
    private boolean hasAuthor;
    private boolean hasCommitter;
    private GitQuarantineEnvironment quarantineEnvironment;

    public DefaultGitFreeFormCommandBuilder(@Nonnull I18nService i18nService, @Nonnull GitCommandCreator commandCreator, @Nonnull GitScmConfig config, @Nullable Repository repository) {
        this(i18nService, commandCreator, config, repository, null);
    }

    protected DefaultGitFreeFormCommandBuilder(@Nonnull I18nService i18nService, @Nonnull GitCommandCreator commandCreator, @Nonnull GitScmConfig config, @Nullable Repository repository, @Nullable GitWorkTree workTree) {
        super(i18nService, Objects.requireNonNull(config, "config").getBinary(), DefaultGitFreeFormCommandBuilder.chooseWorkDir(config, repository, workTree));
        this.commandCreator = Objects.requireNonNull(commandCreator, "commandCreator");
        this.config = config;
        this.repository = repository;
        this.workTree = workTree;
        this.alternates = new HashSet<Repository>();
        this.configuration = new LinkedHashMap<String, String>();
    }

    @Nonnull
    public GitFreeFormCommandBuilder alternate(@Nonnull Repository alternate) {
        this.alternates.add(Objects.requireNonNull(alternate, "alternate"));
        return this.self();
    }

    @Nonnull
    public GitFreeFormCommandBuilder alternates(@Nonnull Iterable<Repository> values) {
        Iterator<Repository> iterator = Objects.requireNonNull(values, "alternates").iterator();
        int i = 0;
        while (iterator.hasNext()) {
            this.alternates.add(Objects.requireNonNull(iterator.next(), "alternates[" + i + "]"));
            ++i;
        }
        return this.self();
    }

    @Nonnull
    public GitFreeFormCommandBuilder alternates(@Nonnull Repository value, Repository ... values) {
        Objects.requireNonNull(value, "alternate");
        Objects.requireNonNull(values, "alternates");
        this.alternates.add(value);
        for (int i = 0; i < values.length; ++i) {
            this.alternates.add(Objects.requireNonNull(values[i], "alternates[" + i + "]"));
        }
        return this.self();
    }

    @Nonnull
    public GitFreeFormCommandBuilder author(@Nonnull ApplicationUser author) {
        return this.author(author.getDisplayName(), author.getEmailAddress());
    }

    @Nonnull
    public GitFreeFormCommandBuilder author(@Nonnull Person author) {
        if (author instanceof ApplicationUser) {
            return this.author((ApplicationUser)author);
        }
        return this.author(author.getName(), author.getEmailAddress());
    }

    @Nonnull
    public GitFreeFormCommandBuilder author(@Nonnull String displayName, @Nonnull String email) {
        this.withEnvironment("GIT_AUTHOR_EMAIL", email);
        this.withEnvironment("GIT_AUTHOR_NAME", displayName);
        this.hasAuthor = true;
        if (!this.hasCommitter) {
            this.committer(displayName, email);
        }
        return this.self();
    }

    @Nonnull
    public <T> GitCommand<T> build(@Nonnull CommandOutputHandler<T> outputHandler) {
        ArrayList<String> effectiveArguments = new ArrayList<String>(this.arguments);
        String effectiveCommand = this.getEffectiveCommand(effectiveArguments);
        HashMap<String, String> effectiveEnvironment = new HashMap<String, String>(this.environment);
        this.applyConfiguration(effectiveEnvironment);
        if (this.shouldApplyQuarantine()) {
            this.applyQuarantine(effectiveEnvironment);
        }
        CommandExitHandler effectiveExitHandler = this.applyAlternates(effectiveEnvironment, (CommandExitHandler)(this.exitHandler == null ? this.createExitHandler() : this.exitHandler));
        GitCommand<T> command = this.commandCreator.create(this.mergeArguments(effectiveCommand, effectiveArguments), effectiveEnvironment, this.getWorkDir(), outputHandler, effectiveExitHandler, this.inputHandler, this.errorHandler);
        DefaultGitFreeFormCommandBuilder.maybeSetCommand(this.errorHandler, command);
        DefaultGitFreeFormCommandBuilder.maybeSetCommand(this.inputHandler, command);
        DefaultGitFreeFormCommandBuilder.maybeSetCommand(outputHandler, command);
        return command;
    }

    @Nonnull
    public GitFreeFormCommandBuilder commitish(@Nonnull String value) {
        if ((value = this.notBlank(value, "commitish")).startsWith("-")) {
            throw new InvalidRefNameException(this.i18nService.createKeyedMessage("bitbucket.git.commandbuilder.invalidcommitish", new Object[]{value}), value);
        }
        this.rawArgument(value);
        return this.self();
    }

    @Nonnull
    public GitFreeFormCommandBuilder committer(@Nonnull ApplicationUser value) {
        this.committer(value.getDisplayName(), value.getEmailAddress());
        return this.self();
    }

    @Nonnull
    public GitFreeFormCommandBuilder committer(@Nonnull Person committer) {
        if (committer instanceof ApplicationUser) {
            return this.committer((ApplicationUser)committer);
        }
        return this.committer(committer.getName(), committer.getEmailAddress());
    }

    @Nonnull
    public GitFreeFormCommandBuilder committer(@Nonnull String displayName, @Nonnull String email) {
        this.withEnvironment("GIT_COMMITTER_EMAIL", email);
        this.withEnvironment("GIT_COMMITTER_NAME", displayName);
        this.hasCommitter = true;
        if (!this.hasAuthor) {
            this.author(displayName, email);
        }
        return this.self();
    }

    @Override
    @Nonnull
    public GitFreeFormCommandBuilder defaultExitHandler() {
        return (GitFreeFormCommandBuilder)this.exitHandler((CommandExitHandler)this.createExitHandler());
    }

    @Override
    public Repository getRepository() {
        return this.repository;
    }

    @Override
    public GitWorkTree getWorkTree() {
        return this.workTree;
    }

    @Nonnull
    public GitFreeFormCommandBuilder treeish(@Nonnull String value) {
        if (Objects.requireNonNull(value, "treeish").startsWith("-")) {
            throw new InvalidRefNameException(this.i18nService.createKeyedMessage("bitbucket.git.commandbuilder.invalidtreeish", new Object[]{value}), value);
        }
        this.rawArgument(value);
        return this.self();
    }

    @Nonnull
    public GitFreeFormCommandBuilder withConfiguration(@Nonnull String key) {
        this.configuration.put(this.notBlank(key, "key"), null);
        return this.self();
    }

    @Nonnull
    public GitFreeFormCommandBuilder withConfiguration(@Nonnull String key, boolean value) {
        this.configuration.put(this.notBlank(key, "key"), Boolean.toString(value));
        return this.self();
    }

    @Nonnull
    public GitFreeFormCommandBuilder withConfiguration(@Nonnull String key, long value) {
        this.configuration.put(this.notBlank(key, "key"), Long.toString(value));
        return this.self();
    }

    @Nonnull
    public GitFreeFormCommandBuilder withConfiguration(@Nonnull String key, @Nullable String value) {
        this.configuration.put(this.notBlank(key, "key"), StringUtils.defaultString((String)value));
        return this.self();
    }

    @Override
    @Nonnull
    public GitFreeFormCommandBuilder withQuarantine(@Nonnull GitQuarantineEnvironment environment) {
        this.quarantineEnvironment = environment;
        return this.self();
    }

    protected void applyQuarantine(Map<String, String> environment) {
        this.quarantineEnvironment.asMap().forEach((key, value) -> {
            String collision = environment.put((String)key, (String)value);
            if (collision != null && !collision.equals(value)) {
                throw new CommandSetupException(this.i18nService.createKeyedMessage("bitbucket.git.quarantine.configuration.failed", new Object[]{key, collision, value}));
            }
        });
    }

    @Override
    @Nonnull
    public GitFreeFormCommandBuilder workDir(@Nonnull Path value) {
        this.workDir = DefaultGitFreeFormCommandBuilder.existsAndIsDirectory(Objects.requireNonNull(value, "workDir"));
        return this.self();
    }

    @Nonnull
    protected GitCommandExitHandler createExitHandler() {
        return new GitCommandExitHandler(this.i18nService, this.repository);
    }

    protected String getEffectiveCommand(List<String> arguments) {
        if (this.command == null) {
            if (arguments.isEmpty()) {
                throw new IllegalStateException("No command was provided to run");
            }
            return arguments.remove(0);
        }
        return this.command;
    }

    protected static void maybeSetCommand(Object handler, Command<?> command) {
        if (handler instanceof CommandAware) {
            ((CommandAware)handler).setCommand(command);
        }
    }

    @Override
    protected GitFreeFormCommandBuilder self() {
        return this;
    }

    protected boolean shouldApplyQuarantine() {
        if (this.quarantineEnvironment == null || this.getWorkDir() == null) {
            return false;
        }
        Path repositoryDir = this.config.getRepositoryDir(this.quarantineEnvironment.getRepository());
        Path workDir = this.getWorkDir();
        try {
            return MoreFiles.isWithin((Path)repositoryDir, (Path)workDir);
        }
        catch (IOException e) {
            return repositoryDir.equals(workDir);
        }
    }

    private static Path chooseWorkDir(@Nonnull GitScmConfig config, @Nullable Repository repository, @Nullable GitWorkTree workTree) {
        return null;
    }

    private CommandExitHandler applyAlternates(Map<String, String> environment, CommandExitHandler exitHandler) {
        this.alternates.remove(this.repository);
        if (this.repository == null || this.alternates.isEmpty()) {
            return exitHandler;
        }
        String alternateObjectsDirs = this.createAlternatesEnvironmentVariable(environment.get("GIT_ALTERNATE_OBJECT_DIRECTORIES"));
        if (alternateObjectsDirs.length() > this.config.getEnvironmentVariableSize()) {
            String objectDir = environment.get("GIT_OBJECT_DIRECTORY");
            Path customObjectDir = this.createObjectsDirForAlternates(objectDir);
            environment.put("GIT_OBJECT_DIRECTORY", customObjectDir.toAbsolutePath().toString());
            exitHandler = new CleanupExitHandler(exitHandler, customObjectDir, StringUtils.isNotBlank((CharSequence)objectDir));
        } else {
            environment.put("GIT_ALTERNATE_OBJECT_DIRECTORIES", alternateObjectsDirs);
        }
        return exitHandler;
    }

    private void applyConfiguration(Map<String, String> environment) {
        if (this.configuration.isEmpty()) {
            return;
        }
        MutableInt counter = new MutableInt(Integer.parseInt(environment.getOrDefault("GIT_CONFIG_COUNT", "0")));
        this.configuration.forEach((key, value) -> {
            int index = counter.getAndIncrement();
            environment.put("GIT_CONFIG_KEY_" + index, (String)key);
            environment.put("GIT_CONFIG_VALUE_" + index, value == null ? "true" : value);
        });
        environment.put("GIT_CONFIG_COUNT", counter.toString());
    }

    private String createAlternatesEnvironmentVariable(String existing) {
        Stream<String> stream = this.alternates.stream().map(alternate -> this.getObjectDir((Repository)alternate, false));
        if (StringUtils.isNotBlank((CharSequence)existing)) {
            stream = Stream.concat(Stream.of(existing), stream);
        }
        if (this.isQuarantineAlternate()) {
            stream = Stream.concat(stream, Stream.of(this.quarantineEnvironment.getQuarantinePath()));
        }
        return stream.collect(Collectors.joining(File.pathSeparator));
    }

    private Path createObjectsDirForAlternates(String existing) {
        Path objDir = null;
        try {
            objDir = StringUtils.isBlank((CharSequence)existing) ? Files.createTempDirectory(this.config.getTempDir(), "git-obj-dir", new FileAttribute[0]) : Paths.get(existing, new String[0]);
            Path infoAlternates = Files.createDirectories(objDir.resolve("info"), new FileAttribute[0]).resolve("alternates");
            try (BufferedWriter writer = Files.newBufferedWriter(infoAlternates, StandardCharsets.UTF_8, StandardOpenOption.CREATE_NEW);){
                writer.append(this.getObjectDir(this.repository, true)).append('\n');
                for (Repository alternate : this.alternates) {
                    writer.append(this.getObjectDir(alternate, true)).append('\n');
                }
                if (this.isQuarantineAlternate()) {
                    writer.append(this.quarantineEnvironment.getQuarantinePath()).append('\n');
                }
                ((Writer)writer).flush();
            }
            return objDir;
        }
        catch (IOException e) {
            if (objDir != null && StringUtils.isBlank((CharSequence)existing)) {
                MoreFiles.deleteQuietly((Path)objDir);
            }
            throw new CommandSetupException(this.i18nService.createKeyedMessage("bitbucket.git.alternate.configuration.failed", new Object[]{this.command}), (Throwable)e);
        }
    }

    private String getObjectDir(Repository repository, boolean absolute) {
        String repoDir = absolute ? this.config.getRepositoryDir(repository).toAbsolutePath().toString() : this.config.getRelativePath(repository, this.repository);
        return repoDir + File.separator + "objects";
    }

    private Path getWorkDir() {
        return this.workDir;
    }

    private boolean isQuarantineAlternate() {
        if (this.quarantineEnvironment == null) {
            return false;
        }
        return this.alternates.contains(this.quarantineEnvironment.getRepository());
    }

    private List<String> mergeArguments(String command, List<String> arguments) {
        List<String> coreBinary = this.config.getCoreBinary(command);
        ArrayList<String> allArguments = new ArrayList<String>(coreBinary.size() + arguments.size());
        allArguments.addAll(coreBinary);
        allArguments.addAll(arguments);
        return allArguments;
    }

    private static class CleanupExitHandler
    implements CommandExitHandler {
        private final CommandExitHandler delegate;
        private final Path toDelete;

        private CleanupExitHandler(CommandExitHandler delegate, Path directory, boolean onlyAlternates) {
            this.delegate = delegate;
            this.toDelete = onlyAlternates ? MoreFiles.resolve((Path)directory, (String)"info", (String[])new String[]{"alternates"}) : directory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCancel(@Nonnull String command, int exitCode, String stdErr, Throwable thrown) {
            try {
                this.delegate.onCancel(command, exitCode, stdErr, thrown);
            }
            finally {
                this.cleanup();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onExit(@Nonnull String command, int exitCode, String stdErr, Throwable thrown) {
            try {
                this.delegate.onExit(command, exitCode, stdErr, thrown);
            }
            finally {
                this.cleanup();
            }
        }

        private void cleanup() {
            MoreFiles.deleteQuietly((Path)this.toDelete);
        }
    }
}

