/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command;

import com.atlassian.bitbucket.scm.CommandInputHandler;
import com.atlassian.bitbucket.scm.CommandSummary;
import com.atlassian.bitbucket.scm.CommandSummaryHandler;
import com.atlassian.bitbucket.scm.Watchdog;
import com.atlassian.stash.internal.scm.git.command.BioStdioHandler;
import com.atlassian.stash.internal.scm.git.command.Completable;
import com.atlassian.util.contentcache.util.PipedStreams;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;

class InputPump
implements Runnable,
AutoCloseable,
Completable {
    private static final byte[] EMPTY_ARRAY = new byte[0];
    final PipedStreams streams;
    private final CommandInputHandler handler;
    private final BioStdioHandler.RemoteWatchdog watchdog;
    private byte[] buffer;
    private volatile boolean closed;

    InputPump(CommandInputHandler handler, BioStdioHandler.RemoteWatchdog watchdog) {
        this.handler = handler;
        this.watchdog = watchdog;
        this.buffer = EMPTY_ARRAY;
        this.streams = new PipedStreams(65536);
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.streams.close();
    }

    @Override
    public void complete(@Nonnull CommandSummary summary) throws IOException {
        try {
            this.close();
            if (this.handler instanceof CommandSummaryHandler) {
                ((CommandSummaryHandler)this.handler).onComplete(summary);
            }
        }
        finally {
            this.handler.complete();
        }
    }

    @Override
    public void run() {
        try {
            this.handler.setWatchdog((Watchdog)this.watchdog);
            this.handler.process(this.streams.output());
        }
        catch (Exception e) {
            this.watchdog.reportError(e);
        }
    }

    boolean onStdinReady(@Nonnull ByteBuffer output) {
        int size = output.remaining();
        if (this.buffer.length < size) {
            this.buffer = new byte[size];
        }
        try {
            InputStream input = this.streams.input();
            if (this.streams.isClosed() && input.available() == 0) {
                boolean bl = false;
                return bl;
            }
            if (input.available() == 0) {
                boolean bl = true;
                return bl;
            }
            int read = input.read(this.buffer, 0, size);
            if (read > -1) {
                output.put(this.buffer);
                output.position(read);
            }
            boolean bl = read != -1;
            return bl;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            output.flip();
        }
    }
}

