/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command;

import com.atlassian.bitbucket.dmz.process.CompositeNioStdioHandler;
import com.atlassian.bitbucket.dmz.process.NioStderrHandler;
import com.atlassian.bitbucket.dmz.process.NioStdinHandler;
import com.atlassian.bitbucket.dmz.process.NioStdioHandler;
import com.atlassian.bitbucket.dmz.process.NioStdoutHandler;
import com.atlassian.bitbucket.dmz.process.StdinHandlerFactory;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.process.NioProcessHelper;
import com.atlassian.bitbucket.internal.process.NioProcessParameters;
import com.atlassian.bitbucket.scm.CommandErrorHandler;
import com.atlassian.bitbucket.scm.CommandExitHandler;
import com.atlassian.bitbucket.scm.CommandInputHandler;
import com.atlassian.bitbucket.scm.CommandOutputHandler;
import com.atlassian.bitbucket.scm.git.command.GitCommand;
import com.atlassian.stash.internal.scm.git.GitCommandCreator;
import com.atlassian.stash.internal.scm.git.command.BioStdioHandler;
import com.atlassian.stash.internal.scm.git.command.CommandHandlerType;
import com.atlassian.stash.internal.scm.git.command.NioGitCommand;
import jakarta.annotation.Nonnull;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public class NioGitCommandCreator
implements GitCommandCreator {
    private final ExecutorService bioExecutor;
    private final I18nService i18nService;
    private final NioProcessHelper processHelper;

    public NioGitCommandCreator(ExecutorService bioExecutor, I18nService i18nService, NioProcessHelper processHelper) {
        this.bioExecutor = bioExecutor;
        this.i18nService = i18nService;
        this.processHelper = processHelper;
    }

    @Override
    @Nonnull
    public <T> GitCommand<T> create(@Nonnull List<String> arguments, @Nonnull Map<String, String> environment, Path workDir, @Nonnull CommandOutputHandler<T> outputHandler, @Nonnull CommandExitHandler exitHandler, CommandInputHandler inputHandler, CommandErrorHandler errorHandler) {
        CommandHandlerType stdoutType = CommandHandlerType.forHandler(outputHandler);
        CommandHandlerType stdinType = CommandHandlerType.forHandler(inputHandler);
        CommandHandlerType stderrType = CommandHandlerType.forHandler(errorHandler);
        if (stdoutType == CommandHandlerType.BIO || stdinType == CommandHandlerType.BIO || stderrType == CommandHandlerType.BIO) {
            return this.createNioCommand(arguments, environment, workDir, new BioStdioHandler<T>(this.bioExecutor, this.i18nService, inputHandler, outputHandler, errorHandler), exitHandler);
        }
        if (stdinType == CommandHandlerType.FACTORY) {
            inputHandler = ((StdinHandlerFactory)inputHandler).createForNio();
        }
        if (outputHandler instanceof NioStdioHandler) {
            if (inputHandler != null || errorHandler != null) {
                throw new IllegalStateException("Separate error and input handlers cannot be used with " + outputHandler.getClass().getName());
            }
            return this.createNioCommand(arguments, environment, workDir, (NioStdioHandler)outputHandler, exitHandler);
        }
        return this.createNioCommand(arguments, environment, workDir, (NioStdioHandler<T>)new CompositeNioStdioHandler((NioStdoutHandler)outputHandler, (NioStdinHandler)inputHandler, (NioStderrHandler)errorHandler), exitHandler);
    }

    private <T> GitCommand<T> createNioCommand(List<String> arguments, Map<String, String> environment, Path workDir, NioStdioHandler<T> outputHandler, CommandExitHandler exitHandler) {
        NioProcessParameters parameters = new NioProcessParameters.Builder(outputHandler, exitHandler).arguments(arguments).environment(environment).workDir(workDir).build();
        return new NioGitCommand(this.processHelper, parameters);
    }
}

