/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command;

import com.atlassian.bitbucket.scm.CommandOutputHandlerSupport;
import com.atlassian.bitbucket.scm.CommandSummary;
import com.atlassian.bitbucket.scm.CommandSummaryHandler;
import com.atlassian.bitbucket.scm.Watchdog;
import com.atlassian.stash.internal.scm.git.command.BioStdioHandler;
import com.atlassian.stash.internal.scm.git.command.Completable;
import com.atlassian.util.contentcache.util.PipedStreams;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;

class OutputPump
implements Runnable,
AutoCloseable,
Completable {
    private static final byte[] EMPTY_ARRAY = new byte[0];
    private final CommandOutputHandlerSupport handler;
    private final PipedStreams streams;
    private final BioStdioHandler.RemoteWatchdog watchdog;
    private byte[] buffer;
    private volatile boolean closed;

    OutputPump(CommandOutputHandlerSupport handler, BioStdioHandler.RemoteWatchdog watchdog) {
        this.handler = handler;
        this.watchdog = watchdog;
        this.buffer = EMPTY_ARRAY;
        this.streams = new PipedStreams(65536);
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.streams.close();
    }

    @Override
    public void complete(@Nonnull CommandSummary summary) throws IOException {
        try {
            this.close();
            if (this.handler instanceof CommandSummaryHandler) {
                ((CommandSummaryHandler)this.handler).onComplete(summary);
            }
        }
        finally {
            this.handler.complete();
        }
    }

    @Override
    public void run() {
        try {
            this.handler.setWatchdog((Watchdog)this.watchdog);
            this.handler.process(this.streams.input());
        }
        catch (Throwable t) {
            this.watchdog.reportError(t);
        }
    }

    void pump(ByteBuffer output) {
        if (this.closed) {
            return;
        }
        if (output.hasRemaining()) {
            try {
                this.copyToPipe(output);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private void copyToPipe(ByteBuffer output) throws IOException {
        int size = output.remaining();
        if (this.buffer.length < size) {
            this.buffer = new byte[size];
        }
        output.get(this.buffer, 0, size);
        try {
            this.streams.output().write(this.buffer, 0, size);
        }
        catch (IOException e) {
            if (this.watchdog.isCanceled() && this.streams.isClosed()) {
                this.closed = true;
            }
            throw e;
        }
    }
}

