/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command;

import com.atlassian.bitbucket.scm.AsyncCommand;
import com.atlassian.bitbucket.scm.Command;
import com.atlassian.bitbucket.scm.SimpleCommand;
import com.atlassian.bitbucket.scm.git.command.GitCommand;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class SimpleGitCommand<T>
extends SimpleCommand<T>
implements GitCommand<T> {
    protected final ExecutorService executorService;
    protected OptionalLong executionTimeout;
    protected OptionalLong idleTimeout;
    private volatile boolean startable;

    protected SimpleGitCommand(@Nonnull ExecutorService executorService) {
        this.executorService = Objects.requireNonNull(executorService, "executorService");
        this.executionTimeout = OptionalLong.empty();
        this.idleTimeout = OptionalLong.empty();
        this.startable = true;
    }

    @Nonnull
    public AsyncCommand<T> asynchronous() {
        return this;
    }

    @Nonnull
    public Command<T> synchronous() {
        this.startable = false;
        return this;
    }

    public void setExecutionTimeout(long timeoutInSecs) {
        this.executionTimeout = OptionalLong.of(timeoutInSecs);
    }

    public void setIdleTimeout(long timeoutInSecs) {
        this.idleTimeout = OptionalLong.of(timeoutInSecs);
    }

    @Nonnull
    public Future<T> start() {
        if (this.startable) {
            return this.executorService.submit(this);
        }
        throw new IllegalStateException("This AsyncCommand has been converted to synchronous. It may no longer be started asynchronously.");
    }

    protected <V> V configureAndCall(Command<V> command) {
        this.executionTimeout.ifPresent(arg_0 -> command.setExecutionTimeout(arg_0));
        this.idleTimeout.ifPresent(arg_0 -> command.setIdleTimeout(arg_0));
        return (V)command.call();
    }

    protected <V> V get(Future<V> future, long defaultTimeout) throws ExecutionException, InterruptedException, TimeoutException {
        return future.get(this.executionTimeout.orElse(defaultTimeout), TimeUnit.SECONDS);
    }
}

