/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command;

import com.atlassian.bitbucket.scm.AsyncCommand;
import com.atlassian.bitbucket.scm.Command;
import com.atlassian.bitbucket.scm.git.command.GitCommand;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;

public class TransformedGitCommand<I, O>
implements GitCommand<O> {
    private final GitCommand<I> delegate;
    private final Function<I, O> transform;

    public TransformedGitCommand(@Nonnull GitCommand<I> delegate, @Nonnull Function<I, O> transform) {
        this.delegate = Objects.requireNonNull(delegate, "delegate");
        this.transform = Objects.requireNonNull(transform, "transform");
    }

    @Nonnull
    public AsyncCommand<O> asynchronous() {
        this.delegate.asynchronous();
        return this;
    }

    public O call() {
        return this.transform.apply(this.delegate.call());
    }

    public void setExecutionTimeout(long timeoutInSecs) {
        this.delegate.setExecutionTimeout(timeoutInSecs);
    }

    public void setIdleTimeout(long timeoutInSecs) {
        this.delegate.setIdleTimeout(timeoutInSecs);
    }

    @Nonnull
    public Future<O> start() {
        Future future = this.delegate.start();
        return new TransformedFuture(future);
    }

    @Nonnull
    public Command<O> synchronous() {
        this.delegate.synchronous();
        return this;
    }

    private class TransformedFuture
    implements Future<O> {
        private final Future<I> delegate;

        public TransformedFuture(Future<I> delegate) {
            this.delegate = Objects.requireNonNull(delegate, "delegate");
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.delegate.cancel(mayInterruptIfRunning);
        }

        @Override
        public O get() throws InterruptedException, ExecutionException {
            return TransformedGitCommand.this.transform.apply(this.delegate.get());
        }

        @Override
        public O get(long timeout, @Nonnull TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
            return TransformedGitCommand.this.transform.apply(this.delegate.get(timeout, Objects.requireNonNull(unit, "unit")));
        }

        @Override
        public boolean isCancelled() {
            return this.delegate.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.delegate.isDone();
        }
    }
}

