/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command;

import com.atlassian.bitbucket.dmz.process.NioStdoutHandler;
import com.atlassian.bitbucket.io.ContentDetectionUtils;
import com.atlassian.bitbucket.io.TypeAwareOutputSupplier;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;

public class TypeDetectingStdoutHandler
implements NioStdoutHandler<Void> {
    private static final int BUFFER_SIZE = 8192;
    private final int bufferSize;
    private final TypeAwareOutputSupplier outputSupplier;
    private final String path;
    private WritableByteChannel channel;

    public TypeDetectingStdoutHandler(TypeAwareOutputSupplier outputSupplier, String path) {
        this(outputSupplier, path, 8192);
    }

    public TypeDetectingStdoutHandler(TypeAwareOutputSupplier outputSupplier, String path, int bufferSize) {
        this.bufferSize = Math.max(bufferSize, 8192);
        this.outputSupplier = outputSupplier;
        this.path = path;
    }

    public Void getOutput() {
        return null;
    }

    public void onExit(int exitCode) {
        WritableByteChannel channel = this.channel;
        if (channel != null && channel.isOpen()) {
            try {
                channel.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to close output channel", e);
            }
        }
    }

    public void onStdout(@Nonnull ByteBuffer buffer, boolean closed) {
        int remaining = buffer.remaining();
        if (this.channel == null) {
            if (closed && remaining == 0) {
                return;
            }
            if (closed || remaining >= this.bufferSize) {
                String type = ContentDetectionUtils.detectContentType((ByteBuffer)buffer, (String)this.path);
                if (type == null) {
                    type = ContentDetectionUtils.isBinary((ByteBuffer)buffer) ? "application/octet-stream" : "text/plain";
                }
                try {
                    this.channel = Channels.newChannel(this.outputSupplier.getStream(type));
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to open output stream", e);
                }
            } else {
                return;
            }
        }
        try {
            if (remaining > 0) {
                this.channel.write(buffer);
            }
            if (closed) {
                this.channel.close();
                this.channel = null;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to copy output", e);
        }
    }
}

