/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command.add;

import com.atlassian.bitbucket.scm.git.command.GitCommand;
import com.atlassian.bitbucket.scm.git.command.add.GitAddBuilder;
import com.atlassian.stash.internal.scm.git.GitScmConfig;
import com.atlassian.stash.internal.scm.git.command.AbstractGitCommandBuilder;
import com.atlassian.stash.internal.scm.git.command.GitFreeFormCommandBuilder;
import jakarta.annotation.Nonnull;
import java.util.LinkedHashSet;
import java.util.Set;

public class DefaultGitAddBuilder
extends AbstractGitCommandBuilder<GitAddBuilder>
implements GitAddBuilder {
    private final GitScmConfig config;
    private final Set<String> paths;
    private boolean all;
    private boolean force;
    private boolean sparse;

    public DefaultGitAddBuilder(GitFreeFormCommandBuilder builder, GitScmConfig config) {
        super((GitFreeFormCommandBuilder)builder.command("add"));
        this.config = config;
        this.paths = new LinkedHashSet<String>();
        this.sparse = true;
    }

    @Nonnull
    public GitAddBuilder all(boolean value) {
        this.all = value;
        return this.self();
    }

    @Nonnull
    public GitCommand<Void> build() {
        return this.buildWithLoggingHandler();
    }

    @Nonnull
    public GitAddBuilder force(boolean value) {
        this.force = value;
        return this.self();
    }

    @Nonnull
    public GitAddBuilder path(String value) {
        DefaultGitAddBuilder.addIfNotBlank(this.paths, value);
        return this.self();
    }

    @Nonnull
    public GitAddBuilder paths(Iterable<String> values) {
        DefaultGitAddBuilder.addIfNotBlank(this.paths, values);
        return this.self();
    }

    @Nonnull
    public GitAddBuilder paths(String value, String ... values) {
        DefaultGitAddBuilder.addIfNotBlank(this.paths, value, values);
        return this.self();
    }

    @Nonnull
    public GitAddBuilder sparse(boolean value) {
        this.sparse = value;
        return this.self();
    }

    @Override
    protected void applyArguments() {
        if (this.all) {
            this.builder.argument("-A");
        }
        if (this.force) {
            this.builder.argument("--force");
        }
        if (this.sparse) {
            this.builder.argument("--sparse");
        }
        this.builder.argument("--");
        this.paths.forEach(arg_0 -> ((GitFreeFormCommandBuilder)this.builder).rawArgument(arg_0));
    }

    @Override
    @Nonnull
    protected GitAddBuilder self() {
        return this;
    }
}

