/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command.archive;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.CommandExitHandler;
import com.atlassian.bitbucket.scm.CommandOutputHandler;
import com.atlassian.bitbucket.scm.git.command.GitCommand;
import com.atlassian.bitbucket.scm.git.command.archive.GitArchiveBuilder;
import com.atlassian.bitbucket.scm.git.command.archive.GitArchiveFormat;
import com.atlassian.stash.internal.scm.git.command.AbstractGitCommandBuilder;
import com.atlassian.stash.internal.scm.git.command.GitFreeFormCommandBuilder;
import com.atlassian.stash.internal.scm.git.command.archive.ArchiveCommandExitHandler;
import jakarta.annotation.Nonnull;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class DefaultGitArchiveBuilder
extends AbstractGitCommandBuilder<GitArchiveBuilder>
implements GitArchiveBuilder {
    private final I18nService i18nService;
    private final Set<String> paths;
    private final Repository repository;
    private GitArchiveFormat format;
    private String prefix;
    private String rev;
    private boolean useDefaultExitHandler;

    public DefaultGitArchiveBuilder(GitFreeFormCommandBuilder builder, I18nService i18nService, Repository repository) {
        super((GitFreeFormCommandBuilder)builder.command("archive"));
        this.i18nService = i18nService;
        this.repository = repository;
        this.paths = new LinkedHashSet<String>();
        this.rev = "HEAD";
        this.useDefaultExitHandler = true;
    }

    @Override
    @Nonnull
    public <T> GitCommand<T> build(@Nonnull CommandOutputHandler<T> outputHandler) {
        if (this.useDefaultExitHandler) {
            this.builder.exitHandler((CommandExitHandler)new ArchiveCommandExitHandler(this.i18nService, this.repository, this.rev));
        }
        return super.build(outputHandler);
    }

    @Nonnull
    public GitArchiveBuilder clearPaths() {
        this.paths.clear();
        return this.self();
    }

    @Override
    @Nonnull
    public GitArchiveBuilder defaultExitHandler() {
        this.useDefaultExitHandler = true;
        return this.self();
    }

    @Override
    @Nonnull
    public GitArchiveBuilder exitHandler(@Nonnull CommandExitHandler value) {
        super.exitHandler(value);
        this.useDefaultExitHandler = false;
        return this.self();
    }

    @Nonnull
    public GitArchiveBuilder format(GitArchiveFormat value) {
        this.format = value;
        return this.self();
    }

    @Nonnull
    public GitArchiveBuilder path(String value) {
        DefaultGitArchiveBuilder.addIfNotBlank(this.paths, value);
        return this.self();
    }

    @Nonnull
    public GitArchiveBuilder paths(String value, String ... values) {
        DefaultGitArchiveBuilder.addIfNotBlank(this.paths, value, values);
        return this.self();
    }

    @Nonnull
    public GitArchiveBuilder paths(Iterable<String> values) {
        if (values != null) {
            DefaultGitArchiveBuilder.addIfNotBlank(this.paths, values);
        }
        return this.self();
    }

    @Nonnull
    public GitArchiveBuilder prefix(String value) {
        this.prefix = StringUtils.trimToNull((String)value);
        return this.self();
    }

    @Nonnull
    public GitArchiveBuilder rev(@Nonnull String value) {
        this.rev = Objects.requireNonNull(value, "rev");
        return this.self();
    }

    @Override
    protected void applyArguments() {
        if (this.format != null) {
            this.builder.argument("--format=" + this.format.getExtension());
        }
        if (this.prefix != null) {
            this.builder.argument("--prefix=" + this.prefix);
        }
        ((GitFreeFormCommandBuilder)this.builder.argument("--")).argument(this.rev);
        this.paths.forEach(arg_0 -> ((GitFreeFormCommandBuilder)this.builder).rawArgument(arg_0));
    }

    @Override
    @Nonnull
    protected GitArchiveBuilder self() {
        return this;
    }
}

