/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command.blame;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.CommandExitHandler;
import com.atlassian.bitbucket.scm.CommandOutputHandler;
import com.atlassian.bitbucket.scm.git.command.GitCommand;
import com.atlassian.bitbucket.scm.git.command.GitCommandExitHandler;
import com.atlassian.bitbucket.scm.git.command.blame.GitBlameBuilder;
import com.atlassian.bitbucket.util.PageStartOutOfBoundsException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlameCommandExitHandler
extends GitCommandExitHandler {
    public static final Pattern FILE_LENGTH_PATTERN = Pattern.compile("fatal: file .+ has only (\\d+) lines?");
    protected static final Logger log = LoggerFactory.getLogger(BlameCommandExitHandler.class);
    private final GitBlameBuilder builder;
    private final CommandOutputHandler<?> outputHandler;
    private final int start;

    public BlameCommandExitHandler(I18nService i18nService, Repository repository, GitBlameBuilder builder, CommandOutputHandler outputHandler, int start) {
        super(i18nService, repository);
        this.builder = builder;
        this.outputHandler = outputHandler;
        this.start = start;
    }

    protected void onError(String command, int exitCode, String stdErr, Throwable throwable) {
        if (StringUtils.isNotBlank((CharSequence)stdErr)) {
            log.debug("{}: Processing error output for possible retry: ({}) {}", new Object[]{command, exitCode, stdErr});
            Matcher matcher = FILE_LENGTH_PATTERN.matcher(stdErr);
            if (matcher.matches()) {
                log.debug("{}: [{}] looks to be paging-related. Attempting to calculate an acceptable line range", (Object)command, (Object)stdErr);
                int totalLines = Integer.parseInt(matcher.group(1));
                if (this.start <= totalLines) {
                    log.debug("{}: Trying again with new range [{},{}]", new Object[]{command, this.start, totalLines});
                    this.builder.range(this.start, totalLines, false);
                } else {
                    if (this.start > 1) {
                        log.debug("{}: Requested starting index {} cannot be satisfied; only {} lines are available", new Object[]{command, this.start, totalLines});
                        throw new PageStartOutOfBoundsException(this.i18nService.createKeyedMessage("bitbucket.scm.git.pagerequest.outofbounds", new Object[]{this.start}));
                    }
                    log.debug("{}: File appears to be empty; retrying without any range", (Object)command);
                    this.builder.clearRange();
                }
                this.builder.exitHandler((CommandExitHandler)new GitCommandExitHandler(this.i18nService, this.repository));
                GitCommand blame = this.builder.build(this.outputHandler);
                log.debug("{} failed, but will be retried as {}", (Object)command, (Object)blame.toString());
                blame.call();
                return;
            }
        }
        super.onError(command, exitCode, stdErr, throwable);
    }
}

