/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command.blame;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.CommandExitHandler;
import com.atlassian.bitbucket.scm.CommandOutputHandler;
import com.atlassian.bitbucket.scm.git.command.GitCommand;
import com.atlassian.bitbucket.scm.git.command.blame.GitBlameBuilder;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.stash.internal.scm.git.command.AbstractGitCommandBuilder;
import com.atlassian.stash.internal.scm.git.command.GitFreeFormCommandBuilder;
import com.atlassian.stash.internal.scm.git.command.blame.BlameCommandExitHandler;
import com.atlassian.stash.internal.scm.git.command.blame.BlameFormat;
import jakarta.annotation.Nonnull;

public class DefaultGitBlameBuilder
extends AbstractGitCommandBuilder<GitBlameBuilder>
implements GitBlameBuilder {
    private final BlameFormat format;
    private final I18nService i18nService;
    private final Repository repository;
    private int end;
    private boolean endIsOffset;
    private String file;
    private String rev;
    private int start;
    private boolean useDefaultExitHandler;

    public DefaultGitBlameBuilder(GitFreeFormCommandBuilder builder, I18nService i18nService, Repository repository, BlameFormat format) {
        super(builder);
        this.format = format;
        this.i18nService = i18nService;
        this.repository = repository;
        this.useDefaultExitHandler = true;
    }

    @Override
    @Nonnull
    public <T> GitCommand<T> build(@Nonnull CommandOutputHandler<T> outputHandler) {
        if (this.useDefaultExitHandler) {
            this.builder.exitHandler((CommandExitHandler)new BlameCommandExitHandler(this.i18nService, this.repository, this, outputHandler, this.start));
        }
        return super.build(outputHandler);
    }

    @Nonnull
    public GitBlameBuilder clearRange() {
        this.start = 0;
        this.end = 0;
        this.endIsOffset = false;
        return this.self();
    }

    @Override
    @Nonnull
    public GitBlameBuilder defaultExitHandler() {
        this.useDefaultExitHandler = true;
        return this.self();
    }

    @Override
    @Nonnull
    public GitBlameBuilder exitHandler(@Nonnull CommandExitHandler value) {
        super.exitHandler(value);
        this.useDefaultExitHandler = false;
        return this.self();
    }

    @Nonnull
    public DefaultGitBlameBuilder file(String value) {
        this.file = value;
        return this.self();
    }

    @Nonnull
    public DefaultGitBlameBuilder range(@Nonnull PageRequest value) {
        this.end = this.format.toOffset(value.getLimit());
        this.endIsOffset = true;
        this.start = this.format.toLine(value.getStart());
        return this.self();
    }

    @Nonnull
    public GitBlameBuilder range(int start, int end, boolean endIsOffset) {
        this.end = end;
        this.endIsOffset = endIsOffset;
        this.start = start;
        return this.self();
    }

    @Nonnull
    public DefaultGitBlameBuilder rev(String value) {
        this.rev = value;
        return this.self();
    }

    @Override
    protected void applyArguments() {
        this.builder.argument(this.format.getFlag());
        if (this.start > 0 && this.end > 0) {
            StringBuilder rangeBuilder = new StringBuilder().append(this.start).append(",");
            if (this.endIsOffset) {
                rangeBuilder.append("+");
            }
            rangeBuilder.append(this.end);
            ((GitFreeFormCommandBuilder)this.builder.argument("-L")).argument(rangeBuilder.toString());
        }
        if (this.rev != null) {
            this.builder.commitish(this.rev);
        }
        if (this.file != null) {
            ((GitFreeFormCommandBuilder)this.builder.argument("--")).rawArgument(this.file);
        }
    }

    @Override
    @Nonnull
    protected DefaultGitBlameBuilder self() {
        return this;
    }
}

