/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command.branch;

import com.atlassian.bitbucket.InvalidNameException;
import com.atlassian.bitbucket.NoSuchObjectException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.ConflictingRefNameException;
import com.atlassian.bitbucket.repository.DuplicateRefException;
import com.atlassian.bitbucket.repository.InvalidRefNameException;
import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.RefType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.SimpleMinimalRef;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.bitbucket.scm.git.GitRefPattern;
import com.atlassian.bitbucket.scm.git.command.GitCommandExitHandler;
import jakarta.annotation.Nonnull;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CreateBranchCommandExitHandler
extends GitCommandExitHandler {
    public static final Pattern PATTERN_REF_FILE_DIR_CONFLICT = Pattern.compile("error: there are still refs under '([^']+)'");
    public static final Pattern PATTERN_REF_DIR_FILE_CONFLICT = Pattern.compile("error: unable to resolve reference ([^:]+): Not a directory");
    public static final Pattern PATTERN_PACKED_REF_CONFLICT = Pattern.compile("(?:error|fatal): (?:cannot lock ref '[^']+': )?'([^']+)' exists; cannot create '([^']+)'");
    private static final Pattern PATTERN_BRANCH_ALREADY_EXISTS = Pattern.compile("fatal: [Aa] branch named '([^']+)' already exists\\.?");
    private static final Pattern PATTERN_BRANCH_POINT_NOT_FOUND = Pattern.compile("fatal: [Nn]ot a valid object name: '([^']+)'\\.?");
    private static final Pattern PATTERN_INVALID_BRANCH_NAME = Pattern.compile("fatal: '([^']+)' is not a valid branch name\\.?");
    private static final Pattern PATTERN_INVALID_BRANCH_POINT = Pattern.compile("fatal: [Nn]ot a valid branch point: '([^']+)'\\.?");

    public CreateBranchCommandExitHandler(@Nonnull I18nService i18nService, @Nonnull Repository repository) {
        super(i18nService, repository);
    }

    protected void evaluateStdErr(String stdErr, String command) {
        String[] lines;
        this.checkUsage(stdErr, command);
        for (String line : lines = stdErr.split("\\n")) {
            Matcher matcher = PATTERN_INVALID_BRANCH_NAME.matcher(line);
            if (matcher.matches()) {
                throw this.newInvalidBranchName(matcher.group(1));
            }
            matcher = PATTERN_BRANCH_ALREADY_EXISTS.matcher(line);
            if (matcher.matches()) {
                throw this.newDuplicateBranchName(matcher.group(1));
            }
            matcher = PATTERN_BRANCH_POINT_NOT_FOUND.matcher(line);
            if (matcher.matches()) {
                throw this.newNoSuchStartingPoint(matcher.group(1));
            }
            matcher = PATTERN_INVALID_BRANCH_POINT.matcher(line);
            if (matcher.matches()) {
                throw this.newInvalidBranchPoint(matcher.group(1));
            }
            matcher = PATTERN_REF_FILE_DIR_CONFLICT.matcher(line);
            if (matcher.matches()) {
                throw this.newConflictingBranchName(CreateBranchCommandExitHandler.toMinimalRef(matcher.group(1)));
            }
            matcher = PATTERN_REF_DIR_FILE_CONFLICT.matcher(line);
            if (matcher.matches()) {
                throw this.newConflictingBranchName(CreateBranchCommandExitHandler.toMinimalRef(matcher.group(1)));
            }
            matcher = PATTERN_PACKED_REF_CONFLICT.matcher(line);
            if (!matcher.matches()) continue;
            throw this.newConflictingBranchName(CreateBranchCommandExitHandler.toMinimalRef(matcher.group(2)), CreateBranchCommandExitHandler.toMinimalRef(matcher.group(1)));
        }
        super.evaluateStdErr(stdErr, command);
    }

    private InvalidRefNameException newInvalidBranchName(String newBranchName) {
        throw new InvalidRefNameException(this.i18nService.createKeyedMessage("bitbucket.service.repository.branchnameinvalid", new Object[]{newBranchName}), newBranchName);
    }

    private DuplicateRefException newDuplicateBranchName(String newBranchName) {
        throw new DuplicateRefException(this.i18nService.createKeyedMessage("bitbucket.service.repository.branch.duplicate", new Object[]{newBranchName, this.repository.getName()}), newBranchName);
    }

    private NoSuchObjectException newNoSuchStartingPoint(String startingPoint) {
        throw new NoSuchObjectException(this.i18nService.createKeyedMessage("bitbucket.service.repository.branch.doesnotexist", new Object[]{startingPoint}), startingPoint);
    }

    private InvalidNameException newInvalidBranchPoint(String startingPoint) {
        throw new InvalidNameException(this.i18nService.createKeyedMessage("bitbucket.service.repository.branch.pointinvalid", new Object[]{startingPoint}));
    }

    private ConflictingRefNameException newConflictingBranchName(MinimalRef newBranch) {
        throw new ConflictingRefNameException(this.i18nService.createKeyedMessage("bitbucket.git.branch.create.looserefconflict", new Object[]{newBranch.getDisplayId()}), newBranch);
    }

    private ConflictingRefNameException newConflictingBranchName(MinimalRef newBranch, MinimalRef existingBranch) {
        throw new ConflictingRefNameException(this.i18nService.createKeyedMessage("bitbucket.git.branch.create.packedrefconflict", new Object[]{newBranch.getDisplayId(), existingBranch.getDisplayId()}), newBranch);
    }

    private static MinimalRef toMinimalRef(String id) {
        return ((SimpleMinimalRef.Builder)((SimpleMinimalRef.Builder)new SimpleMinimalRef.Builder().displayId(GitRefPattern.HEADS.unqualify(id))).id(id)).type((RefType)StandardRefType.BRANCH).build();
    }
}

