/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command.branch;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.Command;
import com.atlassian.bitbucket.scm.CommandExitHandler;
import com.atlassian.bitbucket.scm.CommandOutputHandler;
import com.atlassian.bitbucket.scm.git.command.GitCommand;
import com.atlassian.bitbucket.scm.git.command.branch.GitBranchCreateBuilder;
import com.atlassian.stash.internal.scm.git.command.AbstractGitCommandBuilder;
import com.atlassian.stash.internal.scm.git.command.GitFreeFormCommandBuilder;
import com.atlassian.stash.internal.scm.git.command.branch.CreateBranchCommandExitHandler;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class DefaultGitBranchCreateBuilder
extends AbstractGitCommandBuilder<GitBranchCreateBuilder>
implements GitBranchCreateBuilder {
    private final String name;
    private final I18nService i18nService;
    private final Repository repository;
    private boolean force;
    private boolean reflog;
    private String startPoint;
    private boolean track;
    private boolean useDefaultExitHandler;

    public DefaultGitBranchCreateBuilder(GitFreeFormCommandBuilder builder, I18nService i18nService, Repository repository, String name) {
        super(builder);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)name), (Object)"A branch name is required");
        this.name = name;
        this.i18nService = i18nService;
        this.repository = repository;
        this.useDefaultExitHandler = true;
    }

    @Nonnull
    public Command<Void> build() {
        if (this.useDefaultExitHandler) {
            this.builder.exitHandler((CommandExitHandler)new CreateBranchCommandExitHandler(this.i18nService, this.repository));
        }
        return this.buildWithLoggingHandler();
    }

    @Override
    @Nonnull
    public <T> GitCommand<T> build(@Nonnull CommandOutputHandler<T> outputHandler) {
        if (this.useDefaultExitHandler) {
            this.builder.exitHandler((CommandExitHandler)new CreateBranchCommandExitHandler(this.i18nService, this.repository));
        }
        return super.build(outputHandler);
    }

    @Override
    @Nonnull
    public GitBranchCreateBuilder defaultExitHandler() {
        this.useDefaultExitHandler = true;
        return this.self();
    }

    @Override
    @Nonnull
    public GitBranchCreateBuilder exitHandler(@Nonnull CommandExitHandler value) {
        super.exitHandler(value);
        this.useDefaultExitHandler = false;
        return this.self();
    }

    @Nonnull
    public GitBranchCreateBuilder force(boolean value) {
        this.force = value;
        return this.self();
    }

    @Nonnull
    public GitBranchCreateBuilder reflog(boolean value) {
        this.reflog = value;
        return this.self();
    }

    @Nonnull
    public GitBranchCreateBuilder startPoint(String value) {
        this.startPoint = value;
        return this.self();
    }

    @Nonnull
    public GitBranchCreateBuilder track(boolean value) {
        this.track = value;
        return this.self();
    }

    @Override
    protected void applyArguments() {
        if (this.force) {
            this.builder.argument("--force");
        }
        if (this.reflog) {
            this.builder.argument("--create-reflog");
        }
        if (this.track) {
            this.builder.argument("--track");
        } else {
            this.builder.argument("--no-track");
        }
        this.builder.argument("--");
        this.builder.argument(this.name);
        if (StringUtils.isNotBlank((CharSequence)this.startPoint)) {
            this.builder.argument(this.startPoint);
        }
    }

    @Override
    @Nonnull
    protected GitBranchCreateBuilder self() {
        return this;
    }
}

