/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command.branch;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.CommandExitHandler;
import com.atlassian.bitbucket.scm.git.command.GitCommand;
import com.atlassian.bitbucket.scm.git.command.branch.GitBranchDeleteBuilder;
import com.atlassian.stash.internal.scm.git.command.AbstractGitCommandBuilder;
import com.atlassian.stash.internal.scm.git.command.GitFreeFormCommandBuilder;
import com.atlassian.stash.internal.scm.git.command.branch.DeleteBranchCommandExitHandler;
import jakarta.annotation.Nonnull;

public class DefaultGitBranchDeleteBuilder
extends AbstractGitCommandBuilder<GitBranchDeleteBuilder>
implements GitBranchDeleteBuilder {
    private final String name;
    private final I18nService i18nService;
    private final Repository repository;
    private boolean force;
    private boolean useDefaultExitHandler;

    public DefaultGitBranchDeleteBuilder(GitFreeFormCommandBuilder builder, I18nService i18nService, Repository repository, String name) {
        super(builder);
        this.i18nService = i18nService;
        this.repository = repository;
        this.name = this.checkNotBlank(name, "name");
        this.useDefaultExitHandler = true;
    }

    @Nonnull
    public GitCommand<Void> build() {
        if (this.useDefaultExitHandler) {
            this.builder.exitHandler((CommandExitHandler)new DeleteBranchCommandExitHandler(this.i18nService, this.repository));
        }
        return this.buildWithLoggingHandler();
    }

    @Override
    @Nonnull
    public GitBranchDeleteBuilder defaultExitHandler() {
        this.useDefaultExitHandler = true;
        return this.self();
    }

    @Override
    @Nonnull
    public GitBranchDeleteBuilder exitHandler(@Nonnull CommandExitHandler value) {
        super.exitHandler(value);
        this.useDefaultExitHandler = false;
        return this.self();
    }

    @Nonnull
    public GitBranchDeleteBuilder force(boolean value) {
        this.force = value;
        return this.self();
    }

    @Override
    protected void applyArguments() {
        if (this.force) {
            this.builder.argument("-D");
        } else {
            this.builder.argument("-d");
        }
        this.builder.argument(this.name);
    }

    @Override
    @Nonnull
    protected GitBranchDeleteBuilder self() {
        return this;
    }
}

