/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command.branch;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.NoSuchBranchException;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.git.command.GitCommandExitHandler;
import com.atlassian.bitbucket.scm.git.command.branch.GitBranchNotMergedException;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DeleteBranchCommandExitHandler
extends GitCommandExitHandler {
    public static final Pattern PATTERN_BRANCH_NOT_FOUND = Pattern.compile("error: branch '(.+)' not found(\\.)?");
    public static final Pattern PATTERN_BRANCH_NOT_MERGED = Pattern.compile("error: [Tt]he branch '(.+)' is not fully merged(\\.)?$", 8);

    public DeleteBranchCommandExitHandler(@Nonnull I18nService i18nService, @Nullable Repository repository) {
        super(i18nService, repository);
    }

    protected void evaluateStdErr(String stdErr, String command) {
        String cleanedStdErr = ADVICE_PATTERN.matcher(stdErr).replaceAll("");
        Matcher matcher = PATTERN_BRANCH_NOT_FOUND.matcher(cleanedStdErr);
        if (matcher.matches()) {
            this.throwNoSuchBranchException(matcher.group(1));
        }
        if ((matcher = PATTERN_BRANCH_NOT_MERGED.matcher(cleanedStdErr)).find()) {
            throw new GitBranchNotMergedException(this.i18nService.createKeyedMessage("bitbucket.service.repository.branchnotmerged", new Object[]{matcher.group(1)}));
        }
        super.evaluateStdErr(cleanedStdErr, command);
    }

    private void throwNoSuchBranchException(String branch) {
        if (this.repository == null) {
            throw new NoSuchBranchException(this.i18nService.createKeyedMessage("bitbucket.service.repository.branchnotfound.generic", new Object[]{branch}), branch);
        }
        throw new NoSuchBranchException(this.i18nService.createKeyedMessage("bitbucket.service.repository.branchnotfound", new Object[]{branch, this.repository.getName()}), branch);
    }
}

