/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command.catfile;

import com.atlassian.stash.internal.scm.git.command.catfile.BatchHeader;
import com.atlassian.stash.internal.scm.git.command.catfile.BatchedCatFileStdioHandlerSupport;
import com.atlassian.stash.internal.scm.git.io.ByteSegmentScanner;
import jakarta.annotation.Nonnull;
import java.nio.ByteBuffer;

public abstract class AbstractBatchCatFileStdioHandler<T>
extends BatchedCatFileStdioHandlerSupport<T> {
    private final ByteSegmentScanner segmentScanner = new ByteSegmentScanner();
    private long remainingSize;
    private BatchState state = BatchState.HEADER;

    protected AbstractBatchCatFileStdioHandler() {
    }

    public void onStdout(@Nonnull ByteBuffer buffer, boolean closed) {
        while (buffer.hasRemaining()) {
            if (this.state == BatchState.HEADER) {
                ByteBuffer headerBytes = this.segmentScanner.scan(buffer, closed);
                if (headerBytes == null) {
                    return;
                }
                if (!headerBytes.hasRemaining()) {
                    throw new IllegalStateException("Unexpected empty segment parsing output");
                }
                BatchHeader header = BatchHeader.parse((ByteBuffer)headerBytes);
                if (header.isMissing()) {
                    this.onMissing(header.getObjectId());
                    this.pumpIfRunning();
                    continue;
                }
                this.state = this.onObject(header) ? BatchState.CONTENT : BatchState.FLUSH;
                this.remainingSize = header.getSize();
                if (!buffer.hasRemaining()) {
                    return;
                }
            }
            if (this.state == BatchState.CONTENT && this.handleContent(buffer)) {
                return;
            }
            if (this.state == BatchState.FLUSH && this.flushContent(buffer)) {
                return;
            }
            if (this.state != BatchState.TRAILER || !buffer.hasRemaining()) continue;
            if (buffer.get() == 10) {
                this.state = BatchState.HEADER;
                this.pumpIfRunning();
                continue;
            }
            throw new IllegalStateException("Expected a trailing LF");
        }
    }

    protected abstract boolean onContent(@Nonnull ByteBuffer var1, boolean var2);

    protected abstract void onMissing(@Nonnull String var1);

    protected abstract boolean onObject(@Nonnull BatchHeader var1);

    private boolean flushContent(@Nonnull ByteBuffer buffer) {
        int remaining = buffer.remaining();
        if ((long)remaining < this.remainingSize) {
            this.remainingSize -= (long)remaining;
            buffer.position(buffer.position() + remaining);
            return true;
        }
        buffer.position(buffer.position() + (int)this.remainingSize);
        this.remainingSize = 0L;
        this.state = BatchState.TRAILER;
        return false;
    }

    private boolean handleContent(@Nonnull ByteBuffer buffer) {
        boolean closed;
        ByteBuffer content = buffer.slice();
        if ((long)content.remaining() > this.remainingSize) {
            content.limit((int)this.remainingSize);
        }
        boolean bl = closed = (long)content.limit() == this.remainingSize;
        if (this.onContent(content, closed) && !closed) {
            int used = content.position();
            if (used > 0) {
                buffer.position(buffer.position() + used);
                this.remainingSize -= (long)used;
                if (this.remainingSize == 0L) {
                    this.state = BatchState.TRAILER;
                    return false;
                }
            }
            return true;
        }
        this.state = BatchState.FLUSH;
        return false;
    }

    private static enum BatchState {
        CONTENT,
        FLUSH,
        HEADER,
        TRAILER;

    }
}

