/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command.catfile;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.CommandExitHandler;
import com.atlassian.bitbucket.scm.CommandInputHandler;
import com.atlassian.bitbucket.scm.CommandOutputHandler;
import com.atlassian.bitbucket.scm.git.command.GitCommand;
import com.atlassian.bitbucket.scm.git.command.catfile.GitCatFileBatchBuilder;
import com.atlassian.stash.internal.scm.git.command.AbstractGitCommandBuilder;
import com.atlassian.stash.internal.scm.git.command.GitFreeFormCommandBuilder;
import com.atlassian.stash.internal.scm.git.command.catfile.CatFileBatchCommandExitHandler;
import com.atlassian.stash.internal.scm.git.command.catfile.CatFileFormat;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class DefaultGitCatFileBatchBuilder
extends AbstractGitCommandBuilder<GitCatFileBatchBuilder>
implements GitCatFileBatchBuilder {
    private final CatFileFormat format;
    private final CommandInputHandler inputHandler;
    private final I18nService i18nService;
    private final Repository repository;
    private boolean useDefaultExitHandler;

    protected DefaultGitCatFileBatchBuilder(GitFreeFormCommandBuilder builder, I18nService i18nService, Repository repository, CatFileFormat format, CommandInputHandler inputHandler) {
        super(builder);
        this.format = Objects.requireNonNull(format, "format");
        this.inputHandler = Objects.requireNonNull(inputHandler, "inputHandler");
        this.i18nService = i18nService;
        this.repository = repository;
        this.useDefaultExitHandler = true;
    }

    @Override
    @Nonnull
    public <T> GitCommand<T> build(@Nonnull CommandOutputHandler<T> outputHandler) {
        if (this.useDefaultExitHandler) {
            this.builder.exitHandler((CommandExitHandler)new CatFileBatchCommandExitHandler(this.i18nService, this.repository));
        }
        return super.build(outputHandler);
    }

    @Override
    @Nonnull
    public GitCatFileBatchBuilder defaultExitHandler() {
        this.useDefaultExitHandler = true;
        return this.self();
    }

    @Override
    @Nonnull
    public GitCatFileBatchBuilder exitHandler(@Nonnull CommandExitHandler value) {
        super.exitHandler(value);
        this.useDefaultExitHandler = false;
        return this.self();
    }

    @Override
    protected void applyArguments() {
        this.builder.inputHandler(this.inputHandler);
        this.builder.argument(this.format.getFlag());
    }

    @Override
    @Nonnull
    protected GitCatFileBatchBuilder self() {
        return this;
    }
}

