/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command.catfile;

import com.atlassian.bitbucket.scm.git.command.catfile.GitCatFileBuilder;
import com.atlassian.stash.internal.scm.git.command.AbstractGitCommandBuilder;
import com.atlassian.stash.internal.scm.git.command.GitFreeFormCommandBuilder;
import com.atlassian.stash.internal.scm.git.command.catfile.CatFileFormat;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class DefaultGitCatFileBuilder
extends AbstractGitCommandBuilder<GitCatFileBuilder>
implements GitCatFileBuilder {
    private final CatFileFormat format;
    private String object;

    public DefaultGitCatFileBuilder(GitFreeFormCommandBuilder builder, CatFileFormat format) {
        super(builder);
        this.format = format;
    }

    @Nonnull
    public DefaultGitCatFileBuilder object(@Nonnull String value) {
        Objects.requireNonNull(value, "object");
        this.object = value.indexOf(58) == -1 ? this.checkNotBlank(value, "object") : StringUtils.stripStart((String)value, null);
        return this;
    }

    @Nonnull
    public DefaultGitCatFileBuilder object(@Nonnull String rev, String file) {
        return this.object(this.checkNotBlank(rev, "rev") + ":" + StringUtils.defaultString((String)file));
    }

    @Override
    protected void applyArguments() {
        this.builder.argument(this.format.getFlag());
        this.builder.rawArgument(this.object);
    }

    @Override
    @Nonnull
    protected GitCatFileBuilder self() {
        return this;
    }
}

