/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command.checkout;

import com.atlassian.stash.internal.scm.git.command.AbstractGitCommandBuilder;
import com.atlassian.stash.internal.scm.git.command.GitFreeFormCommandBuilder;
import com.atlassian.stash.internal.scm.git.command.checkout.GitCheckoutBuilder;
import com.atlassian.stash.internal.scm.git.command.checkout.GitCheckoutCreateBranchMode;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class DefaultGitCheckoutBuilder
extends AbstractGitCommandBuilder<GitCheckoutBuilder>
implements GitCheckoutBuilder {
    private String branch;
    private boolean detach;
    private boolean force;
    private GitCheckoutCreateBranchMode mode;
    private boolean reflog;
    private boolean quiet;
    private String startPoint;

    public DefaultGitCheckoutBuilder(GitFreeFormCommandBuilder builder) {
        super((GitFreeFormCommandBuilder)builder.command("checkout"));
    }

    @Override
    @Nonnull
    public GitCheckoutBuilder branch(@Nonnull String value) {
        this.branch = this.checkNotBlank(value, "branch");
        this.detach = false;
        this.mode = null;
        this.startPoint = null;
        return this.self();
    }

    @Override
    @Nonnull
    public GitCheckoutBuilder branch(@Nonnull String branch, String startPoint) {
        return this.branch(branch, startPoint, GitCheckoutCreateBranchMode.CREATE);
    }

    @Override
    @Nonnull
    public GitCheckoutBuilder branch(@Nonnull String branch, String startPoint, @Nonnull GitCheckoutCreateBranchMode mode) {
        this.branch = this.checkNotBlank(branch, "branch");
        this.mode = Objects.requireNonNull(mode, "mode");
        this.startPoint = startPoint;
        this.detach = false;
        return this.self();
    }

    @Override
    @Nonnull
    public GitCheckoutBuilder detach(@Nonnull String value) {
        this.branch = this.checkNotBlank(value, "value");
        this.detach = true;
        this.mode = null;
        this.startPoint = null;
        return this.self();
    }

    @Override
    @Nonnull
    public GitCheckoutBuilder force(boolean value) {
        this.force = value;
        return this.self();
    }

    @Override
    @Nonnull
    public GitCheckoutBuilder quiet(boolean value) {
        this.quiet = value;
        return this.self();
    }

    @Override
    @Nonnull
    public GitCheckoutBuilder reflog(boolean value) {
        this.reflog = value;
        return this.self();
    }

    @Override
    protected void applyArguments() {
        if (this.force) {
            this.builder.argument("--force");
        }
        if (this.quiet) {
            this.builder.argument("--quiet");
        }
        if (this.detach) {
            this.builder.argument("--detach");
            this.builder.commitish(this.branch);
        } else if (this.mode == null) {
            this.builder.commitish(this.branch);
        } else {
            if (this.reflog) {
                this.builder.argument("-l");
            }
            ((GitFreeFormCommandBuilder)this.builder.argument(this.mode.getFlag())).argument(this.branch);
            if (StringUtils.isNotBlank((CharSequence)this.startPoint)) {
                this.builder.commitish(this.startPoint);
            }
        }
    }

    @Override
    @Nonnull
    protected GitCheckoutBuilder self() {
        return this;
    }
}

