/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command.clone;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.git.command.GitCommand;
import com.atlassian.stash.internal.scm.git.GitScmConfig;
import com.atlassian.stash.internal.scm.git.command.AbstractGitCommandBuilder;
import com.atlassian.stash.internal.scm.git.command.GitFreeFormCommandBuilder;
import com.atlassian.stash.internal.scm.git.command.clone.CloneFormat;
import com.atlassian.stash.internal.scm.git.command.clone.GitCloneBuilder;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.nio.file.Path;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class DefaultGitCloneBuilder
extends AbstractGitCommandBuilder<GitCloneBuilder>
implements GitCloneBuilder {
    private final GitScmConfig config;
    private final CloneFormat format;
    private String branch;
    private boolean checkout;
    private String directory;
    private String origin;
    private boolean quiet;
    private boolean shared;
    private String template;

    public DefaultGitCloneBuilder(GitFreeFormCommandBuilder builder, GitScmConfig config, CloneFormat format) {
        super(builder);
        this.config = config;
        this.format = format;
        this.checkout = !format.isFlagged();
    }

    @Override
    @Nonnull
    public GitCloneBuilder branch(String value) {
        this.branch = value;
        return this.self();
    }

    @Override
    @Nonnull
    public GitCommand<?> build() {
        return this.buildWithLoggingHandler();
    }

    @Override
    @Nonnull
    public DefaultGitCloneBuilder checkout(boolean value) {
        if (this.format.isFlagged()) {
            throw new IllegalStateException(StringUtils.capitalize((String)this.format.name()) + " clones do not have a work tree and therefore do not allow checkouts");
        }
        this.checkout = value;
        return this.self();
    }

    @Override
    @Nonnull
    public GitCloneBuilder directory(@Nonnull File value) {
        return this.directory(Objects.requireNonNull(value, "directory").getAbsolutePath());
    }

    @Override
    @Nonnull
    public GitCloneBuilder directory(@Nonnull Path value) {
        return this.directory(Objects.requireNonNull(value, "directory").toAbsolutePath().toString());
    }

    @Override
    @Nonnull
    public DefaultGitCloneBuilder directory(@Nonnull String value) {
        this.directory = Objects.requireNonNull(value, "directory");
        return this.self();
    }

    @Override
    @Nonnull
    public GitCloneBuilder origin(@Nonnull File value) {
        return this.origin(Objects.requireNonNull(value, "origin").getAbsolutePath());
    }

    @Override
    @Nonnull
    public GitCloneBuilder origin(@Nonnull Path value) {
        return this.origin(Objects.requireNonNull(value, "origin").toAbsolutePath().toString());
    }

    @Override
    @Nonnull
    public GitCloneBuilder origin(@Nonnull Repository value) {
        return this.origin(this.config.getRepositoryDir(Objects.requireNonNull(value, "origin")));
    }

    @Override
    @Nonnull
    public GitCloneBuilder origin(@Nonnull String value) {
        this.origin = Objects.requireNonNull(value, "origin");
        return this.self();
    }

    @Override
    @Nonnull
    public GitCloneBuilder quiet(boolean value) {
        this.quiet = value;
        return this.self();
    }

    @Override
    @Nonnull
    public GitCloneBuilder shared(boolean value) {
        this.shared = value;
        return this.self();
    }

    @Override
    @Nonnull
    public GitCloneBuilder template(@Nullable File value) {
        return this.template(value == null ? null : value.getAbsolutePath());
    }

    @Override
    @Nonnull
    public GitCloneBuilder template(@Nullable Path value) {
        return this.template(value == null ? null : value.toAbsolutePath().toString());
    }

    @Override
    @Nonnull
    public GitCloneBuilder template(@Nullable String value) {
        this.template = value;
        return this.self();
    }

    @Override
    protected void applyArguments() {
        if (this.format.isFlagged()) {
            this.builder.argument(this.format.getFlag());
        } else if (!this.checkout) {
            this.builder.argument("--no-checkout");
        }
        if (this.quiet) {
            this.builder.argument("--quiet");
        }
        if (this.shared) {
            this.builder.argument("--shared");
        }
        if (StringUtils.isNotBlank((CharSequence)this.template)) {
            this.builder.argument("--template=" + this.template);
        }
        if (StringUtils.isNotBlank((CharSequence)this.branch)) {
            ((GitFreeFormCommandBuilder)this.builder.argument("-b")).argument(this.branch);
        }
        ((GitFreeFormCommandBuilder)this.builder.argument(this.origin)).argument(this.directory);
    }

    @Override
    @Nonnull
    protected DefaultGitCloneBuilder self() {
        return this;
    }
}

