/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command.commit;

import com.atlassian.bitbucket.scm.git.command.GitCommand;
import com.atlassian.bitbucket.scm.git.command.commit.GitCommitBuilder;
import com.atlassian.bitbucket.scm.git.command.commit.GitCommitVerify;
import com.atlassian.stash.internal.scm.git.command.AbstractGitCommandBuilder;
import com.atlassian.stash.internal.scm.git.command.GitFreeFormCommandBuilder;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

public class DefaultGitCommitBuilder
extends AbstractGitCommandBuilder<GitCommitBuilder>
implements GitCommitBuilder {
    private final Set<String> paths = new LinkedHashSet<String>();
    private boolean all;
    private File file;
    private String message;
    private boolean quiet;
    private GitCommitVerify verify = GitCommitVerify.DEFAULT;

    public DefaultGitCommitBuilder(GitFreeFormCommandBuilder builder) {
        super((GitFreeFormCommandBuilder)builder.command("commit"));
    }

    @Nonnull
    public GitCommitBuilder all(boolean value) {
        this.all = value;
        return this.self();
    }

    @Nonnull
    public GitCommand<Void> build() {
        return this.buildWithLoggingHandler();
    }

    @Nonnull
    public GitCommitBuilder clearPaths() {
        this.paths.clear();
        return this.self();
    }

    @Nonnull
    public GitCommitBuilder message(@Nonnull File value) {
        this.file = Objects.requireNonNull(value, "message");
        return this.self();
    }

    @Nonnull
    public GitCommitBuilder message(@Nonnull String value) {
        this.message = this.checkNotBlank(value, "message");
        return this.self();
    }

    @Nonnull
    public GitCommitBuilder path(String value) {
        DefaultGitCommitBuilder.addIfNotBlank(this.paths, value);
        return this.self();
    }

    @Nonnull
    public GitCommitBuilder paths(String value, String ... values) {
        DefaultGitCommitBuilder.addIfNotBlank(this.paths, value, values);
        return this.self();
    }

    @Nonnull
    public GitCommitBuilder paths(@Nonnull Iterable<String> values) {
        DefaultGitCommitBuilder.addIfNotBlank(this.paths, Objects.requireNonNull(values, "paths"));
        return this.self();
    }

    @Nonnull
    public GitCommitBuilder quiet(boolean value) {
        this.quiet = value;
        return this.self();
    }

    @Nonnull
    public GitCommitBuilder verify(@Nonnull GitCommitVerify value) {
        this.verify = Objects.requireNonNull(value, "verify");
        return this.self();
    }

    @Override
    protected void applyArguments() {
        if (this.all) {
            this.builder.argument("-a");
        }
        if (this.file == null) {
            ((GitFreeFormCommandBuilder)this.builder.argument("-m")).argument(this.message);
        } else {
            ((GitFreeFormCommandBuilder)this.builder.argument("-F")).argument(this.file.getAbsolutePath());
        }
        if (this.quiet) {
            this.builder.argument("-q");
        }
        this.verify.getFlag().ifPresent(arg_0 -> ((GitFreeFormCommandBuilder)this.builder).argument(arg_0));
        this.builder.argument("--");
        this.paths.forEach(arg_0 -> ((GitFreeFormCommandBuilder)this.builder).rawArgument(arg_0));
    }

    @Override
    @Nonnull
    protected GitCommitBuilder self() {
        return this;
    }
}

