/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command.config;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;

public class ConfigSection {
    private final Multimap<String, String> entries;
    private final String name;
    private final String subsection;

    public ConfigSection(String name, String subsection, Multimap<String, String> entries) {
        this.name = Objects.requireNonNull(name, "name");
        this.subsection = subsection;
        this.entries = Objects.requireNonNull(entries, "entries");
    }

    @Nonnull
    public Multimap<String, String> getEntries() {
        return this.entries;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getSubsection() {
        return this.subsection;
    }

    public static class Builder {
        private final ImmutableMultimap.Builder<String, String> entries;
        private final String section;
        private final String subsection;

        public Builder(@Nonnull String section, @Nullable String subsection) {
            this.section = Objects.requireNonNull(section, "section");
            this.subsection = subsection;
            this.entries = ImmutableMultimap.builder();
        }

        @Nonnull
        public ConfigSection build() {
            return new ConfigSection(this.section, this.subsection, (Multimap<String, String>)this.entries.build());
        }

        @Nonnull
        public Builder entry(@Nonnull String name, @Nonnull String value) {
            this.entries.put((Object)name, (Object)value);
            return this;
        }
    }
}

