/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command.config;

import com.atlassian.bitbucket.dmz.process.StringStdoutHandler;
import com.atlassian.bitbucket.scm.git.command.GitCommand;
import com.atlassian.bitbucket.scm.git.command.config.GitConfigGetBuilder;
import com.atlassian.stash.internal.scm.git.command.GitFreeFormCommandBuilder;
import com.atlassian.stash.internal.scm.git.command.config.AbstractTypedGitConfigBuilder;
import jakarta.annotation.Nonnull;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;

public class DefaultGitConfigGetBuilder
extends AbstractTypedGitConfigBuilder<GitConfigGetBuilder>
implements GitConfigGetBuilder {
    private boolean nullTerminated;

    public DefaultGitConfigGetBuilder(GitFreeFormCommandBuilder builder, String name) {
        super(builder, name);
    }

    @Nonnull
    public GitCommand<String> build() {
        return this.build(new GetConfigStdoutHandler(this.nullTerminated));
    }

    @Nonnull
    public GitConfigGetBuilder nullTerminated(boolean value) {
        this.nullTerminated = value;
        return this.self();
    }

    @Override
    protected void applyArguments() {
        super.applyArguments();
        if (this.nullTerminated) {
            this.builder.argument("-z");
        }
        ((GitFreeFormCommandBuilder)this.builder.argument("--get")).argument(this.name);
    }

    @Override
    @Nonnull
    protected GitConfigGetBuilder self() {
        return this;
    }

    private static class GetConfigStdoutHandler
    extends StringStdoutHandler {
        private final boolean nullTerminated;

        public GetConfigStdoutHandler(boolean nullTerminated) {
            super(StandardCharsets.UTF_8);
            this.nullTerminated = nullTerminated;
        }

        @Nonnull
        public String getOutput() {
            String value = super.getOutput();
            return this.nullTerminated ? value.substring(0, value.length() - 1) : StringUtils.chomp((String)value);
        }
    }
}

