/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command.diff;

import com.atlassian.bitbucket.scm.git.command.diff.GitDiffColor;
import com.atlassian.bitbucket.scm.git.command.diff.GitDiffCoreBuilder;
import com.atlassian.bitbucket.scm.git.command.diff.GitDiffRenames;
import com.atlassian.stash.internal.scm.git.command.AbstractGitCommandBuilder;
import com.atlassian.stash.internal.scm.git.command.GitFreeFormCommandBuilder;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

public abstract class AbstractGitDiffCoreBuilder<B extends GitDiffCoreBuilder<B>>
extends AbstractGitCommandBuilder<B>
implements GitDiffCoreBuilder<B> {
    protected final Set<String> paths;
    protected String ancestor;
    protected String rev;
    private GitDiffColor color = GitDiffColor.DEFAULT;
    private boolean fullIndex;
    private GitDiffRenames renames;
    private Integer threshold;

    public AbstractGitDiffCoreBuilder(GitFreeFormCommandBuilder builder) {
        super(builder);
        this.paths = new LinkedHashSet<String>();
        this.renames = GitDiffRenames.OFF;
    }

    @Nonnull
    public B ancestor(String value) {
        this.ancestor = value;
        return (B)((GitDiffCoreBuilder)this.self());
    }

    @Nonnull
    public B clearPaths() {
        this.paths.clear();
        return (B)((GitDiffCoreBuilder)this.self());
    }

    @Nonnull
    public B color(@Nonnull GitDiffColor value) {
        this.color = Objects.requireNonNull(value, "color");
        return (B)((GitDiffCoreBuilder)this.self());
    }

    @Nonnull
    public B fullIndex(boolean value) {
        this.fullIndex = value;
        return (B)((GitDiffCoreBuilder)this.self());
    }

    @Nonnull
    public B path(String value) {
        AbstractGitDiffCoreBuilder.addIfNotBlank(this.paths, value);
        return (B)((GitDiffCoreBuilder)this.self());
    }

    @Nonnull
    public B paths(String value, String ... values) {
        AbstractGitDiffCoreBuilder.addIfNotBlank(this.paths, value, values);
        return (B)((GitDiffCoreBuilder)this.self());
    }

    @Nonnull
    public B paths(Iterable<String> values) {
        if (values != null) {
            AbstractGitDiffCoreBuilder.addIfNotBlank(this.paths, values);
        }
        return (B)((GitDiffCoreBuilder)this.self());
    }

    @Nonnull
    public B renames(@Nonnull GitDiffRenames value) {
        return this.renames(value, null);
    }

    @Nonnull
    public B renames(@Nonnull GitDiffRenames renames, Integer threshold) {
        this.renames = Objects.requireNonNull(renames, "renames");
        this.threshold = renames.supportsThreshold() ? AbstractGitDiffCoreBuilder.checkThreshold(threshold) : null;
        return (B)((GitDiffCoreBuilder)this.self());
    }

    @Nonnull
    public B rev(String value) {
        this.rev = value;
        return (B)((GitDiffCoreBuilder)this.self());
    }

    @Override
    protected void applyArguments() {
        if (this.renames == GitDiffRenames.FIND_COPIES_HARDER) {
            this.builder.argument(this.applyThreshold("-C"));
            this.builder.argument("--find-copies-harder");
        } else if (this.renames == GitDiffRenames.FIND_COPIES) {
            this.builder.argument(this.applyThreshold("-C"));
        } else if (this.renames == GitDiffRenames.FIND_RENAMES) {
            this.builder.argument(this.applyThreshold("-M"));
        } else if (this.renames == GitDiffRenames.OFF) {
            this.builder.argument("--no-renames");
        }
        if (this.color.isFlagged()) {
            this.builder.argument(this.color.getFlag());
        }
        if (this.fullIndex) {
            this.builder.argument("--full-index");
        }
    }

    protected void applyPaths() {
        this.builder.argument("--");
        this.paths.forEach(arg_0 -> ((GitFreeFormCommandBuilder)this.builder).rawArgument(arg_0));
    }

    private String applyThreshold(String base) {
        return this.threshold == null ? base : base + this.threshold + "%";
    }

    private static Integer checkThreshold(Integer threshold) {
        if (threshold == null) {
            return null;
        }
        int value = threshold;
        Preconditions.checkArgument((value >= 0 && value <= 100 ? 1 : 0) != 0, (Object)"The threshold must be a positive integer between 0 and 100");
        return threshold;
    }
}

