/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command.diff;

import com.atlassian.bitbucket.content.Change;
import com.atlassian.bitbucket.content.ChangeCallback;
import com.atlassian.bitbucket.content.ChangeContext;
import com.atlassian.bitbucket.content.ChangeSummary;
import com.atlassian.bitbucket.content.Conflict;
import com.atlassian.bitbucket.content.SimpleChange;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;

public class ConflictDecoratingChangeCallback
implements ChangeCallback {
    private static final Function<Change, Conflict> NO_CONFLICT = change -> null;
    private final ChangeCallback delegate;
    private final Function<Change, Conflict> directoryConflicts;
    private final Function<Change, Conflict> fileConflicts;

    public ConflictDecoratingChangeCallback(ChangeCallback delegate, Map<String, Conflict> conflicts) {
        this.delegate = delegate;
        HashMap<String, Conflict> directoryPaths = new HashMap<String, Conflict>();
        HashMap<String, Conflict> filePaths = new HashMap<String, Conflict>();
        conflicts.forEach((path, conflict) -> {
            if (StringUtils.endsWith((CharSequence)path, (CharSequence)"/")) {
                directoryPaths.put((String)path, (Conflict)conflict);
            } else {
                filePaths.put((String)path, (Conflict)conflict);
            }
        });
        this.directoryConflicts = directoryPaths.isEmpty() ? NO_CONFLICT : new DirectoryConflictFunction(directoryPaths);
        this.fileConflicts = filePaths.isEmpty() ? NO_CONFLICT : new FileConflictFunction(filePaths);
    }

    @Nonnull
    public static ChangeCallback maybeWrap(@Nonnull ChangeCallback delegate, @Nullable Map<String, Conflict> conflicts) {
        if (conflicts == null || conflicts.isEmpty()) {
            return delegate;
        }
        return new ConflictDecoratingChangeCallback(delegate, conflicts);
    }

    public boolean onChange(@Nonnull Change change) throws IOException {
        return this.delegate.onChange(this.maybeApplyConflict(change));
    }

    public void onEnd(@Nonnull ChangeSummary summary) throws IOException {
        this.delegate.onEnd(summary);
    }

    public void onStart(@Nonnull ChangeContext context) throws IOException {
        this.delegate.onStart(context);
    }

    private Change maybeApplyConflict(Change change) {
        Conflict conflict = this.fileConflicts.apply(change);
        if (conflict == null) {
            conflict = this.directoryConflicts.apply(change);
        }
        if (conflict != null) {
            change = new SimpleChange.Builder(change).conflict(conflict).build();
        }
        return change;
    }

    private static class DirectoryConflictFunction
    implements Function<Change, Conflict> {
        private final Map<String, Conflict> conflicts;

        private DirectoryConflictFunction(Map<String, Conflict> conflicts) {
            this.conflicts = ImmutableMap.copyOf(conflicts);
        }

        @Override
        public Conflict apply(Change change) {
            String path = change.getPath().toString();
            String srcPath = change.getSrcPath() == null ? null : change.getSrcPath().toString();
            for (Map.Entry<String, Conflict> entry : this.conflicts.entrySet()) {
                if (!path.startsWith(entry.getKey()) && (srcPath == null || !srcPath.startsWith(entry.getKey()))) continue;
                return entry.getValue();
            }
            return null;
        }
    }

    private static class FileConflictFunction
    implements Function<Change, Conflict> {
        private final Map<String, Conflict> conflicts;

        private FileConflictFunction(Map<String, Conflict> conflicts) {
            this.conflicts = ImmutableMap.copyOf(conflicts);
        }

        @Override
        public Conflict apply(Change change) {
            Conflict conflict = this.conflicts.get(change.getPath().toString());
            if (conflict == null && change.getSrcPath() != null) {
                conflict = this.conflicts.get(change.getSrcPath().toString());
            }
            return conflict;
        }
    }
}

