/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command.diff;

import com.atlassian.bitbucket.scm.git.command.diff.GitDiffBuilder;
import com.atlassian.bitbucket.scm.git.command.diff.GitDiffWhitespace;
import com.atlassian.stash.internal.scm.git.command.GitFreeFormCommandBuilder;
import com.atlassian.stash.internal.scm.git.command.diff.AbstractGitDiffCoreBuilder;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class DefaultGitDiffBuilder
extends AbstractGitDiffCoreBuilder<GitDiffBuilder>
implements GitDiffBuilder {
    private String dstPrefix;
    private String srcPrefix;
    private String context;
    private GitDiffWhitespace whitespace = GitDiffWhitespace.SHOW;

    public DefaultGitDiffBuilder(GitFreeFormCommandBuilder builder) {
        super((GitFreeFormCommandBuilder)builder.command("diff"));
    }

    @Nonnull
    public GitDiffBuilder contextLines(int value) {
        Preconditions.checkArgument((value >= 0 ? 1 : 0) != 0, (Object)"Context value must be a non-negative integer");
        this.context = Integer.toString(value);
        return this.self();
    }

    @Nonnull
    public GitDiffBuilder defaultContextLines() {
        this.context = null;
        return this.self();
    }

    @Nonnull
    public GitDiffBuilder dstPrefix(String value) {
        this.dstPrefix = value;
        return this.self();
    }

    @Nonnull
    public GitDiffBuilder srcPrefix(String value) {
        this.srcPrefix = value;
        return this.self();
    }

    @Nonnull
    public GitDiffBuilder whitespace(@Nonnull GitDiffWhitespace value) {
        this.whitespace = Objects.requireNonNull(value, "whitespace");
        return this.self();
    }

    @Override
    protected void applyArguments() {
        super.applyArguments();
        if (this.context != null) {
            this.builder.argument("-U" + this.context);
        } else {
            this.builder.argument("-U");
        }
        if (StringUtils.isNotBlank((CharSequence)this.dstPrefix)) {
            this.builder.argument("--dst-prefix=" + this.dstPrefix);
        }
        if (StringUtils.isNotBlank((CharSequence)this.srcPrefix)) {
            this.builder.argument("--src-prefix=" + this.srcPrefix);
        }
        if (this.whitespace.isFlagged()) {
            this.builder.argument(this.whitespace.getFlag());
        }
        if (StringUtils.isBlank((CharSequence)this.ancestor)) {
            ((GitFreeFormCommandBuilder)((GitFreeFormCommandBuilder)this.builder.command("log")).argument("--pretty=format:")).argument("-1");
        } else {
            this.builder.commitish(this.ancestor);
        }
        this.builder.commitish(this.rev);
        this.applyPaths();
    }

    @Override
    @Nonnull
    protected DefaultGitDiffBuilder self() {
        return this;
    }
}

