/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command.diff;

import com.atlassian.bitbucket.scm.CommandInputHandler;
import com.atlassian.bitbucket.scm.git.command.diff.GitDiffTreeBuilder;
import com.atlassian.stash.internal.scm.git.command.GitFreeFormCommandBuilder;
import com.atlassian.stash.internal.scm.git.command.diff.AbstractGitDiffCoreBuilder;
import jakarta.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class DefaultGitDiffTreeBuilder
extends AbstractGitDiffCoreBuilder<GitDiffTreeBuilder>
implements GitDiffTreeBuilder {
    private boolean always;
    private String format;
    private boolean merges;
    private boolean recursive;
    private boolean root;
    private boolean stdIn;

    public DefaultGitDiffTreeBuilder(GitFreeFormCommandBuilder builder) {
        super((GitFreeFormCommandBuilder)builder.command("diff-tree"));
    }

    @Nonnull
    public GitDiffTreeBuilder always(boolean value) {
        this.always = value;
        return this.self();
    }

    @Nonnull
    public GitDiffTreeBuilder format(String value) {
        this.format = value;
        return this.self();
    }

    @Nonnull
    public GitDiffTreeBuilder inputHandler(CommandInputHandler inputHandler) {
        if (inputHandler == null) {
            this.stdIn = false;
            this.builder.clearInputHandler();
        } else {
            this.stdIn = true;
            this.builder.inputHandler(inputHandler);
        }
        return this.self();
    }

    @Nonnull
    public DefaultGitDiffTreeBuilder merges(boolean value) {
        this.merges = value;
        return this.self();
    }

    @Nonnull
    public DefaultGitDiffTreeBuilder recursive(boolean value) {
        this.recursive = value;
        return this.self();
    }

    @Nonnull
    public DefaultGitDiffTreeBuilder root(boolean value) {
        this.root = value;
        return this.self();
    }

    @Override
    protected void applyArguments() {
        super.applyArguments();
        if (this.merges) {
            this.builder.argument("-m");
        }
        if (this.recursive) {
            this.builder.argument("-r");
        }
        if (this.always) {
            this.builder.argument("--always");
        }
        if (StringUtils.isNotBlank((CharSequence)this.format)) {
            this.builder.argument("--format=" + this.format);
        }
        if (this.root) {
            this.builder.argument("--root");
        }
        if (this.stdIn) {
            this.builder.argument("--stdin");
        } else {
            if (StringUtils.isNotBlank((CharSequence)this.ancestor)) {
                this.builder.commitish(this.ancestor);
            }
            this.builder.commitish(this.rev);
        }
        this.applyPaths();
    }

    @Override
    @Nonnull
    protected DefaultGitDiffTreeBuilder self() {
        return this;
    }
}

