/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command.fetch;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.CommandErrorHandler;
import com.atlassian.bitbucket.scm.git.command.fetch.GitFetchBuilder;
import com.atlassian.bitbucket.scm.git.command.fetch.GitFetchTagMode;
import com.atlassian.stash.internal.scm.git.GitScmConfig;
import com.atlassian.stash.internal.scm.git.command.AbstractGitCommandBuilder;
import com.atlassian.stash.internal.scm.git.command.GitFreeFormCommandBuilder;
import com.google.common.collect.Lists;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class DefaultGitFetchBuilder
extends AbstractGitCommandBuilder<GitFetchBuilder>
implements GitFetchBuilder {
    private final Repository baseRepository;
    private final GitScmConfig config;
    private boolean atomic;
    private boolean force;
    private boolean prune;
    private boolean quiet;
    private boolean progress;
    private List<String> refspecs;
    private String repository;
    private GitFetchTagMode tagMode;

    public DefaultGitFetchBuilder(GitFreeFormCommandBuilder builder, @Nullable Repository baseRepository, GitScmConfig config) {
        super((GitFreeFormCommandBuilder)builder.command("fetch"));
        this.baseRepository = baseRepository;
        this.config = config;
        this.refspecs = Lists.newArrayList();
        this.tagMode = GitFetchTagMode.DEFAULT;
    }

    @Nonnull
    public GitFetchBuilder atomic(boolean value) {
        this.atomic = value;
        return this.self();
    }

    @Nonnull
    public GitFetchBuilder clearRefspecs() {
        this.refspecs.clear();
        return this.self();
    }

    @Nonnull
    public GitFetchBuilder errorHandler(@Nonnull CommandErrorHandler value) {
        this.builder.errorHandler(value);
        return this.self();
    }

    @Nonnull
    public GitFetchBuilder force(boolean value) {
        this.force = value;
        return this.self();
    }

    @Nonnull
    public GitFetchBuilder progress(boolean value) {
        this.progress = value;
        return this.self();
    }

    @Nonnull
    public GitFetchBuilder prune(boolean value) {
        this.prune = value;
        return this.self();
    }

    @Nonnull
    public GitFetchBuilder quiet(boolean value) {
        this.quiet = value;
        return this.self();
    }

    @Nonnull
    public GitFetchBuilder refspec(String value) {
        DefaultGitFetchBuilder.addIfNotBlank(this.refspecs, value);
        return this.self();
    }

    @Nonnull
    public GitFetchBuilder refspecs(Iterable<String> values) {
        DefaultGitFetchBuilder.addIfNotBlank(this.refspecs, values);
        return this.self();
    }

    @Nonnull
    public GitFetchBuilder refspecs(String value, String ... values) {
        DefaultGitFetchBuilder.addIfNotBlank(this.refspecs, value, values);
        return this.self();
    }

    @Nonnull
    public GitFetchBuilder repository(Repository value) {
        if (value == null) {
            return this.repository((String)null);
        }
        return this.repository(this.baseRepository == null ? this.config.getRepositoryDir(value).toAbsolutePath().toString() : this.config.getRelativePath(value, this.baseRepository));
    }

    @Nonnull
    public GitFetchBuilder repository(String value) {
        this.repository = value;
        return this.self();
    }

    @Nonnull
    public GitFetchBuilder tags(@Nonnull GitFetchTagMode value) {
        this.tagMode = Objects.requireNonNull(value, "tags");
        return this.self();
    }

    @Override
    protected void applyArguments() {
        if (this.atomic) {
            this.builder.argument("--atomic");
        }
        if (this.force) {
            this.builder.argument("--force");
        }
        if (this.prune) {
            this.builder.argument("--prune");
        }
        if (this.quiet) {
            this.builder.argument("--quiet");
        }
        if (this.progress) {
            this.builder.argument("--progress");
        }
        if (this.tagMode.isFlagged()) {
            this.builder.argument(this.tagMode.getFlag());
        }
        if (StringUtils.isNotBlank((CharSequence)this.repository)) {
            this.builder.argument(this.repository);
            for (String refspec : this.refspecs) {
                this.builder.argument(refspec);
            }
        }
    }

    @Override
    @Nonnull
    protected GitFetchBuilder self() {
        return this;
    }
}

