/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command.foreachref;

import com.atlassian.bitbucket.scm.git.command.foreachref.GitForEachRefBuilder;
import com.atlassian.stash.internal.scm.git.command.AbstractGitCommandBuilder;
import com.atlassian.stash.internal.scm.git.command.GitFreeFormCommandBuilder;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DefaultGitForEachRefBuilder
extends AbstractGitCommandBuilder<GitForEachRefBuilder>
implements GitForEachRefBuilder {
    private int count;
    private String format;
    private List<String> patterns = Collections.emptyList();
    private String sort;

    public DefaultGitForEachRefBuilder(GitFreeFormCommandBuilder builder) {
        super((GitFreeFormCommandBuilder)builder.command("for-each-ref"));
    }

    @Nonnull
    public GitForEachRefBuilder count(int value) {
        this.count = value;
        return this.self();
    }

    @Nonnull
    public GitForEachRefBuilder format(String value) {
        this.format = value;
        return this.self();
    }

    @Nonnull
    public GitForEachRefBuilder pattern(String value) {
        return this.patterns(value, new String[0]);
    }

    @Nonnull
    public GitForEachRefBuilder patterns(String value, String ... values) {
        this.patterns = value == null ? Collections.emptyList() : ImmutableList.builder().add((Object)value).add((Object[])values).build();
        return this.self();
    }

    @Nonnull
    public GitForEachRefBuilder sort(String value) {
        this.sort = value;
        return this.self();
    }

    @Override
    protected void applyArguments() {
        if (this.count > 0) {
            this.builder.argument("--count=" + this.count);
        }
        if (StringUtils.isNotBlank((CharSequence)this.sort)) {
            this.builder.argument("--sort=" + this.sort);
        }
        if (StringUtils.isNotBlank((CharSequence)this.format)) {
            this.builder.argument("--format=" + this.format);
        }
        for (String pattern : this.patterns) {
            this.builder.argument(pattern);
        }
    }

    @Override
    @Nonnull
    protected GitForEachRefBuilder self() {
        return this;
    }
}

