/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command.formatpatch;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.CommandExitHandler;
import com.atlassian.bitbucket.scm.CommandOutputHandler;
import com.atlassian.bitbucket.scm.git.command.GitCommand;
import com.atlassian.bitbucket.scm.git.command.GitCommandExitHandler;
import com.atlassian.bitbucket.scm.git.command.formatpatch.GitFormatPatchBuilder;
import com.atlassian.stash.internal.scm.git.command.AbstractGitCommandBuilder;
import com.atlassian.stash.internal.scm.git.command.GitFreeFormCommandBuilder;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class DefaultGitFormatPatchBuilder
extends AbstractGitCommandBuilder<GitFormatPatchBuilder>
implements GitFormatPatchBuilder {
    private final I18nService i18nService;
    private final Repository repository;
    private boolean allAncestors;
    private String ancestor;
    private String rev;
    private boolean useDefaultExitHandler;

    public DefaultGitFormatPatchBuilder(GitFreeFormCommandBuilder builder, I18nService i18nService, Repository repository) {
        super((GitFreeFormCommandBuilder)builder.command("format-patch"));
        this.i18nService = i18nService;
        this.repository = repository;
        this.useDefaultExitHandler = true;
    }

    @Nonnull
    public GitFormatPatchBuilder allAncestors(boolean value) {
        this.allAncestors = value;
        return this.self();
    }

    @Nonnull
    public GitFormatPatchBuilder ancestor(String value) {
        this.ancestor = StringUtils.trimToNull((String)value);
        return this.self();
    }

    @Override
    @Nonnull
    public <T> GitCommand<T> build(@Nonnull CommandOutputHandler<T> outputHandler) {
        if (this.useDefaultExitHandler) {
            this.builder.exitHandler((CommandExitHandler)new GitCommandExitHandler(this.i18nService, this.repository));
        }
        return super.build(outputHandler);
    }

    @Override
    @Nonnull
    public GitFormatPatchBuilder defaultExitHandler() {
        this.useDefaultExitHandler = true;
        return this.self();
    }

    @Override
    @Nonnull
    public GitFormatPatchBuilder exitHandler(@Nonnull CommandExitHandler value) {
        super.exitHandler(value);
        this.useDefaultExitHandler = false;
        return this.self();
    }

    @Nonnull
    public GitFormatPatchBuilder rev(@Nonnull String value) {
        this.rev = Objects.requireNonNull(value, "rev");
        return this.self();
    }

    @Override
    protected void applyArguments() {
        this.builder.argument("--stdout");
        if (this.allAncestors) {
            this.builder.argument("--root");
        } else if (this.ancestor == null) {
            this.builder.argument("-1");
        } else {
            this.builder.argument("^" + this.ancestor);
        }
        ((GitFreeFormCommandBuilder)this.builder.commitish(this.rev)).argument("--");
    }

    @Override
    @Nonnull
    protected GitFormatPatchBuilder self() {
        return this;
    }
}

