/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command.init;

import com.atlassian.bitbucket.scm.git.command.GitCommand;
import com.atlassian.stash.internal.scm.git.command.AbstractGitCommandBuilder;
import com.atlassian.stash.internal.scm.git.command.GitFreeFormCommandBuilder;
import com.atlassian.stash.internal.scm.git.command.init.GitInitBuilder;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.nio.file.Path;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class DefaultGitInitBuilder
extends AbstractGitCommandBuilder<GitInitBuilder>
implements GitInitBuilder {
    private boolean bare;
    private String directory;
    private boolean quiet;
    private String shared;
    private String template;

    public DefaultGitInitBuilder(GitFreeFormCommandBuilder builder) {
        super((GitFreeFormCommandBuilder)builder.command("init"));
    }

    @Override
    @Nonnull
    public GitInitBuilder bare(boolean value) {
        this.bare = value;
        return this.self();
    }

    @Override
    @Nonnull
    public GitCommand<?> build() {
        return this.buildWithLoggingHandler();
    }

    @Override
    @Nonnull
    public GitInitBuilder directory(@Nonnull File value) {
        return this.directory(Objects.requireNonNull(value, "directory").getAbsolutePath());
    }

    @Override
    @Nonnull
    public GitInitBuilder directory(@Nonnull Path value) {
        return this.directory(Objects.requireNonNull(value, "directory").toAbsolutePath().toString());
    }

    @Override
    @Nonnull
    public GitInitBuilder directory(@Nonnull String value) {
        this.directory = Objects.requireNonNull(value, "directory");
        return this.self();
    }

    @Override
    @Nonnull
    public GitInitBuilder quiet(boolean value) {
        this.quiet = value;
        return this.self();
    }

    @Override
    @Nonnull
    public GitInitBuilder shared(String value) {
        this.shared = value;
        return this.self();
    }

    @Override
    @Nonnull
    public GitInitBuilder template(@Nullable File value) {
        return this.template(value == null ? null : value.getAbsolutePath());
    }

    @Override
    @Nonnull
    public GitInitBuilder template(@Nullable Path value) {
        return this.template(value == null ? null : value.toAbsolutePath().toString());
    }

    @Override
    @Nonnull
    public GitInitBuilder template(@Nullable String value) {
        this.template = value;
        return this.self();
    }

    @Override
    protected void applyArguments() {
        if (this.bare) {
            this.builder.argument("--bare");
        }
        if (this.quiet) {
            this.builder.argument("--quiet");
        }
        if (StringUtils.isNotBlank((CharSequence)this.shared)) {
            this.builder.argument("--shared=" + this.shared);
        }
        if (StringUtils.isNotBlank((CharSequence)this.template)) {
            this.builder.argument("--template=" + this.template);
        }
        this.builder.argument(this.directory);
    }

    @Override
    @Nonnull
    protected DefaultGitInitBuilder self() {
        return this;
    }
}

