/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command.log;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.CommandExitHandler;
import com.atlassian.bitbucket.scm.CommandOutputHandler;
import com.atlassian.bitbucket.scm.CommandUsageException;
import com.atlassian.bitbucket.scm.git.command.GitCommand;
import com.atlassian.bitbucket.scm.git.command.diff.GitDiffOutput;
import com.atlassian.bitbucket.scm.git.command.log.GitLogBuilder;
import com.atlassian.stash.internal.scm.git.command.GitFreeFormCommandBuilder;
import com.atlassian.stash.internal.scm.git.command.log.LogCommandExitHandler;
import com.atlassian.stash.internal.scm.git.command.revlist.AbstractGitRevCoreBuilder;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class DefaultGitLogBuilder
extends AbstractGitRevCoreBuilder<GitLogBuilder>
implements GitLogBuilder {
    private final I18nService i18nService;
    private final Repository repository;
    private boolean follow;
    private GitDiffOutput output;
    private boolean useDefaultExitHandler;

    public DefaultGitLogBuilder(GitFreeFormCommandBuilder builder, I18nService i18nService, Repository repository) {
        super((GitFreeFormCommandBuilder)builder.command("log"));
        this.i18nService = i18nService;
        this.repository = repository;
        this.output = GitDiffOutput.DEFAULT;
        this.useDefaultExitHandler = true;
    }

    @Override
    @Nonnull
    public <T> GitCommand<T> build(@Nonnull CommandOutputHandler<T> outputHandler) {
        if (this.useDefaultExitHandler) {
            this.builder.exitHandler((CommandExitHandler)new LogCommandExitHandler(this.i18nService, this.repository, this.ignoreMissing));
        }
        GitCommand<T> command = super.build(outputHandler);
        if (this.skip > 0 && this.follow) {
            throw new CommandUsageException(this.i18nService.createKeyedMessage("bitbucket.scm.git.invalid.syntax", new Object[0]), command.toString(), "Setting --skip and --follow at the same time is not supported");
        }
        return command;
    }

    @Override
    @Nonnull
    public GitLogBuilder defaultExitHandler() {
        this.useDefaultExitHandler = true;
        return this.self();
    }

    @Override
    @Nonnull
    public GitLogBuilder exitHandler(@Nonnull CommandExitHandler value) {
        super.exitHandler(value);
        this.useDefaultExitHandler = false;
        return this.self();
    }

    @Nonnull
    public GitLogBuilder follow(boolean value) {
        this.follow = value;
        return this.self();
    }

    @Nonnull
    public GitLogBuilder output(@Nonnull GitDiffOutput value) {
        this.output = Objects.requireNonNull(value, "output");
        return this.self();
    }

    @Override
    protected void applyFlags() {
        super.applyFlags();
        if (this.follow) {
            this.builder.argument("--follow");
        }
        if (this.output.isFlagged()) {
            this.builder.argument(this.output.getFlag());
        }
    }

    @Override
    protected void applyRevs() {
        this.revs.forEach(arg_0 -> ((GitFreeFormCommandBuilder)this.builder).commitish(arg_0));
    }

    @Override
    @Nonnull
    protected GitLogBuilder self() {
        return this;
    }
}

